/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;

@CleanupObligation
@NotThreadSafe
public class SeekableByteBufferChannel
implements SeekableByteChannel {
    private ByteBuffer buffer;
    private long position;
    private boolean closed;

    @CreatesObligation
    public SeekableByteBufferChannel(ByteBuffer byteBuffer) {
        this.buffer = (ByteBuffer)byteBuffer.duplicate().rewind();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer.duplicate();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int read(ByteBuffer byteBuffer) throws IOException {
        int n2;
        this.checkOpen();
        int n3 = byteBuffer.remaining();
        if (n3 <= 0) {
            return 0;
        }
        long l2 = this.position;
        ByteBuffer byteBuffer2 = this.buffer;
        if (l2 >= (long)byteBuffer2.limit()) {
            return -1;
        }
        byteBuffer2.position((int)l2);
        int n4 = byteBuffer2.remaining();
        if (n4 > n3) {
            n2 = byteBuffer2.limit();
            byteBuffer2.limit(byteBuffer2.position() + n3);
        } else {
            n2 = -1;
            n3 = n4;
        }
        try {
            byteBuffer.put(byteBuffer2);
        }
        finally {
            if (0 <= n2) {
                byteBuffer2.limit(n2);
            }
        }
        assert ((long)byteBuffer2.position() == l2 + (long)n3);
        this.position += (long)n3;
        return n3;
    }

    @Override
    public final int write(ByteBuffer byteBuffer) throws IOException {
        this.checkOpen();
        if (this.position > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        int n2 = (int)this.position;
        int n3 = byteBuffer.remaining();
        int n4 = n2 + n3;
        ByteBuffer byteBuffer2 = this.buffer;
        int n5 = byteBuffer2.limit();
        if (0 > n5 - n4) {
            int n6 = byteBuffer2.capacity();
            if (0 <= n6 - n4) {
                byteBuffer2.limit(n4).position(n2);
            } else {
                if (0 > n4) {
                    throw new OutOfMemoryError();
                }
                if (byteBuffer2.isReadOnly()) {
                    throw new NonWritableChannelException();
                }
                int n7 = n6 << 1;
                if (0 > n7 - n4) {
                    n7 = n4;
                }
                if (0 > n7) {
                    n7 = Integer.MAX_VALUE;
                }
                assert (n4 <= n7);
                this.buffer = byteBuffer2 = (ByteBuffer)(byteBuffer2.isDirect() ? ByteBuffer.allocateDirect(n7) : ByteBuffer.allocate(n7)).put((ByteBuffer)byteBuffer2.position(0).limit(n2)).limit(n4);
            }
        } else {
            byteBuffer2.position(n2);
        }
        assert (byteBuffer2.position() == n2);
        try {
            byteBuffer2.put(byteBuffer);
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            throw new NonWritableChannelException();
        }
        assert (byteBuffer2.position() == n4);
        this.position = n4;
        return n3;
    }

    @Override
    public final long position() throws IOException {
        this.checkOpen();
        return this.position;
    }

    @Override
    public final SeekableByteBufferChannel position(long l2) throws IOException {
        this.checkOpen();
        if (0L > l2) {
            throw new IllegalArgumentException();
        }
        this.position = l2;
        return this;
    }

    @Override
    public final long size() throws IOException {
        this.checkOpen();
        return this.buffer.limit();
    }

    @Override
    public final SeekableByteBufferChannel truncate(long l2) throws IOException {
        this.checkOpen();
        if (this.buffer.isReadOnly()) {
            throw new NonWritableChannelException();
        }
        if ((long)this.buffer.limit() > l2) {
            this.buffer.limit((int)l2);
        }
        if (this.position > l2) {
            this.position = l2;
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.closed = true;
    }
}

