/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.util.AbstractExceptionBuilder;
import java.lang.reflect.Constructor;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SequentialIOExceptionBuilder<C extends Exception, X extends SequentialIOException>
extends AbstractExceptionBuilder<C, X> {
    private final Class<X> assemblyClass;
    private volatile Constructor<X> assemblyConstructor;

    public static SequentialIOExceptionBuilder<Exception, SequentialIOException> create() {
        return SequentialIOExceptionBuilder.create(Exception.class, SequentialIOException.class);
    }

    public static <C extends Exception> SequentialIOExceptionBuilder<C, SequentialIOException> create(Class<C> clazz) {
        return SequentialIOExceptionBuilder.create(clazz, SequentialIOException.class);
    }

    public static <C extends Exception, X extends SequentialIOException> SequentialIOExceptionBuilder<C, X> create(Class<C> clazz, Class<X> clazz2) {
        return new SequentialIOExceptionBuilder<C, X>(clazz, clazz2);
    }

    public SequentialIOExceptionBuilder(Class<C> clazz, Class<X> clazz2) {
        this.assemblyClass = clazz2;
        try {
            if (!clazz2.isAssignableFrom(clazz)) {
                this.wrap(null);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException.getCause());
        }
    }

    private Class<X> assemblyClass() {
        return this.assemblyClass;
    }

    private Constructor<X> assemblyConstructor() {
        Constructor<X> constructor = this.assemblyConstructor;
        return null != constructor ? constructor : (this.assemblyConstructor = this.newAssemblyConstructor());
    }

    private Constructor<X> newAssemblyConstructor() {
        try {
            return this.assemblyClass().getConstructor(String.class);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    protected final X update(C c2, X x2) {
        SequentialIOException sequentialIOException = null;
        if (this.assemblyClass().isInstance(c2) && (sequentialIOException = (SequentialIOException)c2).isInitPredecessor()) {
            if (null == x2) {
                return (X)sequentialIOException;
            }
            sequentialIOException = null;
        }
        if (null == sequentialIOException) {
            sequentialIOException = this.wrap(c2);
        }
        sequentialIOException.initPredecessor((SequentialIOException)x2);
        return (X)sequentialIOException;
    }

    private X wrap(@CheckForNull C c2) {
        X x2 = this.newAssembly(SequentialIOExceptionBuilder.toString(c2));
        ((SequentialIOException)x2).initCause((Throwable)c2);
        return x2;
    }

    private static String toString(@CheckForNull Object object) {
        return null == object ? "" : object.toString();
    }

    private X newAssembly(String string) {
        Constructor<X> constructor = this.assemblyConstructor();
        try {
            try {
                return (X)((SequentialIOException)constructor.newInstance(string));
            }
            catch (IllegalAccessException illegalAccessException) {
                constructor.setAccessible(true);
                return (X)((SequentialIOException)constructor.newInstance(string));
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    protected final X post(X x2) {
        return (X)((SequentialIOException)x2).sortPriority();
    }
}

