/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.SafeKeyProvider;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class SafeKeyManager<K extends SafeKey<K>, P extends SafeKeyProvider<K>>
implements KeyManager<K> {
    private final Map<URI, P> providers = new HashMap<URI, P>();

    protected SafeKeyManager() {
    }

    protected abstract P newKeyProvider();

    public synchronized P getKeyProvider(URI uRI) {
        if (null == uRI) {
            throw new NullPointerException();
        }
        SafeKeyProvider<Object> safeKeyProvider = (SafeKeyProvider)this.providers.get(uRI);
        if (null == safeKeyProvider) {
            safeKeyProvider = this.newKeyProvider();
            this.providers.put(uRI, safeKeyProvider);
        }
        return (P)safeKeyProvider;
    }

    @Nullable
    public synchronized P getMappedKeyProvider(URI uRI) {
        if (null == uRI) {
            throw new NullPointerException();
        }
        return (P)((SafeKeyProvider)this.providers.get(uRI));
    }

    public synchronized P moveKeyProvider(URI uRI, URI uRI2) {
        if (null == uRI2) {
            throw new NullPointerException();
        }
        if (uRI.equals(uRI2)) {
            throw new IllegalArgumentException();
        }
        SafeKeyProvider safeKeyProvider = (SafeKeyProvider)this.providers.remove(uRI);
        if (null != safeKeyProvider) {
            return (P)this.providers.put(uRI2, safeKeyProvider);
        }
        return (P)((SafeKeyProvider)this.providers.remove(uRI2));
    }

    public synchronized P removeKeyProvider(URI uRI) {
        if (null == uRI) {
            throw new NullPointerException();
        }
        SafeKeyProvider safeKeyProvider = (SafeKeyProvider)this.providers.remove(uRI);
        if (null != safeKeyProvider) {
            safeKeyProvider.setKey(null);
        }
        return (P)safeKeyProvider;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public String toString() {
        return String.format("%s[priority=%d]", this.getClass().getName(), this.getPriority());
    }
}

