/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.crypto.SuspensionPenalty;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class SafeKeyProvider<K extends SafeKey<K>>
implements KeyProvider<K> {
    public static final int MIN_KEY_RETRY_DELAY = 3000;
    @CheckForNull
    private volatile K key;
    private final ThreadLocal<Long> invalidated = new ThreadLocal();

    protected SafeKeyProvider() {
    }

    @Override
    public final K getWriteKey() throws UnknownKeyException {
        this.retrieveWriteKey();
        return this.getNonNullKey();
    }

    protected abstract void retrieveWriteKey() throws UnknownKeyException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final K getReadKey(boolean bl2) throws UnknownKeyException {
        if (bl2) {
            this.invalidated.set(System.currentTimeMillis());
        }
        try {
            this.retrieveReadKey(bl2);
            Long l2 = this.invalidated.get();
            SuspensionPenalty.enforce(null == l2 ? 0L : l2);
        }
        catch (Throwable throwable) {
            Long l3 = this.invalidated.get();
            SuspensionPenalty.enforce(null == l3 ? 0L : l3);
            throw throwable;
        }
        return this.getNonNullKey();
    }

    protected abstract void retrieveReadKey(boolean var1) throws UnknownKeyException;

    private K getNonNullKey() throws UnknownKeyException {
        K k2 = this.getKey();
        if (null == k2) {
            throw new UnknownKeyException();
        }
        return k2;
    }

    @CheckForNull
    protected K getKey() {
        K k2 = this.key;
        return (K)(null == k2 ? null : (SafeKey)k2.clone());
    }

    @Override
    public void setKey(@CheckForNull K k2) {
        K k3 = this.key;
        SafeKey safeKey = this.key = null == k2 ? null : (SafeKey)k2.clone();
        if (null != k3) {
            k3.reset();
        }
    }
}

