/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.io.swing.FileComboBoxBrowser;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AuthenticationPanel
extends JPanel {
    private static final long serialVersionUID = 3876515923659236921L;
    private static final String CLASS_NAME = AuthenticationPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final File BASE_DIR = FileSystemView.getFileSystemView().getDefaultDirectory();
    static final int AUTH_PASSWD = 0;
    static final int AUTH_KEY_FILE = 1;
    private final JComboBox keyFile = new JComboBox();
    private final JButton keyFileChooser = new JButton();
    private final EnhancedPanel keyFilePanel = new EnhancedPanel();
    private JTabbedPane tabs;

    public AuthenticationPanel() {
        this.initComponents();
        new FileComboBoxBrowser(this.keyFile).setDirectory(BASE_DIR);
        ((JTextField)this.keyFile.getEditor().getEditorComponent()).setColumns(30);
    }

    public void setPasswdPanel(JPanel jPanel) {
        if (jPanel == null) {
            throw new NullPointerException();
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String string = resources.getString("tab.passwd");
        if (string.equals(this.tabs.getTitleAt(0))) {
            this.tabs.removeTabAt(0);
        }
        this.tabs.insertTab(string, null, jPanel, null, 0);
        this.tabs.setSelectedIndex(0);
        this.revalidate();
    }

    Document getKeyFileDocument() {
        return ((JTextComponent)this.keyFile.getEditor().getEditorComponent()).getDocument();
    }

    public File getKeyFile() {
        String string = (String)this.keyFile.getSelectedItem();
        File file = new File(string);
        return file.isAbsolute() ? file : new File(BASE_DIR.getPath(), string);
    }

    private void setKeyFile(File file) {
        String string;
        String string2 = file.getPath();
        if (string2.startsWith(string = BASE_DIR.getPath())) {
            string2 = string2.substring(string.length() + 1);
        }
        if (string2.equals(string = (String)this.keyFile.getSelectedItem())) {
            return;
        }
        this.keyFile.setSelectedItem(string2);
    }

    public int getAuthenticationMethod() {
        int n2 = this.tabs.getSelectedIndex();
        switch (n2) {
            case 0: {
                assert (resources.getString("tab.passwd").equals(this.tabs.getTitleAt(n2)));
                break;
            }
            case 1: {
                assert (resources.getString("tab.keyFile").equals(this.tabs.getTitleAt(n2)));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported authentication method!");
            }
        }
        return n2;
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        JLabel jLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyFilePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.keyFilePanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent panelEvent) {
                AuthenticationPanel.this.keyFilePanelAncestorWindowShown(panelEvent);
            }

            public void ancestorWindowHidden(PanelEvent panelEvent) {
            }
        });
        this.keyFilePanel.setLayout((LayoutManager)new GridBagLayout());
        jLabel.setDisplayedMnemonic(resources.getString("keyFile").charAt(0));
        jLabel.setLabelFor(this.keyFile);
        jLabel.setText(resources.getString("keyFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.keyFilePanel.add((Component)jLabel, (Object)gridBagConstraints);
        this.keyFile.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keyFilePanel.add((Component)this.keyFile, (Object)gridBagConstraints);
        this.keyFileChooser.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        this.keyFileChooser.setToolTipText(resources.getString("selectKeyFile.toolTip"));
        this.keyFileChooser.setName("keyFileChooser");
        this.keyFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthenticationPanel.this.keyFileChooserActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.keyFilePanel.add((Component)this.keyFileChooser, (Object)gridBagConstraints);
        this.tabs.addTab(resources.getString("tab.keyFile"), (Component)this.keyFilePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabs, gridBagConstraints);
    }

    private void keyFileChooserActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = AuthenticationPanel.newFileChooser();
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.setKeyFile(jFileChooser.getSelectedFile());
        }
    }

    private static JFileChooser newFileChooser() {
        JFileChooser jFileChooser = new JFileChooser(BASE_DIR);
        jFileChooser.setDialogTitle(resources.getString("fileChooser.title"));
        jFileChooser.setFileHidingEnabled(false);
        return jFileChooser;
    }

    private void keyFilePanelAncestorWindowShown(PanelEvent panelEvent) {
        final Window window = panelEvent.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AuthenticationPanel.this.keyFile.requestFocusInWindow()) {
                            ((JTextComponent)AuthenticationPanel.this.keyFile.getEditor().getEditorComponent()).selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }
}

