/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.key.pbe.swing.BasicInvalidKeyFeedback;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HurlingWindowFeedback
extends BasicInvalidKeyFeedback {
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;
    public static final int AMPLITUDE = 25;
    public static final int CYCLE = 150;
    public static final int DURATION = 1500;
    public static final int FPS = 75;
    private final double amplitude;
    private final double cycle;
    private final int duration;
    private final int fps;

    public HurlingWindowFeedback() {
        this(25, 150, 1500, 75);
    }

    protected HurlingWindowFeedback(int n2, int n3, int n4, int n5) {
        super(n4 > 3000 ? n4 : 3000);
        this.amplitude = n2;
        this.cycle = n3;
        this.duration = n4;
        this.fps = n5;
    }

    @Override
    public void run(JPanel jPanel) {
        final Window window = SwingUtilities.getWindowAncestor(jPanel);
        super.run(jPanel);
        if (null == window) {
            return;
        }
        final Point point = window.getLocation();
        final long l2 = System.currentTimeMillis();
        Timer timer = new Timer(1000 / this.fps, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l22 = System.currentTimeMillis() - l2;
                if (l22 < (long)HurlingWindowFeedback.this.duration && window.isShowing()) {
                    double d2 = Math.PI * 2 * (double)l22 / HurlingWindowFeedback.this.cycle;
                    double d3 = Math.sin(Math.PI * (double)l22 / (double)HurlingWindowFeedback.this.duration) * HurlingWindowFeedback.this.amplitude;
                    int n2 = (int)(Math.cos(d2) * d3 + (double)point.x);
                    int n3 = (int)(Math.sin(d2) * d3 + (double)point.y);
                    window.setLocation(n2, n3);
                    window.repaint();
                } else {
                    ((Timer)actionEvent.getSource()).stop();
                    window.setLocation(point);
                    window.repaint();
                }
            }
        });
        timer.start();
    }
}

