/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.awt.Windows;
import de.schlichtherle.truezip.crypto.param.KeyStrength;
import de.schlichtherle.truezip.key.KeyPromptingInterruptedException;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import de.schlichtherle.truezip.key.pbe.SafePbeParametersView;
import de.schlichtherle.truezip.key.pbe.swing.BasicInvalidKeyFeedback;
import de.schlichtherle.truezip.key.pbe.swing.BasicUnknownKeyFeedback;
import de.schlichtherle.truezip.key.pbe.swing.InvalidKeyFeedback;
import de.schlichtherle.truezip.key.pbe.swing.KeyStrengthPanel;
import de.schlichtherle.truezip.key.pbe.swing.ReadKeyPanel;
import de.schlichtherle.truezip.key.pbe.swing.UnknownKeyFeedback;
import de.schlichtherle.truezip.key.pbe.swing.WriteKeyPanel;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

@ThreadSafe
public abstract class SwingSafePbeParametersView<S extends KeyStrength, P extends SafePbeParameters<S, P>>
extends SafePbeParametersView<P> {
    private static final ResourceBundle resources = ResourceBundle.getBundle(SwingSafePbeParametersView.class.getName());
    static final URI INITIAL_RESOURCE = URI.create("");
    public static final int KEY_FILE_LEN = 512;
    private static final Map<URI, ReadKeyPanel> readKeyPanels = new WeakHashMap<URI, ReadKeyPanel>();
    private static final ServiceLocator serviceLocator = new ServiceLocator(SwingSafePbeParametersView.class.getClassLoader());
    static volatile URI lastResource = INITIAL_RESOURCE;
    private volatile UnknownKeyFeedback unknownKeyFeedback;
    private volatile InvalidKeyFeedback invalidKeyFeedback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readKeyFile(File file) throws IOException {
        byte[] byArray = new byte[512];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            randomAccessFile.readFully(byArray);
        }
        finally {
            randomAccessFile.close();
        }
        return byArray;
    }

    UnknownKeyFeedback getUnknownKeyFeedback() {
        UnknownKeyFeedback unknownKeyFeedback = this.unknownKeyFeedback;
        return null != unknownKeyFeedback ? unknownKeyFeedback : (this.unknownKeyFeedback = (UnknownKeyFeedback)serviceLocator.getService(UnknownKeyFeedback.class, BasicUnknownKeyFeedback.class));
    }

    void setUnkownKeyFeedback(UnknownKeyFeedback unknownKeyFeedback) {
        this.unknownKeyFeedback = unknownKeyFeedback;
    }

    InvalidKeyFeedback getInvalidKeyFeedback() {
        InvalidKeyFeedback invalidKeyFeedback = this.invalidKeyFeedback;
        return null != invalidKeyFeedback ? invalidKeyFeedback : (this.invalidKeyFeedback = (InvalidKeyFeedback)serviceLocator.getService(InvalidKeyFeedback.class, BasicInvalidKeyFeedback.class));
    }

    void setInvalidKeyFeedback(InvalidKeyFeedback invalidKeyFeedback) {
        this.invalidKeyFeedback = invalidKeyFeedback;
    }

    @Override
    public void promptWriteKey(final PromptingKeyProvider.Controller<P> controller) throws UnknownKeyException {
        class PromptWriteKey
        implements Runnable {
            PromptWriteKey() {
            }

            @Override
            public void run() {
                SwingSafePbeParametersView.this.promptWriteKeyEDT(controller);
            }
        }
        SwingSafePbeParametersView.multiplexOnEDT(new PromptWriteKey());
    }

    private void promptWriteKeyEDT(PromptingKeyProvider.Controller<P> controller) {
        assert (EventQueue.isDispatchThread());
        URI uRI = controller.getResource();
        assert (null != uRI);
        SafePbeParameters safePbeParameters = (SafePbeParameters)controller.getKey();
        if (null == safePbeParameters) {
            safePbeParameters = this.newPbeParameters();
        }
        KeyStrengthPanel keyStrengthPanel = new KeyStrengthPanel(safePbeParameters.getKeyStrengthValues());
        keyStrengthPanel.setKeyStrength(safePbeParameters.getKeyStrength());
        WriteKeyPanel writeKeyPanel = new WriteKeyPanel();
        writeKeyPanel.setExtraDataUI((JComponent)((Object)keyStrengthPanel));
        Window window = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            writeKeyPanel.setResource(uRI);
            writeKeyPanel.setFeedback(writeKeyPanel.getError() != null ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
            int n2 = JOptionPane.showConfirmDialog(window, (Object)writeKeyPanel, resources.getString("writeKeyDialog.title"), 2, 3);
            if (n2 != 0) break;
            if (writeKeyPanel.updateParam(safePbeParameters)) {
                safePbeParameters.setKeyStrength(keyStrengthPanel.getKeyStrength());
                controller.setKey(safePbeParameters);
                break;
            }
            assert (writeKeyPanel.getError() != null);
        }
    }

    @Override
    public void promptReadKey(final PromptingKeyProvider.Controller<P> controller, final boolean bl2) throws UnknownKeyException {
        class PromptReadKey
        implements Runnable {
            PromptReadKey() {
            }

            @Override
            public void run() {
                SwingSafePbeParametersView.this.promptReadKeyEDT(controller, bl2);
            }
        }
        SwingSafePbeParametersView.multiplexOnEDT(new PromptReadKey());
    }

    private void promptReadKeyEDT(PromptingKeyProvider.Controller<P> controller, boolean bl2) {
        Object object;
        Object object2;
        assert (EventQueue.isDispatchThread());
        URI uRI = controller.getResource();
        assert (null != uRI);
        Object p2 = this.newPbeParameters();
        if (bl2) {
            object2 = readKeyPanels.get(uRI);
            object = object2 != null ? object2 : new ReadKeyPanel();
            object.setError(resources.getString("invalidKey"));
        } else {
            object = new ReadKeyPanel();
        }
        readKeyPanels.put(uRI, (ReadKeyPanel)((Object)object));
        object2 = Windows.getParentWindow();
        while (!Thread.interrupted()) {
            object.setResource(uRI);
            object.setFeedback(null != object.getError() ? this.getInvalidKeyFeedback() : this.getUnknownKeyFeedback());
            int n2 = JOptionPane.showConfirmDialog((Component)object2, object, resources.getString("readKeyDialog.title"), 2, 3);
            if (n2 != 0) {
                controller.setKey(null);
                break;
            }
            if (object.updateParam((SafePbeParameters<?, ?>)p2)) {
                controller.setKey(p2);
                controller.setChangeRequested(object.isChangeKeySelected());
                break;
            }
            assert (object.getError() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void multiplexOnEDT(Runnable runnable) throws UnknownKeyException {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return;
        }
        Class<SwingSafePbeParametersView> clazz = SwingSafePbeParametersView.class;
        synchronized (SwingSafePbeParametersView.class) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                throw new KeyPromptingInterruptedException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new UnknownKeyException(invocationTargetException);
            }
            return;
        }
    }
}

