/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class OctetCharset
extends Charset {
    protected static final char REPLACEMENT = '\ufffd';
    private final char[] byte2char;
    private final char[][] char2byte;

    protected OctetCharset(String string, String[] stringArray, char[] cArray) {
        stringArray = (String[])stringArray.clone();
        super(string, stringArray);
        cArray = (char[])cArray.clone();
        char[][] cArrayArray = new char[256][];
        for (int n2 = 0; n2 < 256; n2 = (int)((char)(n2 + 1))) {
            char c2 = cArray[n2];
            if (c2 == '\ufffd') continue;
            int n3 = c2 >>> 8;
            int n4 = c2 & 0xFF;
            char[] cArray2 = cArrayArray[n3];
            if (cArray2 == null) {
                cArray2 = new char[256];
                Arrays.fill(cArray2, '\ufffd');
                cArrayArray[n3] = cArray2;
            }
            cArray2[n4] = n2;
        }
        this.byte2char = cArray;
        this.char2byte = cArrayArray;
    }

    @Override
    public boolean contains(Charset charset) {
        return this.getClass().isInstance(charset);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder();
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder();
    }

    private class Decoder
    extends CharsetDecoder {
        Decoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            char[] cArray = OctetCharset.this.byte2char;
            while (byteBuffer.hasRemaining()) {
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c2 = cArray[byteBuffer.get() & 0xFF];
                if (c2 == '\ufffd') {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                charBuffer.put(c2);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private class Encoder
    extends CharsetEncoder {
        Encoder() {
            super(OctetCharset.this, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[][] cArray = OctetCharset.this.char2byte;
            while (charBuffer.hasRemaining()) {
                char c2;
                if (!byteBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c3 = charBuffer.get();
                int n2 = c3 >>> 8;
                int n3 = c3 & 0xFF;
                char[] cArray2 = cArray[n2];
                if (cArray2 == null || (c2 = cArray2[n3]) == '\ufffd') {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                byteBuffer.put((byte)c2);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

