/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.charset;

import de.schlichtherle.truezip.nio.charset.Ibm437Charset;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ZipCharsetProvider
extends CharsetProvider {
    private static final Map<String, Charset> CHARSETS;

    private static String lowerCase(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    @Override
    public Iterator<Charset> charsets() {
        return CHARSETS.values().iterator();
    }

    @Override
    public Charset charsetForName(String string) {
        return CHARSETS.get(ZipCharsetProvider.lowerCase(string));
    }

    static {
        Logger logger = Logger.getLogger(ZipCharsetProvider.class.getName(), ZipCharsetProvider.class.getName());
        HashMap<String, Charset> hashMap = new HashMap<String, Charset>();
        for (Charset charset : new Charset[]{new Ibm437Charset()}) {
            hashMap.put(ZipCharsetProvider.lowerCase(charset.name()), charset);
            for (String string : charset.aliases()) {
                hashMap.put(ZipCharsetProvider.lowerCase(string), charset);
            }
            logger.log(Level.CONFIG, "providing", new Object[]{charset.displayName(), charset.aliases()});
        }
        CHARSETS = Collections.unmodifiableMap(hashMap);
    }
}

