/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BufferedReadOnlyFile
extends DecoratingReadOnlyFile {
    private static final long INVALID = Long.MIN_VALUE;
    public static final int WINDOW_LEN = 8192;
    private long pos;
    private long bufferStart = Long.MIN_VALUE;
    private final byte[] buffer;

    protected static long min(long l2, long l3) {
        return l2 < l3 ? l2 : l3;
    }

    protected static long max(long l2, long l3) {
        return l2 < l3 ? l3 : l2;
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(File file) throws IOException {
        this(null, file, 8192);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(File file, int n2) throws IOException {
        this(null, file, n2);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile) throws IOException {
        this(readOnlyFile, null, 8192);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public BufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile, int n2) throws IOException {
        this(readOnlyFile, null, n2);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private BufferedReadOnlyFile(@CheckForNull @WillCloseWhenClosed ReadOnlyFile readOnlyFile, @CheckForNull File file, int n2) throws IOException {
        super(BufferedReadOnlyFile.check(readOnlyFile, file, n2));
        this.buffer = new byte[n2];
    }

    private static ReadOnlyFile check(@CheckForNull @WillCloseWhenClosed ReadOnlyFile readOnlyFile, @CheckForNull File file, int n2) throws FileNotFoundException {
        if (0 >= n2) {
            throw new IllegalArgumentException();
        }
        if (null != readOnlyFile) {
            assert (null == file);
            return readOnlyFile;
        }
        return new DefaultReadOnlyFile(file);
    }

    protected final void assertOpen() throws IOException {
        if (null == this.delegate) {
            throw new IOException("File is closed!");
        }
    }

    @Override
    public int read() throws IOException {
        this.assertOpen();
        if (this.pos >= this.delegate.length()) {
            return -1;
        }
        this.positionBuffer();
        return this.buffer[(int)(this.pos++ % (long)this.buffer.length)] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return 0;
        }
        long l2 = this.length();
        if (this.getFilePointer() >= l2) {
            return -1;
        }
        if (0 > (n2 | n3 | byArray.length - n2 - n3)) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        int n5 = this.buffer.length;
        while (n4 < n3 && this.pos < l2) {
            this.positionBuffer();
            int n6 = (int)(this.pos - this.bufferStart);
            int n7 = Math.min(n3 - n4, n5 - n6);
            n7 = (int)Math.min((long)n7, l2 - this.pos);
            assert (n7 > 0);
            System.arraycopy(this.buffer, n6, byArray, n2 + n4, n7);
            n4 += n7;
            this.pos += (long)n7;
        }
        return n4;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.assertOpen();
        return this.pos;
    }

    @Override
    public void seek(long l2) throws IOException {
        this.assertOpen();
        if (l2 < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        long l3 = this.delegate.length();
        if (l2 > l3) {
            throw new IOException("File pointer (" + l2 + ") is larger than file length (" + l3 + ")!");
        }
        this.pos = l2;
    }

    @Override
    public long length() throws IOException {
        this.assertOpen();
        return this.delegate.length();
    }

    @Override
    public void close() throws IOException {
        if (null == this.delegate) {
            return;
        }
        this.delegate.close();
        this.delegate = null;
    }

    private void positionBuffer() throws IOException {
        byte[] byArray = this.buffer;
        int n2 = byArray.length;
        long l2 = this.pos;
        long l3 = this.bufferStart;
        long l4 = l3 + (long)n2;
        if (l3 <= l2 && l2 < l4) {
            return;
        }
        try {
            int n3;
            ReadOnlyFile readOnlyFile = this.delegate;
            this.bufferStart = l3 = l2 / (long)n2 * (long)n2;
            if (l3 != l4) {
                readOnlyFile.seek(l3);
            }
            int n4 = 0;
            while ((n3 = readOnlyFile.read(byArray, n4, n2 - n4)) >= 0 && (n4 += n3) < n2) {
            }
        }
        catch (IOException iOException) {
            this.bufferStart = Long.MIN_VALUE;
            throw iOException;
        }
    }
}

