/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IntervalReadOnlyFile
extends DecoratingReadOnlyFile {
    private final long offset;
    private final long length;
    private final boolean exclusive;
    private long fp;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public IntervalReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile, long l2) throws IOException {
        this(readOnlyFile, readOnlyFile.getFilePointer(), l2, true);
    }

    @CreatesObligation
    public IntervalReadOnlyFile(@Nullable @WillNotClose ReadOnlyFile readOnlyFile, long l2, long l3) throws IOException {
        this(readOnlyFile, l2, l3, false);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private IntervalReadOnlyFile(@Nullable ReadOnlyFile readOnlyFile, long l2, long l3, boolean bl2) throws IOException {
        super(readOnlyFile);
        if (l2 < 0L || l3 < 0L || readOnlyFile.length() < l2 + l3) {
            throw new IllegalArgumentException();
        }
        this.offset = l2;
        this.length = l3;
        this.exclusive = bl2;
    }

    @Override
    public long length() throws IOException {
        long l2 = this.length;
        if (this.delegate.length() < this.offset + l2) {
            throw new IOException("Read Only File has been changed!");
        }
        return l2;
    }

    @Override
    public long getFilePointer() throws IOException {
        this.delegate.getFilePointer();
        return this.fp;
    }

    @Override
    public void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException("File pointer must not be negative!");
        }
        long l3 = this.length;
        if (l2 > l3) {
            throw new IOException("File pointer (" + l2 + ") is larger than file length (" + l3 + ")!");
        }
        this.delegate.seek(l2 + this.offset);
        this.fp = l2;
    }

    @Override
    public int read() throws IOException {
        long l2 = this.fp;
        if (l2 >= this.length) {
            return -1;
        }
        if (!this.exclusive) {
            this.delegate.seek(l2 + this.offset);
        }
        int n2 = this.delegate.read();
        this.fp = l2 + 1L;
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (0 == n3) {
            return 0;
        }
        if (0 > (n2 | n3 | byArray.length - n2 - n3)) {
            throw new IndexOutOfBoundsException();
        }
        long l2 = this.fp;
        long l3 = this.length;
        if (l2 + (long)n3 > l3) {
            n3 = (int)(l3 - l2);
        }
        if (!this.exclusive) {
            this.delegate.seek(l2 + this.offset);
        }
        int n4 = this.delegate.read(byArray, n2, n3);
        if (0 == n3) {
            assert (0 >= n4);
            return -1;
        }
        assert (0 < n4);
        this.fp = l2 + (long)n4;
        return n4;
    }

    @Override
    public void close() throws IOException {
        if (this.exclusive) {
            this.delegate.close();
        }
    }
}

