/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DelegatingInputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class ClutchInputSocket<E extends Entry>
extends DelegatingInputSocket<E> {
    @CheckForNull
    InputSocket<? extends E> delegate;

    @Override
    protected final InputSocket<? extends E> getDelegate() throws IOException {
        InputSocket<? extends E> inputSocket = this.delegate;
        return null != inputSocket ? inputSocket : (this.delegate = this.getLazyDelegate());
    }

    protected abstract InputSocket<? extends E> getLazyDelegate() throws IOException;

    @Override
    public E getLocalTarget() throws IOException {
        try {
            return (E)((Entry)this.getBoundSocket().getLocalTarget());
        }
        catch (Throwable throwable) {
            throw this.reset(throwable);
        }
    }

    @Override
    public ReadOnlyFile newReadOnlyFile() throws IOException {
        try {
            return this.getBoundSocket().newReadOnlyFile();
        }
        catch (Throwable throwable) {
            throw this.reset(throwable);
        }
    }

    @Override
    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        try {
            return this.getBoundSocket().newSeekableByteChannel();
        }
        catch (Throwable throwable) {
            throw this.reset(throwable);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        try {
            return this.getBoundSocket().newInputStream();
        }
        catch (Throwable throwable) {
            throw this.reset(throwable);
        }
    }

    private IOException reset(Throwable throwable) {
        this.reset();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return (IOException)throwable;
    }

    protected final void reset() {
        this.delegate = null;
    }
}

