/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class InputSocket<E extends Entry>
extends IOSocket<E, Entry> {
    @CheckForNull
    private OutputSocket<?> peer;

    @Override
    @Nullable
    public final Entry getPeerTarget() throws IOException {
        return null == this.peer ? null : (Entry)this.peer.getLocalTarget();
    }

    public final InputSocket<E> bind(InputSocket<?> inputSocket) {
        if (this == inputSocket) {
            throw new IllegalArgumentException();
        }
        this.peer = inputSocket.peer;
        return this;
    }

    final InputSocket<E> connect(@CheckForNull OutputSocket<?> outputSocket) {
        OutputSocket<?> outputSocket2 = this.peer;
        if (outputSocket2 != outputSocket) {
            if (null != outputSocket2) {
                this.peer = null;
                outputSocket2.connect(null);
            }
            if (null != outputSocket) {
                this.peer = outputSocket;
                outputSocket.connect(this);
            }
        }
        return this;
    }

    @CreatesObligation
    public abstract ReadOnlyFile newReadOnlyFile() throws IOException;

    @CreatesObligation
    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    @CreatesObligation
    public InputStream newInputStream() throws IOException {
        return new ReadOnlyFileInputStream(this.newReadOnlyFile());
    }
}

