/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.MutableEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.util.JointIterator;
import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MultiplexedOutputShop<E extends MutableEntry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private final IOPool<?> pool;
    private final Map<String, BufferedEntryOutputStream> buffers = new LinkedHashMap<String, BufferedEntryOutputStream>();
    private boolean busy;

    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public MultiplexedOutputShop(@WillCloseWhenClosed OutputShop<E> outputShop, IOPool<?> iOPool) {
        super(outputShop);
        this.pool = iOPool;
        if (null == this.pool) {
            throw new NullPointerException();
        }
    }

    @Override
    public int getSize() {
        return ((OutputShop)this.delegate).getSize() + this.buffers.size();
    }

    @Override
    public Iterator<E> iterator() {
        return new JointIterator(((OutputShop)this.delegate).iterator(), new BufferedEntriesIterator());
    }

    @Override
    @CheckForNull
    public E getEntry(String string) {
        MutableEntry mutableEntry = (MutableEntry)((OutputShop)this.delegate).getEntry(string);
        if (null != mutableEntry) {
            return (E)mutableEntry;
        }
        BufferedEntryOutputStream bufferedEntryOutputStream = this.buffers.get(string);
        return null == bufferedEntryOutputStream ? null : (E)bufferedEntryOutputStream.getLocalTarget();
    }

    @Override
    public OutputSocket<? extends E> getOutputSocket(E e2) {
        if (null == e2) {
            throw new NullPointerException();
        }
        final class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ MutableEntry val$local;

            Output() {
                this.val$local = mutableEntry;
                super(MultiplexedOutputShop.super.getOutputSocket(mutableEntry));
            }

            @Override
            public E getLocalTarget() throws IOException {
                return this.val$local;
            }

            @Override
            @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
            public OutputStream newOutputStream() throws IOException {
                OutputSocket outputSocket = this.getBoundSocket();
                return MultiplexedOutputShop.this.isBusy() ? new BufferedEntryOutputStream(outputSocket) : new EntryOutputStream(outputSocket);
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        if (this.isBusy()) {
            throw new IOException("This multiplexed output shop is still busy with writing a stream!");
        }
        this.storeBuffers();
        assert (this.buffers.isEmpty());
        ((OutputShop)this.delegate).close();
    }

    final void storeBuffers() throws IOException {
        if (this.isBusy()) {
            return;
        }
        SequentialIOExceptionBuilder<IOException, SequentialIOException> sequentialIOExceptionBuilder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
        Iterator<BufferedEntryOutputStream> iterator = this.buffers.values().iterator();
        while (iterator.hasNext()) {
            BufferedEntryOutputStream bufferedEntryOutputStream = iterator.next();
            try {
                if (!bufferedEntryOutputStream.storeBuffer()) continue;
                iterator.remove();
            }
            catch (InputException inputException) {
                sequentialIOExceptionBuilder.warn(inputException);
            }
            catch (IOException iOException) {
                throw (SequentialIOException)sequentialIOExceptionBuilder.fail(iOException);
            }
        }
        sequentialIOExceptionBuilder.check();
    }

    @CleanupObligation
    private final class BufferedEntryOutputStream
    extends DecoratingOutputStream {
        final InputSocket<Entry> input;
        final OutputSocket<? extends E> output;
        final IOPool.Entry<?> buffer;
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        BufferedEntryOutputStream(OutputSocket<? extends E> outputSocket) throws IOException {
            super(null);
            this.output = outputSocket;
            MutableEntry mutableEntry = (MutableEntry)this.output.getLocalTarget();
            Entry entry = outputSocket.getPeerTarget();
            final IOPool.Entry entry2 = this.buffer = (IOPool.Entry)MultiplexedOutputShop.this.pool.allocate();
            final Entry entry3 = null != entry ? entry : entry2;
            try {
                final class InputProxy
                extends DecoratingInputSocket<Entry> {
                    InputProxy() {
                        super(entry.getInputSocket());
                    }

                    @Override
                    public Entry getLocalTarget() {
                        return entry3;
                    }
                }
                this.input = new InputProxy();
                this.delegate = entry2.getOutputSocket().newOutputStream();
            }
            catch (IOException iOException) {
                block4: {
                    try {
                        entry2.release();
                    }
                    catch (IOException iOException2) {
                        if (!JSE7.AVAILABLE) break block4;
                        iOException.addSuppressed(iOException2);
                    }
                }
                throw iOException;
            }
            MultiplexedOutputShop.this.buffers.put(mutableEntry.getName(), this);
        }

        E getLocalTarget() {
            try {
                return (MutableEntry)this.output.getLocalTarget();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            SequentialIOExceptionBuilder<IOException, SequentialIOException> sequentialIOExceptionBuilder = SequentialIOExceptionBuilder.create(IOException.class, SequentialIOException.class);
            if (!this.closed) {
                this.closed = true;
                try {
                    this.delegate.close();
                    MutableEntry mutableEntry = (MutableEntry)this.output.getLocalTarget();
                    if (this == MultiplexedOutputShop.this.buffers.get(mutableEntry.getName())) {
                        this.updateProperties(mutableEntry, (Entry)this.input.getLocalTarget());
                    } else {
                        this.discardBuffer();
                    }
                }
                catch (IOException iOException) {
                    sequentialIOExceptionBuilder.warn(iOException);
                }
            }
            try {
                MultiplexedOutputShop.this.storeBuffers();
            }
            catch (IOException iOException) {
                sequentialIOExceptionBuilder.warn(iOException);
            }
            sequentialIOExceptionBuilder.check();
        }

        void updateProperties(E e2, Entry entry) {
            for (Entry.Access access : Entry.ALL_ACCESS_SET) {
                if (-1L != e2.getTime(access)) continue;
                e2.setTime(access, entry.getTime(access));
            }
            if (-1L == e2.getSize(Entry.Size.DATA)) {
                e2.setSize(Entry.Size.DATA, entry.getSize(Entry.Size.DATA));
            }
        }

        void discardBuffer() throws IOException {
            assert (this.closed);
            this.buffer.release();
        }

        boolean storeBuffer() throws InputException, IOException {
            if (!this.closed || MultiplexedOutputShop.this.isBusy()) {
                return false;
            }
            IOSocket.copy(this.input, this.output);
            this.buffer.release();
            return true;
        }
    }

    @CleanupObligation
    private final class EntryOutputStream
    extends DecoratingOutputStream {
        boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryOutputStream(OutputSocket<? extends E> outputSocket) throws IOException {
            super(outputSocket.newOutputStream());
            MultiplexedOutputShop.this.busy = true;
        }

        @Override
        @DischargesObligation
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                MultiplexedOutputShop.this.busy = false;
                this.delegate.close();
            }
            MultiplexedOutputShop.this.storeBuffers();
        }
    }

    private class BufferedEntriesIterator
    implements Iterator<E> {
        final Iterator<BufferedEntryOutputStream> i;

        private BufferedEntriesIterator() {
            this.i = MultiplexedOutputShop.this.buffers.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public E next() {
            return this.i.next().getLocalTarget();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

