/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket.sl;

import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.spi.IOPoolDecorator;
import de.schlichtherle.truezip.socket.spi.IOPoolService;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IOPoolLocator
implements IOPoolProvider {
    public static final IOPoolLocator SINGLETON = new IOPoolLocator();

    private IOPoolLocator() {
    }

    @Override
    public IOPool<?> get() {
        return Boot.pool;
    }

    private static final class Boot {
        static final IOPool<?> pool;

        private Boot() {
        }

        private static IOPool<?> create(ServiceLocator serviceLocator, Logger logger) {
            Object object;
            IOPoolService iOPoolService = serviceLocator.getService(IOPoolService.class, null);
            if (null == iOPoolService) {
                object = serviceLocator.getServices(IOPoolService.class);
                while (object.hasNext()) {
                    int n2;
                    IOPoolService iOPoolService2 = object.next();
                    logger.log(Level.CONFIG, "located", iOPoolService2);
                    if (null == iOPoolService) {
                        iOPoolService = iOPoolService2;
                        continue;
                    }
                    int n3 = iOPoolService.getPriority();
                    if (n3 < (n2 = iOPoolService2.getPriority())) {
                        iOPoolService = iOPoolService2;
                        continue;
                    }
                    if (n3 != n2) continue;
                    logger.log(Level.WARNING, "collision", new Object[]{n3, iOPoolService, iOPoolService2});
                }
            }
            if (null == iOPoolService) {
                throw new ServiceConfigurationError(MessageFormat.format(ResourceBundle.getBundle(IOPoolLocator.class.getName()).getString("null"), IOPoolService.class));
            }
            logger.log(Level.CONFIG, "using", iOPoolService);
            object = iOPoolService.get();
            logger.log(Level.CONFIG, "result", object);
            return object;
        }

        private static <B extends IOPool.Entry<B>> IOPool<B> decorate(IOPool<B> iOPool, ServiceLocator serviceLocator, Logger logger) {
            ArrayList<IOPoolDecorator> arrayList = new ArrayList<IOPoolDecorator>();
            IOPoolDecorator[] iOPoolDecoratorArray = serviceLocator.getServices(IOPoolDecorator.class);
            while (iOPoolDecoratorArray.hasNext()) {
                arrayList.add(iOPoolDecoratorArray.next());
            }
            iOPoolDecoratorArray = arrayList.toArray(new IOPoolDecorator[arrayList.size()]);
            Arrays.sort(iOPoolDecoratorArray, new Comparator<IOPoolDecorator>(){

                @Override
                public int compare(IOPoolDecorator iOPoolDecorator, IOPoolDecorator iOPoolDecorator2) {
                    return iOPoolDecorator.getPriority() - iOPoolDecorator2.getPriority();
                }
            });
            for (IOPoolDecorator iOPoolDecorator : iOPoolDecoratorArray) {
                logger.log(Level.CONFIG, "decorating", iOPoolDecorator);
                iOPool = iOPoolDecorator.decorate(iOPool);
                logger.log(Level.CONFIG, "result", iOPool);
            }
            return iOPool;
        }

        static {
            Class<IOPoolLocator> clazz = IOPoolLocator.class;
            Logger logger = Logger.getLogger(clazz.getName(), clazz.getName());
            ServiceLocator serviceLocator = new ServiceLocator(clazz.getClassLoader());
            pool = Boot.decorate(Boot.create(serviceLocator, logger), serviceLocator, logger);
        }
    }
}

