/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BitField<E extends Enum<E>>
implements Serializable,
Iterable<E> {
    private static final long serialVersionUID = 3203876204846746524L;
    private final EnumSet<E> bits;

    public static <E extends Enum<E>> BitField<E> noneOf(Class<E> clazz) {
        return new BitField<E>(clazz, false);
    }

    public static <E extends Enum<E>> BitField<E> allOf(Class<E> clazz) {
        return new BitField<E>(clazz, true);
    }

    public static <E extends Enum<E>> BitField<E> of(E e2) {
        return new BitField<E>(e2);
    }

    public static <E extends Enum<E>> BitField<E> of(E e2, E ... EArray) {
        return new BitField(e2, EArray);
    }

    public static <E extends Enum<E>> BitField<E> copyOf(Collection<E> collection) {
        return new BitField<E>(EnumSet.copyOf(collection));
    }

    public static <E extends Enum<E>> BitField<E> of(Class<E> clazz, String string) {
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        for (String string2 : string.split("\\|")) {
            enumSet.add(Enum.valueOf(clazz, string2));
        }
        return new BitField<E>(enumSet);
    }

    private BitField(Class<E> clazz, boolean bl2) {
        this.bits = bl2 ? EnumSet.allOf(clazz) : EnumSet.noneOf(clazz);
    }

    private BitField(E e2) {
        this.bits = EnumSet.of(e2);
    }

    private BitField(E e2, E ... EArray) {
        this.bits = EnumSet.of(e2, EArray);
    }

    private BitField(EnumSet<E> enumSet) {
        assert (null != enumSet);
        this.bits = enumSet;
    }

    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    public int cardinality() {
        return this.bits.size();
    }

    public boolean get(E e2) {
        return this.bits.contains(e2);
    }

    public boolean is(E e2) {
        return this.bits.contains(e2);
    }

    public BitField<E> set(E e2, boolean bl2) {
        Object object;
        if (bl2) {
            if (this.bits.contains(e2)) {
                return this;
            }
            object = this.bits.clone();
            ((AbstractCollection)object).add(e2);
        } else {
            if (!this.bits.contains(e2)) {
                return this;
            }
            object = this.bits.clone();
            ((AbstractCollection)object).remove(e2);
        }
        return new BitField<E>(object);
    }

    public BitField<E> set(E e2) {
        return this.set(e2, true);
    }

    public BitField<E> clear(E e2) {
        return this.set(e2, false);
    }

    public BitField<E> not() {
        return new BitField<E>(EnumSet.complementOf(this.bits));
    }

    public BitField<E> and(BitField<E> bitField) {
        Object object = this.bits.clone();
        return ((AbstractCollection)object).retainAll(bitField.bits) ? new BitField<E>(object) : this;
    }

    public BitField<E> or(BitField<E> bitField) {
        Object object = this.bits.clone();
        return ((AbstractCollection)object).addAll(bitField.bits) ? new BitField<E>(object) : this;
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableSet(this.bits).iterator();
    }

    public EnumSet<E> toEnumSet() {
        return this.bits.clone();
    }

    public String toString() {
        int n2 = this.bits.size() * 11;
        if (0 >= n2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (Enum enum_ : this.bits) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(enum_);
        }
        return stringBuilder.toString();
    }

    public boolean equals(@CheckForNull Object object) {
        return this == object || object instanceof BitField && this.bits.equals(((BitField)object).bits);
    }

    public int hashCode() {
        return this.bits.hashCode();
    }
}

