/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public interface Link<T> {
    @Nullable
    public T getTarget();

    public static enum Type {
        STRONG{

            @Override
            <T> Link<T> newLink(T t2, ReferenceQueue<? super T> referenceQueue) {
                return new Strong<T>(t2);
            }
        }
        ,
        SOFT{

            @Override
            <T> Link<T> newLink(T t2, ReferenceQueue<? super T> referenceQueue) {
                return new Soft<T>(t2, referenceQueue);
            }
        }
        ,
        WEAK{

            @Override
            <T> Link<T> newLink(T t2, ReferenceQueue<? super T> referenceQueue) {
                return new Weak<T>(t2, referenceQueue);
            }
        }
        ,
        PHANTOM{

            @Override
            public <T> Link<T> newLink(T t2, ReferenceQueue<? super T> referenceQueue) {
                return new Phantom<T>(t2, referenceQueue);
            }
        };


        public <T> Link<T> newLink(T t2) {
            return this.newLink(t2, null);
        }

        abstract <T> Link<T> newLink(T var1, @CheckForNull ReferenceQueue<? super T> var2);

        private static final class Phantom<T>
        extends PhantomReference<T>
        implements Link<T> {
            Phantom(T t2, ReferenceQueue<? super T> referenceQueue) {
                super(t2, referenceQueue);
            }

            @Override
            public T getTarget() {
                return super.get();
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.getTarget());
            }
        }

        private static final class Weak<T>
        extends WeakReference<T>
        implements Link<T> {
            Weak(T t2, ReferenceQueue<? super T> referenceQueue) {
                super(t2, referenceQueue);
            }

            @Override
            public T getTarget() {
                return super.get();
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.getTarget());
            }
        }

        private static final class Soft<T>
        extends SoftReference<T>
        implements Link<T> {
            Soft(T t2, ReferenceQueue<? super T> referenceQueue) {
                super(t2, referenceQueue);
            }

            @Override
            public T getTarget() {
                return super.get();
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.getTarget());
            }
        }

        private static final class Strong<T>
        implements Link<T> {
            private final T target;

            Strong(T t2) {
                this.target = t2;
            }

            @Override
            public T getTarget() {
                return this.target;
            }

            public String toString() {
                return String.format("%s[target=%s]", this.getClass().getName(), this.getTarget());
            }
        }
    }
}

