/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import javax.annotation.concurrent.Immutable;

@Immutable
public class ThreadGroups {
    private ThreadGroups() {
    }

    public static ThreadGroup getThreadGroup() {
        SecurityManager securityManager = System.getSecurityManager();
        return null != securityManager ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public static ThreadGroup getServerThreadGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = ThreadGroups.getThreadGroup();
        while (null != (threadGroup = threadGroup2.getParent())) {
            try {
                threadGroup.checkAccess();
            }
            catch (SecurityException securityException) {
                break;
            }
            threadGroup2 = threadGroup;
        }
        return threadGroup2;
    }

    public static ThreadGroup getTopLevel() {
        return ThreadGroups.getServerThreadGroup();
    }
}

