/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.io.DecoratingInputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class CountingInputStream
extends DecoratingInputStream {
    private long bytesRead;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    CountingInputStream(@Nullable @WillCloseWhenClosed InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.delegate.read(byArray, n2, n3);
        if (n4 > 0) {
            this.bytesRead += (long)n4;
        }
        return n4;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.delegate.read();
        if (n2 != -1) {
            ++this.bytesRead;
        }
        return n2;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = this.delegate.skip(l2);
        this.bytesRead += l3;
        return l3;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

