/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.DefaultExtraField;
import de.schlichtherle.truezip.zip.UShort;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class ExtraField {
    private static final Map<Integer, Class<? extends ExtraField>> registry = new HashMap<Integer, Class<? extends ExtraField>>();
    static final int ZIP64_HEADER_ID = 1;
    static final int WINZIP_AES_ID = 39169;

    ExtraField() {
    }

    static void register(Class<? extends ExtraField> clazz) {
        ExtraField extraField;
        try {
            extraField = clazz.newInstance();
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        int n2 = extraField.getHeaderId();
        assert (UShort.check(n2));
        registry.put(n2, clazz);
    }

    static ExtraField create(int n2) {
        ExtraField extraField;
        assert (UShort.check(n2));
        Class<? extends ExtraField> clazz = registry.get(n2);
        try {
            extraField = null != clazz ? clazz.newInstance() : new DefaultExtraField(n2);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
        assert (n2 == extraField.getHeaderId());
        return extraField;
    }

    abstract int getHeaderId();

    abstract int getDataSize();

    final byte[] getDataBlock() {
        int n2 = this.getDataSize();
        assert (UShort.check(n2));
        if (0 == n2) {
            return Constants.EMPTY;
        }
        byte[] byArray = new byte[n2];
        this.writeTo(byArray, 0);
        return byArray;
    }

    abstract void readFrom(byte[] var1, int var2, int var3) throws IndexOutOfBoundsException, IllegalArgumentException;

    abstract void writeTo(byte[] var1, int var2) throws IndexOutOfBoundsException;

    static {
        ExtraField.register(WinZipAesEntryExtraField.class);
    }
}

