/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class LittleEndian {
    private LittleEndian() {
    }

    static byte readByte(byte[] byArray, int n2) {
        return byArray[n2];
    }

    static int readUByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    static int readShort(byte[] byArray, int n2) {
        return byArray[n2 + 1] << 8 | byArray[n2] & 0xFF;
    }

    static int readUShort(byte[] byArray, int n2) {
        return (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    static int readInt(byte[] byArray, int n2) {
        n2 += 3;
        int n3 = byArray[n2--];
        n3 <<= 8;
        n3 |= byArray[n2--] & 0xFF;
        n3 <<= 8;
        n3 |= byArray[n2--] & 0xFF;
        n3 <<= 8;
        return n3 |= byArray[n2] & 0xFF;
    }

    static long readUInt(byte[] byArray, int n2) {
        return (long)LittleEndian.readInt(byArray, n2) & 0xFFFFFFFFL;
    }

    static long readLong(byte[] byArray, int n2) {
        n2 += 7;
        long l2 = byArray[n2--];
        l2 <<= 8;
        l2 |= (long)(byArray[n2--] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2--] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2--] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2--] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2--] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2--] & 0xFF);
        l2 <<= 8;
        return l2 |= (long)(byArray[n2] & 0xFF);
    }

    static void writeByte(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
    }

    static void writeShort(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >>= 8);
    }

    static void writeInt(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)n2;
        byArray[n3 + 1] = (byte)(n2 >>= 8);
        byArray[n3 + 2] = (byte)(n2 >>= 8);
        byArray[n3 + 3] = (byte)(n2 >>= 8);
    }

    static void writeLong(long l2, byte[] byArray, int n2) {
        byArray[n2] = (byte)l2;
        byArray[n2 + 1] = (byte)(l2 >>= 8);
        byArray[n2 + 2] = (byte)(l2 >>= 8);
        byArray[n2 + 3] = (byte)(l2 >>= 8);
        byArray[n2 + 4] = (byte)(l2 >>= 8);
        byArray[n2 + 5] = (byte)(l2 >>= 8);
        byArray[n2 + 6] = (byte)(l2 >>= 8);
        byArray[n2 + 7] = (byte)(l2 >>= 8);
    }
}

