/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.rof.BufferedReadOnlyFile;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.IntervalReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.Pool;
import de.schlichtherle.truezip.zip.CRC32Exception;
import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.CountingInputStream;
import de.schlichtherle.truezip.zip.Crc32InputStream;
import de.schlichtherle.truezip.zip.DummyByteInputStream;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.OffsetPositionMapper;
import de.schlichtherle.truezip.zip.PositionMapper;
import de.schlichtherle.truezip.zip.SingleReadOnlyFilePool;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import de.schlichtherle.truezip.zip.WinZipAesEntryReadOnlyFile;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.WinZipAesUtils;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipEntryFactory;
import de.schlichtherle.truezip.zip.ZipFileParameters;
import de.schlichtherle.truezip.zip.ZipInflaterInputStream;
import de.schlichtherle.truezip.zip.ZipParametersUtils;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

@NotThreadSafe
public abstract class RawZipFile<E extends ZipEntry>
implements Closeable,
Iterable<E> {
    private static final int LFH_FILE_NAME_LENGTH_OFF = 26;
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    @CheckForNull
    private ReadOnlyFile rof;
    private long length;
    private long preamble;
    private long postamble;
    private final ZipEntryFactory<E> param;
    private Charset charset;
    @CheckForNull
    private byte[] comment;
    private Map<String, E> entries;
    private PositionMapper mapper = new PositionMapper();
    private int open;

    @CreatesObligation
    protected RawZipFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile, ZipFileParameters<E> zipFileParameters) throws IOException {
        this(new SingleReadOnlyFilePool(readOnlyFile), zipFileParameters);
    }

    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    RawZipFile(Pool<ReadOnlyFile, IOException> pool, ZipFileParameters<E> zipFileParameters) throws IOException {
        if (null == zipFileParameters) {
            throw new NullPointerException();
        }
        ReadOnlyFile readOnlyFile = pool.allocate();
        try {
            this.rof = readOnlyFile;
            this.length = readOnlyFile.length();
            this.param = zipFileParameters;
            this.charset = zipFileParameters.getCharset();
            SafeBufferedReadOnlyFile safeBufferedReadOnlyFile = new SafeBufferedReadOnlyFile(readOnlyFile, this.length);
            if (!zipFileParameters.getPreambled()) {
                this.checkZipFileSignature(safeBufferedReadOnlyFile);
            }
            int n2 = this.findCentralDirectory(safeBufferedReadOnlyFile, zipFileParameters.getPostambled());
            this.mountCentralDirectory(safeBufferedReadOnlyFile, n2);
            if (this.preamble + this.postamble >= this.length) {
                assert (0 == n2);
                if (zipFileParameters.getPreambled()) {
                    this.checkZipFileSignature(safeBufferedReadOnlyFile);
                }
            }
        }
        catch (IOException iOException) {
            pool.release(readOnlyFile);
            throw iOException;
        }
        assert (null != this.rof);
        assert (null != this.charset);
        assert (null != this.entries);
        assert (null != this.mapper);
    }

    private void checkZipFileSignature(ReadOnlyFile readOnlyFile) throws IOException {
        byte[] byArray = new byte[4];
        readOnlyFile.seek(this.preamble);
        readOnlyFile.readFully(byArray);
        long l2 = LittleEndian.readUInt(byArray, 0);
        if (67324752L != l2 && 101075792L != l2 && 101010256L != l2) {
            throw new ZipException("Expected Local File Header or (ZIP64) End Of Central Directory Record!");
        }
    }

    private int findCentralDirectory(ReadOnlyFile readOnlyFile, boolean bl2) throws IOException {
        byte[] byArray = new byte[4];
        long l2 = this.length - 22L;
        long l3 = !bl2 && l2 >= 65535L ? l2 - 65535L : 0L;
        for (long i2 = l2; i2 >= l3; --i2) {
            readOnlyFile.seek(i2);
            readOnlyFile.readFully(byArray);
            if (101010256L != LittleEndian.readUInt(byArray, 0)) continue;
            byte[] byArray2 = new byte[22 - byArray.length];
            readOnlyFile.readFully(byArray2);
            int n2 = 0;
            long l4 = LittleEndian.readUShort(byArray2, n2);
            long l5 = LittleEndian.readUShort(byArray2, n2 += 2);
            long l6 = LittleEndian.readUShort(byArray2, n2 += 2);
            long l7 = LittleEndian.readUShort(byArray2, n2 += 2);
            n2 += 2;
            if (0L != l4 || 0L != l5 || l6 != l7) {
                throw new ZipException("ZIP file spanning/splitting is not supported!");
            }
            long l8 = LittleEndian.readUInt(byArray2, n2);
            long l9 = LittleEndian.readUInt(byArray2, n2 += 4);
            int n3 = LittleEndian.readUShort(byArray2, n2 += 4);
            if (0 < n3) {
                byte[] byArray3 = new byte[n3];
                readOnlyFile.readFully(byArray3);
                this.comment = byArray3;
            }
            this.preamble = i2;
            this.postamble = this.length - readOnlyFile.getFilePointer();
            long l10 = i2 - 20L;
            if (0L > l10) {
                long l11 = i2 - l8;
                readOnlyFile.seek(l11);
                if (0L != (l11 -= l9)) {
                    this.mapper = new OffsetPositionMapper(l11);
                }
                return (int)l7;
            }
            readOnlyFile.seek(l10);
            byte[] byArray4 = new byte[20];
            readOnlyFile.readFully(byArray4);
            if (117853008L != LittleEndian.readUInt(byArray4, 0)) {
                long l12 = i2 - l8;
                readOnlyFile.seek(l12);
                if (0L != (l12 -= l9)) {
                    this.mapper = new OffsetPositionMapper(l12);
                }
                return (int)l7;
            }
            n2 = 4;
            long l13 = LittleEndian.readUInt(byArray4, n2);
            long l14 = LittleEndian.readLong(byArray4, n2 += 4);
            long l15 = LittleEndian.readUInt(byArray4, n2 += 8);
            if (0L != l13 || 1L != l15) {
                throw new ZipException("ZIP file spanning/splitting is not supported!");
            }
            byte[] byArray5 = new byte[56];
            readOnlyFile.seek(l14);
            readOnlyFile.readFully(byArray5);
            n2 = 0;
            if (101075792L != LittleEndian.readUInt(byArray5, n2)) {
                throw new ZipException("Expected ZIP64 End Of Central Directory Record!");
            }
            n2 += 4;
            n2 += 8;
            n2 += 2;
            l4 = LittleEndian.readUInt(byArray5, n2 += 2);
            l5 = LittleEndian.readUInt(byArray5, n2 += 4);
            l6 = LittleEndian.readLong(byArray5, n2 += 4);
            l7 = LittleEndian.readLong(byArray5, n2 += 8);
            n2 += 8;
            if (0L != l4 || 0L != l5 || l6 != l7) {
                throw new ZipException("ZIP file spanning/splitting is not supported!");
            }
            if (l7 < 0L || Integer.MAX_VALUE < l7) {
                throw new ZipException("Total Number Of Entries In The Central Directory out of range!");
            }
            l9 = LittleEndian.readLong(byArray5, n2 += 8);
            readOnlyFile.seek(l9);
            this.preamble = l14;
            return (int)l7;
        }
        this.preamble = l3;
        this.postamble = this.length - l3;
        return 0;
    }

    private void mountCentralDirectory(ReadOnlyFile readOnlyFile, int n2) throws IOException {
        LinkedHashMap<String, E> linkedHashMap = new LinkedHashMap<String, E>(Math.max(HashMaps.initialCapacity(n2), 16));
        byte[] byArray = new byte[46];
        while (true) {
            boolean bl2;
            readOnlyFile.readFully(byArray, 0, 4);
            if (33639248L != LittleEndian.readUInt(byArray, 0)) break;
            readOnlyFile.readFully(byArray, 4, 42);
            int n3 = LittleEndian.readUShort(byArray, 8);
            int n4 = LittleEndian.readUShort(byArray, 28);
            byte[] byArray2 = new byte[n4];
            readOnlyFile.readFully(byArray2);
            boolean bl3 = bl2 = 0 != (n3 & 0x800);
            if (bl2) {
                this.charset = Constants.UTF8;
            }
            E e2 = this.param.newEntry(this.decode(byArray2));
            try {
                byte[] byArray3;
                int n5 = 0;
                ((ZipEntry)e2).setRawPlatform(LittleEndian.readUShort(byArray, n5 += 4) >> 8);
                n5 += 2;
                n5 += 2;
                ((ZipEntry)e2).setGeneralPurposeBitFlags(n3);
                ((ZipEntry)e2).setRawMethod(LittleEndian.readUShort(byArray, n5 += 2));
                ((ZipEntry)e2).setRawTime(LittleEndian.readUInt(byArray, n5 += 2));
                ((ZipEntry)e2).setRawCrc(LittleEndian.readUInt(byArray, n5 += 4));
                ((ZipEntry)e2).setRawCompressedSize(LittleEndian.readUInt(byArray, n5 += 4));
                ((ZipEntry)e2).setRawSize(LittleEndian.readUInt(byArray, n5 += 4));
                n5 += 4;
                int n6 = LittleEndian.readUShort(byArray, n5 += 2);
                int n7 = LittleEndian.readUShort(byArray, n5 += 2);
                n5 += 2;
                n5 += 2;
                ((ZipEntry)e2).setRawExternalAttributes(LittleEndian.readUInt(byArray, n5 += 2));
                long l2 = LittleEndian.readUInt(byArray, n5 += 4);
                ((ZipEntry)e2).setRawOffset(l2);
                if (0 < n6) {
                    byArray3 = new byte[n6];
                    readOnlyFile.readFully(byArray3);
                    ((ZipEntry)e2).setRawExtraFields(byArray3);
                }
                if (0 < n7) {
                    byArray3 = new byte[n7];
                    readOnlyFile.readFully(byArray3);
                    ((ZipEntry)e2).setRawComment(this.decode(byArray3));
                }
                if ((l2 = this.mapper.map(((ZipEntry)e2).getOffset())) < this.preamble) {
                    this.preamble = l2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (ZipException)new ZipException(((ZipEntry)e2).getName() + " (invalid meta data)").initCause(illegalArgumentException);
            }
            linkedHashMap.put(((ZipEntry)e2).getName(), e2);
            --n2;
        }
        if (0 != n2 % 65536) {
            throw new ZipException("Expected " + Math.abs(n2) + (n2 > 0 ? " more" : " less") + " entries in the Central Directory!");
        }
        this.entries = linkedHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void recoverLostEntries() throws IOException {
        var1_1 = this.length;
        var3_2 = new SafeBufferedReadOnlyFile(this.rof(), var1_1);
        while (0L < this.postamble) {
            block33: {
                var4_3 = var1_1 - this.postamble;
                var3_2.seek(var4_3);
                var6_4 = new byte[30];
                var3_2.readFully(var6_4);
                if (67324752L != LittleEndian.readUInt(var6_4, 0)) {
                    throw new ZipException("Expected Local File Header!");
                }
                var7_5 = LittleEndian.readUShort(var6_4, 6);
                var8_6 = LittleEndian.readUShort(var6_4, 26);
                var9_7 = new byte[var8_6];
                var3_2.readFully(var9_7);
                v0 = var10_8 = 0 != (var7_5 & 2048);
                if (var10_8) {
                    this.charset = Constants.UTF8;
                }
                var11_9 = this.param.newEntry(this.decode(var9_7));
                try {
                    var12_10 = 0;
                    var12_10 += 4;
                    var12_10 += 2;
                    var11_9.setGeneralPurposeBitFlags(var7_5);
                    var11_9.setRawMethod(LittleEndian.readUShort(var6_4, var12_10 += 2));
                    var11_9.setRawTime(LittleEndian.readUInt(var6_4, var12_10 += 2));
                    var11_9.setRawCrc(LittleEndian.readUInt(var6_4, var12_10 += 4));
                    var11_9.setRawCompressedSize(LittleEndian.readUInt(var6_4, var12_10 += 4));
                    var11_9.setRawSize(LittleEndian.readUInt(var6_4, var12_10 += 4));
                    var12_10 += 4;
                    var13_12 = LittleEndian.readUShort(var6_4, var12_10 += 2);
                    var11_9.setRawOffset(this.mapper.unmap(var4_3));
                    if (0 < var13_12) {
                        var14_13 = new byte[var13_12];
                        var3_2.readFully(var14_13);
                        var11_9.setRawExtraFields(var14_13);
                    }
                    if (var11_9.getGeneralPurposeBitFlag(8)) {
                        var14_14 = var4_3 = var3_2.getFilePointer();
                        var16_15 /* !! */  = new IntervalReadOnlyFile(var3_2, var4_3, var1_1 - var4_3);
                        var17_16 = null;
                        var18_17 = var11_9.getMethod();
                        if (var11_9.isEncrypted()) {
                            if (99 != var18_17) {
                                throw new ZipException(var11_9.getName() + " (encrypted compression method " + var18_17 + " is not supported)");
                            }
                            var16_15 /* !! */  = new WinZipAesEntryReadOnlyFile(var16_15 /* !! */ , new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), (ZipEntry)var11_9));
                            var17_16 = (WinZipAesEntryExtraField)var11_9.getExtraField(39169);
                            var18_17 = var17_16.getMethod();
                        }
                        var19_18 = RawZipFile.getBufferSize(var11_9);
                        var20_19 = null;
                        switch (var18_17) {
                            case 8: {
                                var21_20 = new ZipInflaterInputStream(new DummyByteInputStream(var16_15 /* !! */ ), var19_18);
                                break;
                            }
                            case 12: {
                                var20_19 = new CountingInputStream(new ReadOnlyFileInputStream(var16_15 /* !! */ ));
                                var21_20 = new BZip2CompressorInputStream(var20_19);
                                break;
                            }
                            default: {
                                throw new ZipException(var11_9.getName() + " (compression method " + var18_17 + " is not supported)");
                            }
                        }
                        var22_21 = new CheckedInputStream(var21_20, new CRC32());
                        try {
                            var11_9.setRawSize(var22_21.skip(0x7FFFFFFFFFFFFFFFL));
                            if (null != var17_16 && var17_16.getVendorVersion() == 2) {
                                var11_9.setRawCrc(0L);
                            } else {
                                var11_9.setRawCrc(var22_21.getChecksum().getValue());
                            }
                            switch (var18_17) {
                                case 8: {
                                    var23_22 = var21_20.getInflater();
                                    if (!RawZipFile.$assertionsDisabled && !var23_22.finished()) {
                                        throw new AssertionError();
                                    }
                                    var4_3 += var23_22.getBytesRead();
                                    ** break;
lbl72:
                                    // 1 sources

                                    break;
                                }
                                case 12: {
                                    var4_3 += var20_19.getBytesRead();
                                    ** break;
lbl76:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        finally {
                            var22_21.close();
                        }
                        if (null != var17_16) {
                            var4_3 += (long)WinZipAesUtils.overhead(var17_16.getKeyStrength());
                        }
                        var11_9.setRawCompressedSize(var4_3 - var14_14);
                        var23_22 = new byte[var11_9.isZip64ExtensionsRequired() != false ? 20 : 12];
                        var3_2.seek(var4_3);
                        var3_2.readFully((byte[])var23_22, 0, 4);
                        var24_23 = LittleEndian.readUInt((byte[])var23_22, 0);
                        if (134695760L == var24_23) {
                            var3_2.readFully((byte[])var23_22);
                        } else {
                            var3_2.readFully((byte[])var23_22, 4, ((Object)var23_22).length - 4);
                        }
                        var24_23 = LittleEndian.readUInt((byte[])var23_22, 0);
                        if (var11_9.isZip64ExtensionsRequired()) {
                            var26_25 = LittleEndian.readLong((byte[])var23_22, 4);
                            var28_26 = LittleEndian.readLong((byte[])var23_22, 12);
                        } else {
                            var26_25 = LittleEndian.readUInt((byte[])var23_22, 4);
                            var28_26 = LittleEndian.readUInt((byte[])var23_22, 8);
                        }
                        if (var11_9.getCrc() != var24_23) {
                            throw new CRC32Exception(var11_9.getName(), var11_9.getCrc(), var24_23);
                        }
                        if (var11_9.getCompressedSize() != var26_25) {
                            throw new ZipException(var11_9.getName() + " (invalid compressed size in Data Descriptor)");
                        }
                        if (var11_9.getSize() != var28_26) {
                            throw new ZipException(var11_9.getName() + " (invalid uncompressed size in Data Descriptor)");
                        }
                        break block33;
                    }
                    var3_2.seek((var4_3 += var11_9.getCompressedSize()) - 1L);
                    if (var4_3 > var1_1 || -1 == var3_2.read()) {
                        throw new ZipException(var11_9.getName() + " (truncated ZIP entry)");
                    }
                }
                catch (IllegalArgumentException var12_11) {
                    throw (ZipException)new ZipException(var11_9.getName() + " (invalid meta data)").initCause(var12_11);
                }
            }
            this.postamble = var1_1 - var3_2.getFilePointer();
            this.entries.put(var11_9.getName(), var11_9);
        }
    }

    final Map<String, E> getRawEntries() {
        return this.entries;
    }

    private String decode(byte[] byArray) {
        return new String(byArray, this.charset);
    }

    @CheckForNull
    final byte[] getRawComment() {
        return this.comment;
    }

    @Nullable
    public String getComment() {
        byte[] byArray = this.comment;
        return null == byArray ? null : this.decode(byArray);
    }

    public boolean busy() {
        return 0 < this.open;
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public E getEntry(String string) {
        return (E)((ZipEntry)this.entries.get(string));
    }

    public long length() {
        return this.length;
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    @CreatesObligation
    public InputStream getPreambleInputStream() throws IOException {
        this.rof();
        return new ReadOnlyFileInputStream(new EntryReadOnlyFile(0L, this.preamble));
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    @CreatesObligation
    public InputStream getPostambleInputStream() throws IOException {
        this.rof();
        return new ReadOnlyFileInputStream(new EntryReadOnlyFile(this.length - this.postamble, this.postamble));
    }

    final PositionMapper getOffsetMapper() {
        return this.mapper;
    }

    public boolean offsetsConsiderPreamble() {
        assert (this.mapper != null);
        return 0L == this.mapper.map(0L);
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    @CreatesObligation
    @Nullable
    public final InputStream getInputStream(String string) throws IOException {
        return this.getInputStream(string, null, true);
    }

    @CreatesObligation
    @Nullable
    public final InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.getName(), null, true);
    }

    @CreatesObligation
    @Nullable
    public final InputStream getCheckedInputStream(String string) throws IOException {
        return this.getInputStream(string, true, true);
    }

    @CreatesObligation
    @Nullable
    public final InputStream getCheckedInputStream(ZipEntry zipEntry) throws IOException {
        return this.getInputStream(zipEntry.getName(), true, true);
    }

    @CreatesObligation
    @Nullable
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected InputStream getInputStream(String string, @CheckForNull Boolean bl2, boolean bl3) throws IOException {
        DecoratingReadOnlyFile decoratingReadOnlyFile;
        ReadOnlyFile readOnlyFile = this.rof();
        if (string == null) {
            throw new NullPointerException();
        }
        ZipEntry zipEntry = (ZipEntry)this.entries.get(string);
        if (zipEntry == null) {
            return null;
        }
        long l2 = zipEntry.getOffset();
        assert (-1L != l2);
        l2 = this.mapper.map(l2);
        readOnlyFile.seek(l2);
        byte[] byArray = new byte[30];
        readOnlyFile.readFully(byArray);
        if (67324752L != LittleEndian.readUInt(byArray, 0)) {
            throw new ZipException(string + " (expected Local File Header)");
        }
        l2 += (long)(30 + LittleEndian.readUShort(byArray, 26) + LittleEndian.readUShort(byArray, 28));
        try {
            decoratingReadOnlyFile = new EntryReadOnlyFile(l2, zipEntry.getCompressedSize());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (IOException)new ZipException(string + " (invalid meta data in Local File Header or Central Directory Record)").initCause(illegalArgumentException);
        }
        try {
            Object object;
            if (!bl3) {
                assert (-1L != zipEntry.getCrc());
                return new ReadOnlyFileInputStream(decoratingReadOnlyFile);
            }
            if (null == bl2) {
                bl2 = zipEntry.isEncrypted();
            }
            int n2 = zipEntry.getMethod();
            if (zipEntry.isEncrypted()) {
                if (99 != n2) {
                    throw new ZipException(string + " (encrypted compression method " + n2 + " is not supported)");
                }
                WinZipAesEntryReadOnlyFile winZipAesEntryReadOnlyFile = new WinZipAesEntryReadOnlyFile(decoratingReadOnlyFile, new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), zipEntry));
                decoratingReadOnlyFile = winZipAesEntryReadOnlyFile;
                if (bl2.booleanValue()) {
                    winZipAesEntryReadOnlyFile.authenticate();
                    bl2 = false;
                }
                object = (WinZipAesEntryExtraField)zipEntry.getExtraField(39169);
                n2 = ((WinZipAesEntryExtraField)object).getMethod();
            }
            if (bl2.booleanValue()) {
                long l3;
                if (zipEntry.getGeneralPurposeBitFlag(8)) {
                    byte[] byArray2 = new byte[8];
                    readOnlyFile.seek(l2 + zipEntry.getCompressedSize());
                    readOnlyFile.readFully(byArray2);
                    l3 = LittleEndian.readUInt(byArray2, 0);
                    if (134695760L == l3) {
                        l3 = LittleEndian.readUInt(byArray2, 4);
                    }
                } else {
                    l3 = LittleEndian.readUInt(byArray, 14);
                }
                if (zipEntry.getCrc() != l3) {
                    throw new CRC32Exception(string, zipEntry.getCrc(), l3);
                }
            }
            int n3 = RawZipFile.getBufferSize(zipEntry);
            switch (n2) {
                case 0: {
                    object = new ReadOnlyFileInputStream(decoratingReadOnlyFile);
                    break;
                }
                case 8: {
                    object = new ZipInflaterInputStream(new DummyByteInputStream(decoratingReadOnlyFile), n3);
                    break;
                }
                case 12: {
                    object = new BZip2CompressorInputStream(new ReadOnlyFileInputStream(decoratingReadOnlyFile));
                    break;
                }
                default: {
                    throw new ZipException(string + " (compression method " + n2 + " is not supported)");
                }
            }
            if (bl2.booleanValue()) {
                object = new Crc32InputStream((InputStream)object, zipEntry, n3);
            }
            return object;
        }
        catch (IOException iOException) {
            decoratingReadOnlyFile.close();
            throw iOException;
        }
    }

    private static int getBufferSize(ZipEntry zipEntry) {
        long l2 = zipEntry.getSize();
        if (8192L < l2) {
            l2 = 8192L;
        } else if (l2 < 1024L) {
            l2 = 1024L;
        }
        return (int)l2;
    }

    private ReadOnlyFile rof() throws ZipException {
        ReadOnlyFile readOnlyFile = this.rof;
        if (null == readOnlyFile) {
            throw new ZipException("ZIP file closed!");
        }
        return readOnlyFile;
    }

    @Override
    public void close() throws IOException {
        ReadOnlyFile readOnlyFile = this.rof;
        if (null == readOnlyFile) {
            return;
        }
        readOnlyFile.close();
        this.rof = null;
    }

    private static final class SafeBufferedReadOnlyFile
    extends BufferedReadOnlyFile {
        final long length;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public SafeBufferedReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile, long l2) throws IOException {
            super(readOnlyFile);
            assert (l2 <= readOnlyFile.length());
            this.length = l2;
        }

        @Override
        public long length() throws IOException {
            this.assertOpen();
            return this.length;
        }
    }

    private final class EntryReadOnlyFile
    extends IntervalReadOnlyFile {
        private boolean closed;

        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        EntryReadOnlyFile(long l2, long l3) throws IOException {
            super(RawZipFile.this.rof(), l2, l3);
            RawZipFile.this.open++;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            RawZipFile.this.open--;
        }
    }
}

