/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.LEDataOutputStream;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.zip.CRC32Exception;
import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.Crc32OutputStream;
import de.schlichtherle.truezip.zip.DecoratingOutputMethod;
import de.schlichtherle.truezip.zip.OutputMethod;
import de.schlichtherle.truezip.zip.RawZipFile;
import de.schlichtherle.truezip.zip.UShort;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import de.schlichtherle.truezip.zip.WinZipAesEntryOutputStream;
import de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.WinZipAesUtils;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipDeflaterOutputStream;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipOutputStreamParameters;
import de.schlichtherle.truezip.zip.ZipParameters;
import de.schlichtherle.truezip.zip.ZipParametersException;
import de.schlichtherle.truezip.zip.ZipParametersProvider;
import de.schlichtherle.truezip.zip.ZipParametersUtils;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

@NotThreadSafe
public abstract class RawZipOutputStream<E extends ZipEntry>
extends DecoratingOutputStream
implements Iterable<E> {
    private final LEDataOutputStream dos;
    private final Charset charset;
    private int method;
    private int level;
    @CheckForNull
    private byte[] comment;
    private final Map<String, E> entries;
    private long cdOffset;
    private boolean finished;
    @Nullable
    private ZipEntry entry;
    @Nullable
    private OutputMethod processor;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected RawZipOutputStream(@WillCloseWhenClosed OutputStream outputStream, @CheckForNull @WillNotClose RawZipFile<E> rawZipFile, ZipOutputStreamParameters zipOutputStreamParameters) {
        super(RawZipOutputStream.newLEDataOutputStream(outputStream, rawZipFile));
        this.dos = (LEDataOutputStream)this.delegate;
        if (null != rawZipFile) {
            this.charset = rawZipFile.getRawCharset();
            this.comment = rawZipFile.getRawComment();
            LinkedHashMap<String, E> linkedHashMap = new LinkedHashMap<String, E>(HashMaps.initialCapacity(rawZipFile.size() + zipOutputStreamParameters.getOverheadSize()));
            linkedHashMap.putAll(rawZipFile.getRawEntries());
            this.entries = linkedHashMap;
        } else {
            this.charset = zipOutputStreamParameters.getCharset();
            this.entries = new LinkedHashMap<String, E>(HashMaps.initialCapacity(zipOutputStreamParameters.getOverheadSize()));
        }
        this.setMethod0(zipOutputStreamParameters.getMethod());
        this.setLevel0(zipOutputStreamParameters.getLevel());
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private static LEDataOutputStream newLEDataOutputStream(@WillCloseWhenClosed OutputStream outputStream, @CheckForNull @WillNotClose RawZipFile<?> rawZipFile) {
        if (null == outputStream) {
            throw new NullPointerException();
        }
        return null != rawZipFile ? new AppendingLEDataOutputStream(outputStream, rawZipFile) : (outputStream instanceof LEDataOutputStream ? (LEDataOutputStream)outputStream : new LEDataOutputStream(outputStream));
    }

    private byte[] encode(String string) {
        return string.getBytes(this.charset);
    }

    private String decode(byte[] byArray) {
        return new String(byArray, this.charset);
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Deprecated
    public Enumeration<? extends ZipEntry> entries() {
        return Collections.enumeration(this.entries.values());
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public E getEntry(String string) {
        return (E)((ZipEntry)this.entries.get(string));
    }

    @Nullable
    public String getComment() {
        byte[] byArray = this.comment;
        return null == byArray ? null : this.decode(byArray);
    }

    public void setComment(@CheckForNull String string) {
        if (null != string && !string.isEmpty()) {
            byte[] byArray = this.encode(string);
            UShort.check(byArray.length);
            this.comment = byArray;
        } else {
            this.comment = null;
        }
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int n2) {
        this.setMethod0(n2);
    }

    private void setMethod0(int n2) {
        ZipEntry zipEntry = new ZipEntry("");
        zipEntry.setMethod(n2);
        this.method = zipEntry.getMethod();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n2) {
        this.setLevel0(n2);
    }

    private void setLevel0(int n2) {
        if ((n2 < 0 || 9 < n2) && n2 != -1) {
            throw new IllegalArgumentException("Invalid compression level!");
        }
        this.level = n2;
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    public long length() {
        return this.dos.size();
    }

    public boolean isBusy() {
        return null != this.entry;
    }

    public final void putNextEntry(E e2) throws IOException {
        this.putNextEntry(e2, true);
    }

    public void putNextEntry(E e2, boolean bl2) throws ZipException, IOException {
        this.closeEntry();
        OutputMethod outputMethod = this.newOutputMethod((ZipEntry)e2, bl2);
        outputMethod.init(((ZipEntry)e2).clone());
        outputMethod.init((ZipEntry)e2);
        this.delegate = outputMethod.start();
        this.processor = outputMethod;
        this.entries.put(((ZipEntry)e2).getName(), e2);
        this.entry = e2;
    }

    private OutputMethod newOutputMethod(ZipEntry zipEntry, boolean bl2) throws ZipException {
        OutputMethod outputMethod = new RawOutputMethod(bl2);
        if (!bl2) {
            assert (-1L != zipEntry.getCrc());
            return outputMethod;
        }
        int n2 = zipEntry.getMethod();
        if (-1 == n2) {
            n2 = this.getMethod();
            zipEntry.setRawMethod(n2);
        }
        boolean bl3 = false;
        if (zipEntry.isEncrypted() || 99 == n2) {
            ZipCryptoParameters zipCryptoParameters = this.getCryptoParameters();
            if (99 == n2) {
                zipCryptoParameters = ZipParametersUtils.parameters(WinZipAesParameters.class, zipCryptoParameters);
                WinZipAesEntryExtraField winZipAesEntryExtraField = (WinZipAesEntryExtraField)zipEntry.getExtraField(39169);
                if (null != winZipAesEntryExtraField) {
                    n2 = winZipAesEntryExtraField.getMethod();
                    if (2 == winZipAesEntryExtraField.getVendorVersion()) {
                        bl3 = true;
                    }
                }
            }
            outputMethod = this.newEncryptedOutputMethod((RawOutputMethod)outputMethod, zipCryptoParameters);
        }
        switch (n2) {
            case 0: {
                if (bl3) break;
                outputMethod = new Crc32CheckingOutputMethod(outputMethod);
                break;
            }
            case 8: {
                outputMethod = new DeflaterOutputMethod(outputMethod);
                if (bl3) break;
                outputMethod = new Crc32UpdatingOutputMethod(outputMethod);
                break;
            }
            case 12: {
                outputMethod = new BZip2OutputMethod(outputMethod);
                if (bl3) break;
                outputMethod = new Crc32UpdatingOutputMethod(outputMethod);
                break;
            }
            default: {
                throw new ZipException(zipEntry.getName() + " (unsupported compression method " + n2 + ")");
            }
        }
        return outputMethod;
    }

    private EncryptedOutputMethod newEncryptedOutputMethod(RawOutputMethod rawOutputMethod, @CheckForNull ZipParameters zipParameters) throws ZipParametersException {
        assert (null != rawOutputMethod);
        while (null != zipParameters) {
            if (zipParameters instanceof WinZipAesParameters) {
                return new WinZipAesOutputMethod(rawOutputMethod, (WinZipAesParameters)zipParameters);
            }
            if (!(zipParameters instanceof ZipParametersProvider)) break;
            zipParameters = ((ZipParametersProvider)zipParameters).get(ZipCryptoParameters.class);
        }
        throw new ZipParametersException("No suitable crypto parameters available!");
    }

    public void closeEntry() throws IOException {
        ZipEntry zipEntry = this.entry;
        if (null == zipEntry) {
            return;
        }
        this.processor.finish();
        this.delegate.flush();
        this.delegate = this.dos;
        this.processor = null;
        this.entry = null;
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.closeEntry();
        LEDataOutputStream lEDataOutputStream = this.dos;
        this.cdOffset = lEDataOutputStream.size();
        Iterator<E> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            if (this.writeCentralFileHeader((ZipEntry)iterator.next())) continue;
            iterator.remove();
        }
        this.writeEndOfCentralDirectory();
        this.finished = true;
    }

    private boolean writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        long l2;
        long l3 = zipEntry.getCompressedSize();
        if (-1L == (l3 | (l2 = zipEntry.getSize()))) {
            return false;
        }
        LEDataOutputStream lEDataOutputStream = this.dos;
        lEDataOutputStream.writeInt(33639248);
        lEDataOutputStream.writeShort(zipEntry.getRawPlatform() << 8 | 0x3F);
        lEDataOutputStream.writeShort(zipEntry.getRawVersionNeededToExtract());
        lEDataOutputStream.writeShort(zipEntry.getGeneralPurposeBitFlags());
        lEDataOutputStream.writeShort(zipEntry.getRawMethod());
        lEDataOutputStream.writeInt((int)zipEntry.getRawTime());
        lEDataOutputStream.writeInt((int)zipEntry.getRawCrc());
        lEDataOutputStream.writeInt((int)zipEntry.getRawCompressedSize());
        lEDataOutputStream.writeInt((int)zipEntry.getRawSize());
        byte[] byArray = this.encode(zipEntry.getName());
        lEDataOutputStream.writeShort(byArray.length);
        byte[] byArray2 = zipEntry.getRawExtraFields();
        lEDataOutputStream.writeShort(byArray2.length);
        byte[] byArray3 = this.getCommentEncoded(zipEntry);
        lEDataOutputStream.writeShort(byArray3.length);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeInt((int)zipEntry.getRawExternalAttributes());
        lEDataOutputStream.writeInt((int)zipEntry.getRawOffset());
        lEDataOutputStream.write(byArray);
        lEDataOutputStream.write(byArray2);
        lEDataOutputStream.write(byArray3);
        return true;
    }

    private byte[] getCommentEncoded(ZipEntry zipEntry) {
        return this.encode(zipEntry.getRawComment());
    }

    private void writeEndOfCentralDirectory() throws IOException {
        boolean bl2;
        LEDataOutputStream lEDataOutputStream = this.dos;
        long l2 = this.entries.size();
        long l3 = this.cdOffset;
        long l4 = lEDataOutputStream.size() - l3;
        boolean bl3 = l2 > 65535L || Constants.FORCE_ZIP64_EXT;
        boolean bl4 = l4 > 0xFFFFFFFFL || Constants.FORCE_ZIP64_EXT;
        boolean bl5 = l3 > 0xFFFFFFFFL || Constants.FORCE_ZIP64_EXT;
        int n2 = bl3 ? 65535 : (int)l2;
        long l5 = bl4 ? 0xFFFFFFFFL : l4;
        long l6 = bl5 ? 0xFFFFFFFFL : l3;
        boolean bl6 = bl2 = bl3 || bl4 || bl5;
        if (bl2) {
            long l7 = lEDataOutputStream.size();
            lEDataOutputStream.writeInt(101075792);
            lEDataOutputStream.writeLong(44L);
            lEDataOutputStream.writeShort(63);
            lEDataOutputStream.writeShort(46);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeLong(l2);
            lEDataOutputStream.writeLong(l2);
            lEDataOutputStream.writeLong(l4);
            lEDataOutputStream.writeLong(l3);
            lEDataOutputStream.writeInt(117853008);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeLong(l7);
            lEDataOutputStream.writeInt(1);
        }
        lEDataOutputStream.writeInt(101010256);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(n2);
        lEDataOutputStream.writeShort(n2);
        lEDataOutputStream.writeInt((int)l5);
        lEDataOutputStream.writeInt((int)l6);
        byte[] byArray = this.getRawComment();
        lEDataOutputStream.writeShort(byArray.length);
        lEDataOutputStream.write(byArray);
    }

    private byte[] getRawComment() {
        byte[] byArray = this.comment;
        return null != byArray ? byArray : Constants.EMPTY;
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.delegate.close();
    }

    private final class Crc32UpdatingOutputMethod
    extends Crc32OutputMethod {
        Crc32UpdatingOutputMethod(OutputMethod outputMethod) {
            super(outputMethod);
        }

        @Override
        public void finish() throws IOException {
            ZipEntry zipEntry = RawZipOutputStream.this.entry;
            long l2 = this.out.getChecksum().getValue();
            zipEntry.setRawCrc(l2);
            this.delegate.finish();
        }
    }

    private final class Crc32CheckingOutputMethod
    extends Crc32OutputMethod {
        Crc32CheckingOutputMethod(OutputMethod outputMethod) {
            super(outputMethod);
        }

        @Override
        public void finish() throws IOException {
            long l2;
            this.delegate.finish();
            ZipEntry zipEntry = RawZipOutputStream.this.entry;
            long l3 = zipEntry.getCrc();
            if (-1L != l3 && l3 != (l2 = this.out.getChecksum().getValue())) {
                throw new CRC32Exception(zipEntry.getName(), l3, l2);
            }
        }
    }

    private abstract class Crc32OutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        Crc32OutputStream out;

        Crc32OutputMethod(OutputMethod outputMethod) {
            super(outputMethod);
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            assert (null == this.out);
            this.out = new Crc32OutputStream(this.delegate.start());
            return this.out;
        }

        @Override
        public abstract void finish() throws IOException;
    }

    private final class DeflaterOutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        ZipDeflaterOutputStream out;
        @Nullable
        ZipEntry entry;

        DeflaterOutputMethod(OutputMethod outputMethod) {
            super(outputMethod);
        }

        @Override
        public void init(ZipEntry zipEntry) throws ZipException {
            zipEntry.setCompressedSize(-1L);
            this.delegate.init(zipEntry);
            this.entry = zipEntry;
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            assert (null == this.out);
            this.out = new ZipDeflaterOutputStream(this.delegate.start(), RawZipOutputStream.this.getLevel(), 8192);
            return this.out;
        }

        @Override
        public void finish() throws IOException {
            this.out.finish();
            Deflater deflater = this.out.getDeflater();
            ZipEntry zipEntry = this.entry;
            zipEntry.setRawSize(deflater.getBytesRead());
            deflater.end();
            this.delegate.finish();
        }
    }

    private final class BZip2OutputMethod
    extends DecoratingOutputMethod {
        @Nullable
        BZip2CompressorOutputStream cout;
        @Nullable
        LEDataOutputStream dout;
        @Nullable
        ZipEntry entry;

        BZip2OutputMethod(OutputMethod outputMethod) {
            super(outputMethod);
        }

        @Override
        public void init(ZipEntry zipEntry) throws ZipException {
            zipEntry.setCompressedSize(-1L);
            this.delegate.init(zipEntry);
            this.entry = zipEntry;
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            assert (null == this.cout);
            assert (null == this.dout);
            OutputStream outputStream = this.delegate.start();
            long l2 = this.entry.getSize();
            int n2 = -1L != l2 ? BZip2CompressorOutputStream.chooseBlockSize(l2) : this.getBZip2BlockSize();
            this.cout = new BZip2CompressorOutputStream(outputStream, n2);
            outputStream = this.cout;
            this.dout = new LEDataOutputStream(outputStream);
            return this.dout;
        }

        int getBZip2BlockSize() {
            int n2 = RawZipOutputStream.this.getLevel();
            if (1 <= n2 && n2 <= 9) {
                return n2;
            }
            return 9;
        }

        @Override
        public void finish() throws IOException {
            this.dout.flush();
            this.cout.finish();
            this.entry.setRawSize(this.dout.size());
            this.delegate.finish();
        }
    }

    private final class WinZipAesOutputMethod
    extends EncryptedOutputMethod {
        final WinZipAesParameters generalParam;
        boolean suppressCrc;
        @Nullable
        WinZipAesEntryParameters entryParam;
        @Nullable
        WinZipAesEntryOutputStream out;
        @Nullable
        ZipEntry entry;

        WinZipAesOutputMethod(RawOutputMethod rawOutputMethod, WinZipAesParameters winZipAesParameters) {
            super(rawOutputMethod);
            assert (null != winZipAesParameters);
            this.generalParam = winZipAesParameters;
        }

        @Override
        public void init(ZipEntry zipEntry) throws ZipException {
            WinZipAesEntryParameters winZipAesEntryParameters = new WinZipAesEntryParameters(this.generalParam, zipEntry);
            AesKeyStrength aesKeyStrength = winZipAesEntryParameters.getKeyStrength();
            this.entryParam = winZipAesEntryParameters;
            WinZipAesEntryExtraField winZipAesEntryExtraField = null;
            int n2 = zipEntry.getMethod();
            long l2 = zipEntry.getCompressedSize();
            if (99 == n2 && null != (winZipAesEntryExtraField = (WinZipAesEntryExtraField)zipEntry.getExtraField(39169))) {
                n2 = winZipAesEntryExtraField.getMethod();
                if (-1L != l2) {
                    l2 -= (long)WinZipAesUtils.overhead(winZipAesEntryExtraField.getKeyStrength());
                }
                zipEntry.setRawMethod(n2);
            }
            if (null == winZipAesEntryExtraField) {
                winZipAesEntryExtraField = new WinZipAesEntryExtraField();
            }
            winZipAesEntryExtraField.setKeyStrength(aesKeyStrength);
            winZipAesEntryExtraField.setMethod(n2);
            long l3 = zipEntry.getSize();
            if (20L <= l3 && 12 != n2) {
                winZipAesEntryExtraField.setVendorVersion(1);
            } else {
                winZipAesEntryExtraField.setVendorVersion(2);
                this.suppressCrc = true;
            }
            zipEntry.addExtraField(winZipAesEntryExtraField);
            if (-1L != l2) {
                zipEntry.setRawCompressedSize(l2 += (long)WinZipAesUtils.overhead(aesKeyStrength));
            }
            if (this.suppressCrc) {
                long l4 = zipEntry.getCrc();
                zipEntry.setRawCrc(0L);
                this.delegate.init(zipEntry);
                zipEntry.setCrc(l4);
            } else {
                this.delegate.init(zipEntry);
            }
            zipEntry.setRawMethod(99);
            this.entry = zipEntry;
        }

        @Override
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        public OutputStream start() throws IOException {
            ZipEntry zipEntry = this.entry;
            OutputMethod outputMethod = this.delegate;
            WinZipAesEntryParameters winZipAesEntryParameters = this.entryParam;
            assert (null != winZipAesEntryParameters);
            assert (null == this.out);
            if (this.suppressCrc) {
                long l2 = zipEntry.getCrc();
                zipEntry.setRawCrc(0L);
                this.out = new WinZipAesEntryOutputStream((LEDataOutputStream)outputMethod.start(), winZipAesEntryParameters);
                zipEntry.setCrc(l2);
            } else {
                this.out = new WinZipAesEntryOutputStream((LEDataOutputStream)outputMethod.start(), winZipAesEntryParameters);
            }
            return this.out;
        }

        @Override
        public void finish() throws IOException {
            assert (null != this.out);
            this.out.finish();
            if (this.suppressCrc) {
                ZipEntry zipEntry = this.entry;
                zipEntry.setRawCrc(0L);
                this.delegate.finish();
                zipEntry.setCrc(-1L);
            } else {
                this.delegate.finish();
            }
        }
    }

    private abstract class EncryptedOutputMethod
    extends DecoratingOutputMethod {
        EncryptedOutputMethod(RawOutputMethod rawOutputMethod) {
            super(rawOutputMethod);
        }
    }

    private final class RawOutputMethod
    implements OutputMethod {
        final boolean process;
        private long dataStart;
        @Nullable
        ZipEntry entry;

        RawOutputMethod(boolean bl2) {
            this.process = bl2;
        }

        @Override
        public void init(ZipEntry zipEntry) throws ZipException {
            long l2 = RawZipOutputStream.this.encode(zipEntry.getName()).length + zipEntry.getRawExtraFields().length + RawZipOutputStream.this.encode(zipEntry.getRawComment()).length;
            if (65535L < l2) {
                throw new ZipException(zipEntry.getName() + " (the total size " + l2 + " for the name, extra fields and comment exceeds the maximum size " + 65535 + ")");
            }
            if (0 == zipEntry.getMethod() || !this.process) {
                if (-1L == zipEntry.getCrc()) {
                    throw new ZipException(zipEntry.getName() + " (unknown CRC-32 value)");
                }
                if (-1L == zipEntry.getCompressedSize()) {
                    throw new ZipException(zipEntry.getName() + " (unknown compressed size)");
                }
                if (-1L == zipEntry.getSize()) {
                    throw new ZipException(zipEntry.getName() + " (unknown uncompressed size)");
                }
            }
            if (-1 == zipEntry.getPlatform()) {
                zipEntry.setRawPlatform(0);
            }
            if (-1L == zipEntry.getTime()) {
                zipEntry.setTime(System.currentTimeMillis());
            }
            this.entry = zipEntry;
        }

        @Override
        public OutputStream start() throws IOException {
            LEDataOutputStream lEDataOutputStream = RawZipOutputStream.this.dos;
            long l2 = lEDataOutputStream.size();
            ZipEntry zipEntry = this.entry;
            boolean bl2 = zipEntry.isEncrypted();
            boolean bl3 = zipEntry.isDataDescriptorRequired();
            boolean bl4 = Constants.UTF8.equals(RawZipOutputStream.this.charset);
            int n2 = (bl2 ? 1 : 0) | (bl3 ? 8 : 0) | (bl4 ? 2048 : 0);
            RawZipOutputStream.this.finished = false;
            lEDataOutputStream.writeInt(67324752);
            lEDataOutputStream.writeShort(zipEntry.getRawVersionNeededToExtract());
            lEDataOutputStream.writeShort(n2);
            lEDataOutputStream.writeShort(zipEntry.getRawMethod());
            lEDataOutputStream.writeInt((int)zipEntry.getRawTime());
            if (bl3) {
                lEDataOutputStream.writeInt(0);
                lEDataOutputStream.writeInt(0);
                lEDataOutputStream.writeInt(0);
            } else {
                lEDataOutputStream.writeInt((int)zipEntry.getRawCrc());
                lEDataOutputStream.writeInt((int)zipEntry.getRawCompressedSize());
                lEDataOutputStream.writeInt((int)zipEntry.getRawSize());
            }
            byte[] byArray = RawZipOutputStream.this.encode(zipEntry.getName());
            lEDataOutputStream.writeShort(byArray.length);
            byte[] byArray2 = zipEntry.getRawExtraFields();
            lEDataOutputStream.writeShort(byArray2.length);
            lEDataOutputStream.write(byArray);
            lEDataOutputStream.write(byArray2);
            zipEntry.setGeneralPurposeBitFlags(n2);
            zipEntry.setRawOffset(l2);
            this.dataStart = lEDataOutputStream.size();
            return lEDataOutputStream;
        }

        @Override
        public void finish() throws IOException {
            LEDataOutputStream lEDataOutputStream = RawZipOutputStream.this.dos;
            long l2 = lEDataOutputStream.size() - this.dataStart;
            ZipEntry zipEntry = this.entry;
            assert (-1L != zipEntry.getCrc());
            assert (-1L != zipEntry.getSize());
            if (zipEntry.getGeneralPurposeBitFlag(8)) {
                zipEntry.setRawCompressedSize(l2);
                lEDataOutputStream.writeInt(134695760);
                lEDataOutputStream.writeInt((int)zipEntry.getRawCrc());
                if (zipEntry.isZip64ExtensionsRequired()) {
                    lEDataOutputStream.writeLong(l2);
                    lEDataOutputStream.writeLong(zipEntry.getSize());
                } else {
                    lEDataOutputStream.writeInt((int)zipEntry.getRawCompressedSize());
                    lEDataOutputStream.writeInt((int)zipEntry.getRawSize());
                }
            } else if (zipEntry.getCompressedSize() != l2) {
                throw new ZipException(zipEntry.getName() + " (expected compressed entry size " + zipEntry.getCompressedSize() + ", but is actually " + l2 + ")");
            }
        }
    }

    private static final class AppendingLEDataOutputStream
    extends LEDataOutputStream {
        @CreatesObligation
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        AppendingLEDataOutputStream(@WillCloseWhenClosed OutputStream outputStream, @WillNotClose RawZipFile<?> rawZipFile) {
            super(outputStream);
            assert (null != outputStream);
            this.written = rawZipFile.getOffsetMapper().unmap(rawZipFile.length());
        }
    }
}

