/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.UShort;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class WinZipAesEntryExtraField
extends ExtraField {
    private static final int DATA_SIZE = 7;
    private static final int VENDOR_ID = 17729;
    private static final AesKeyStrength[] KEY_STRENGTHS = AesKeyStrength.values();
    static final int VV_AE_1 = 1;
    static final int VV_AE_2 = 2;
    private short vendorVersion = 1;
    private byte encryptionStrength = WinZipAesEntryExtraField.encryptionStrength(AesKeyStrength.BITS_128);
    private short method;

    WinZipAesEntryExtraField() {
    }

    private static byte encryptionStrength(AesKeyStrength aesKeyStrength) {
        return (byte)(aesKeyStrength.ordinal() + 1);
    }

    private static AesKeyStrength keyStrength(int n2) {
        return KEY_STRENGTHS[n2 - 1 & 0xFF];
    }

    @Override
    int getHeaderId() {
        return 39169;
    }

    @Override
    int getDataSize() {
        return 7;
    }

    int getVendorVersion() {
        return this.vendorVersion & 0xFFFF;
    }

    void setVendorVersion(int n2) {
        if (n2 < 1 || 2 < n2) {
            throw new IllegalArgumentException("" + n2);
        }
        this.vendorVersion = (short)n2;
    }

    int getVendorId() {
        return 17729;
    }

    AesKeyStrength getKeyStrength() {
        return WinZipAesEntryExtraField.keyStrength(this.encryptionStrength);
    }

    void setKeyStrength(AesKeyStrength aesKeyStrength) {
        this.encryptionStrength = WinZipAesEntryExtraField.encryptionStrength(aesKeyStrength);
    }

    int getMethod() {
        return this.method & 0xFFFF;
    }

    void setMethod(int n2) {
        assert (UShort.check(n2));
        this.method = (short)n2;
    }

    @Override
    void readFrom(byte[] byArray, int n2, int n3) {
        if (7 != n3) {
            throw new IllegalArgumentException();
        }
        this.setVendorVersion(LittleEndian.readUShort(byArray, n2));
        short s2 = (short)LittleEndian.readUShort(byArray, n2 += 2);
        n2 += 2;
        if (17729 != s2) {
            throw new IllegalArgumentException();
        }
        this.setKeyStrength(WinZipAesEntryExtraField.keyStrength(byArray[n2]));
        this.setMethod(LittleEndian.readUShort(byArray, ++n2));
    }

    @Override
    void writeTo(byte[] byArray, int n2) {
        LittleEndian.writeShort(this.vendorVersion, byArray, n2);
        LittleEndian.writeShort(17729, byArray, n2 += 2);
        byArray[n2 += 2] = this.encryptionStrength;
        LittleEndian.writeShort(this.method, byArray, ++n2);
    }
}

