/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipKeyException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class WinZipAesEntryParameters {
    private final WinZipAesParameters param;
    private final ZipEntry entry;

    public WinZipAesEntryParameters(WinZipAesParameters winZipAesParameters, ZipEntry zipEntry) {
        assert (null != winZipAesParameters);
        assert (null != zipEntry);
        this.param = winZipAesParameters;
        this.entry = zipEntry;
    }

    ZipEntry getEntry() {
        return this.entry;
    }

    AesKeyStrength getKeyStrength() throws ZipKeyException {
        return this.param.getKeyStrength(this.entry.getName());
    }

    void setKeyStrength(AesKeyStrength aesKeyStrength) throws ZipKeyException {
        this.param.setKeyStrength(this.entry.getName(), aesKeyStrength);
    }

    byte[] getWritePassword() throws ZipKeyException {
        return this.param.getWritePassword(this.entry.getName());
    }

    byte[] getReadPassword(boolean bl2) throws ZipKeyException {
        return this.param.getReadPassword(this.entry.getName(), bl2);
    }
}

