/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.DateTimeConverter;
import de.schlichtherle.truezip.zip.DefaultExtraField;
import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.ExtraFields;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.UByte;
import de.schlichtherle.truezip.zip.UInt;
import de.schlichtherle.truezip.zip.ULong;
import de.schlichtherle.truezip.zip.UShort;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import java.util.Formatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ZipEntry
implements Cloneable {
    private static final int PLATFORM = 1;
    private static final int METHOD = 2;
    private static final int CRC = 4;
    private static final int DTIME = 64;
    private static final int EATTR = 128;
    public static final byte UNKNOWN = -1;
    public static final short PLATFORM_FAT = 0;
    public static final short PLATFORM_UNIX = 3;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;
    public static final int BZIP2 = 12;
    static final int WINZIP_AES = 99;
    static final int GPBF_ENCRYPTED = 1;
    static final int GPBF_DATA_DESCRIPTOR = 8;
    static final int GPBF_UTF8 = 2048;
    public static final long MIN_DOS_TIME = 0x210000L;
    public static final long MAX_DOS_TIME = 4288659325L;
    private byte init;
    private String name;
    private byte platform;
    private short general;
    private short method;
    private int dtime;
    private int crc;
    private long csize = -1L;
    private long size = -1L;
    private int eattr;
    private long offset = -1L;
    @CheckForNull
    private ExtraFields fields;
    @CheckForNull
    private String comment;

    public ZipEntry(String string) {
        UShort.check(string.length());
        this.name = string;
    }

    protected ZipEntry(String string, ZipEntry zipEntry) {
        UShort.check(string.length());
        this.init = zipEntry.init;
        this.name = string;
        this.platform = zipEntry.platform;
        this.general = zipEntry.general;
        this.method = zipEntry.method;
        this.dtime = zipEntry.dtime;
        this.crc = zipEntry.crc;
        this.csize = zipEntry.csize;
        this.size = zipEntry.size;
        this.eattr = zipEntry.eattr;
        this.offset = zipEntry.offset;
        ExtraFields extraFields = zipEntry.fields;
        this.fields = extraFields == null ? null : extraFields.clone();
        this.comment = zipEntry.comment;
    }

    public ZipEntry clone() {
        ZipEntry zipEntry;
        try {
            zipEntry = (ZipEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        ExtraFields extraFields = this.fields;
        zipEntry.fields = extraFields == null ? null : extraFields.clone();
        return zipEntry;
    }

    private boolean isInit(int n2) {
        return 0 != (this.init & n2);
    }

    private void setInit(int n2, boolean bl2) {
        this.init = bl2 ? (byte)(this.init | n2) : (byte)(this.init & ~n2);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDirectory() {
        return this.name.endsWith("/");
    }

    public final short getPlatform() {
        return this.isInit(1) ? (short)(this.platform & 0xFF) : (short)-1;
    }

    public final void setPlatform(short s2) {
        boolean bl2;
        boolean bl3 = bl2 = -1 != s2;
        if (bl2) {
            UByte.check(s2, this.name, "Platform out of range");
            this.platform = (byte)s2;
        } else {
            this.platform = 0;
        }
        this.setInit(1, bl2);
    }

    final short getRawPlatform() {
        return (short)(this.platform & 0xFF);
    }

    final void setRawPlatform(int n2) {
        assert (UByte.check(n2));
        this.platform = (byte)n2;
        this.setInit(1, true);
    }

    final int getRawVersionNeededToExtract() {
        int n2 = this.getRawMethod();
        return 12 == n2 ? 46 : (this.isZip64ExtensionsRequired() ? 45 : (8 == n2 || this.isDirectory() ? 20 : 10));
    }

    final int getGeneralPurposeBitFlags() {
        return this.general & 0xFFFF;
    }

    final void setGeneralPurposeBitFlags(int n2) {
        assert (UShort.check(n2));
        this.general = (short)n2;
    }

    final boolean getGeneralPurposeBitFlag(int n2) {
        return 0 != (this.general & n2);
    }

    final void setGeneralPurposeBitFlag(int n2, boolean bl2) {
        this.general = bl2 ? (short)(this.general | n2) : (short)(this.general & ~n2);
    }

    public final boolean isEncrypted() {
        return this.getGeneralPurposeBitFlag(1);
    }

    public final void setEncrypted(boolean bl2) {
        this.setGeneralPurposeBitFlag(1, bl2);
    }

    public final void clearEncryption() {
        this.setEncrypted(false);
        WinZipAesEntryExtraField winZipAesEntryExtraField = (WinZipAesEntryExtraField)this.removeExtraField(39169);
        if (99 == this.getRawMethod()) {
            this.setRawMethod(null == winZipAesEntryExtraField ? -1 : winZipAesEntryExtraField.getMethod());
        }
    }

    public final int getMethod() {
        return this.isInit(2) ? this.method & 0xFFFF : -1;
    }

    public final void setMethod(int n2) {
        switch (n2) {
            case 0: 
            case 8: 
            case 12: 
            case 99: {
                this.method = (short)n2;
                this.setInit(2, true);
                break;
            }
            case -1: {
                this.method = 0;
                this.setInit(2, false);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.name + " (unsupported compression method " + n2 + ")");
            }
        }
    }

    final int getRawMethod() {
        return this.method & 0xFFFF;
    }

    final void setRawMethod(int n2) {
        assert (UShort.check(n2));
        this.method = (short)n2;
        this.setInit(2, true);
    }

    public final long getTime() {
        if (!this.isInit(64)) {
            return -1L;
        }
        return this.getDateTimeConverter().toJavaTime((long)this.dtime & 0xFFFFFFFFL);
    }

    public final void setTime(long l2) {
        boolean bl2 = -1L != l2;
        this.dtime = bl2 ? (int)this.getDateTimeConverter().toDosTime(l2) : 0;
        this.setInit(64, bl2);
    }

    final long getRawTime() {
        return (long)this.dtime & 0xFFFFFFFFL;
    }

    final void setRawTime(long l2) {
        assert (UInt.check(l2));
        this.dtime = (int)l2;
        this.setInit(64, true);
    }

    protected DateTimeConverter getDateTimeConverter() {
        return DateTimeConverter.JAR;
    }

    public final long getCrc() {
        return this.isInit(4) ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public final void setCrc(long l2) {
        boolean bl2;
        boolean bl3 = bl2 = -1L != l2;
        if (bl2) {
            UInt.check(l2, this.name, "CRC-32 out of range");
            this.crc = (int)l2;
        } else {
            this.crc = 0;
        }
        this.setInit(4, bl2);
    }

    final long getRawCrc() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    final void setRawCrc(long l2) {
        assert (UInt.check(l2));
        this.crc = (int)l2;
        this.setInit(4, true);
    }

    public final long getCompressedSize() {
        return this.csize;
    }

    public final void setCompressedSize(long l2) {
        if (-1L != l2) {
            ULong.check(l2, this.name, "Compressed Size out of range");
        }
        this.csize = l2;
    }

    final long getRawCompressedSize() {
        long l2 = this.csize;
        if (-1L == l2) {
            return 0L;
        }
        return Constants.FORCE_ZIP64_EXT || 0xFFFFFFFFL <= l2 ? 0xFFFFFFFFL : l2;
    }

    final void setRawCompressedSize(long l2) {
        assert (ULong.check(l2));
        this.csize = l2;
    }

    public final long getSize() {
        return this.size;
    }

    public final void setSize(long l2) {
        if (-1L != l2) {
            ULong.check(l2, this.name, "Uncompressed Size out of range");
        }
        this.size = l2;
    }

    final long getRawSize() {
        long l2 = this.size;
        if (-1L == l2) {
            return 0L;
        }
        return Constants.FORCE_ZIP64_EXT || 0xFFFFFFFFL <= l2 ? 0xFFFFFFFFL : l2;
    }

    final void setRawSize(long l2) {
        assert (ULong.check(l2));
        this.size = l2;
    }

    public final long getExternalAttributes() {
        return this.isInit(128) ? (long)this.eattr & 0xFFFFFFFFL : -1L;
    }

    public final void setExternalAttributes(long l2) {
        boolean bl2;
        boolean bl3 = bl2 = -1L != l2;
        if (bl2) {
            UInt.check(l2, this.name, "external file attributes out of range");
            this.eattr = (int)l2;
        } else {
            this.eattr = 0;
        }
        this.setInit(128, bl2);
    }

    final long getRawExternalAttributes() {
        if (!this.isInit(128)) {
            return this.isDirectory() ? 16L : 0L;
        }
        return (long)this.eattr & 0xFFFFFFFFL;
    }

    final void setRawExternalAttributes(long l2) {
        assert (UInt.check(l2));
        this.eattr = (int)l2;
        this.setInit(128, true);
    }

    final long getOffset() {
        return this.offset;
    }

    final long getRawOffset() {
        long l2 = this.offset;
        if (-1L == l2) {
            return 0L;
        }
        return Constants.FORCE_ZIP64_EXT || 0xFFFFFFFFL <= l2 ? 0xFFFFFFFFL : l2;
    }

    final void setRawOffset(long l2) {
        assert (ULong.check(l2));
        this.offset = l2;
    }

    @Nullable
    final ExtraField getExtraField(int n2) {
        ExtraFields extraFields = this.fields;
        return extraFields == null ? null : extraFields.get(n2);
    }

    @Nullable
    final ExtraField addExtraField(ExtraField extraField) {
        assert (null != extraField);
        ExtraFields extraFields = this.fields;
        if (null == extraFields) {
            this.fields = extraFields = new ExtraFields();
        }
        return extraFields.add(extraField);
    }

    @Nullable
    final ExtraField removeExtraField(int n2) {
        ExtraFields extraFields = this.fields;
        return null != extraFields ? extraFields.remove(n2) : null;
    }

    public final byte[] getExtra() {
        return this.getExtraFields(false);
    }

    public final void setExtra(@CheckForNull byte[] byArray) throws IllegalArgumentException {
        if (null != byArray) {
            UShort.check(byArray.length, "extra fields too large", null);
        }
        if (null == byArray || byArray.length <= 0) {
            this.fields = null;
        } else {
            this.setExtraFields(byArray, false);
        }
    }

    final byte[] getRawExtraFields() {
        return this.getExtraFields(true);
    }

    final void setRawExtraFields(byte[] byArray) throws IllegalArgumentException {
        this.setExtraFields(byArray, true);
    }

    private byte[] getExtraFields(boolean bl2) {
        ExtraFields extraFields = this.fields;
        if (bl2) {
            ExtraField extraField = this.composeZip64ExtraField();
            if (null != extraField) {
                extraFields = null != extraFields ? extraFields.clone() : new ExtraFields();
                extraFields.add(extraField);
            }
        } else assert (null == extraFields || null == extraFields.get(1));
        return null == extraFields ? Constants.EMPTY : extraFields.getExtra();
    }

    private void setExtraFields(byte[] byArray, boolean bl2) throws IllegalArgumentException {
        assert (UShort.check(byArray.length));
        if (0 < byArray.length) {
            ExtraFields extraFields = new ExtraFields();
            try {
                extraFields.readFrom(byArray, 0, byArray.length);
                if (bl2) {
                    this.parseZip64ExtraField(extraFields);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException(indexOutOfBoundsException);
            }
            extraFields.remove(1);
            this.fields = 0 < extraFields.size() ? extraFields : null;
        } else {
            this.fields = null;
        }
    }

    @CheckForNull
    private ExtraField composeZip64ExtraField() {
        DefaultExtraField defaultExtraField;
        byte[] byArray = new byte[24];
        int n2 = 0;
        long l2 = this.getSize();
        if (Constants.FORCE_ZIP64_EXT && -1L != l2 || 0xFFFFFFFFL <= l2) {
            LittleEndian.writeLong(l2, byArray, n2);
            n2 += 8;
        }
        long l3 = this.getCompressedSize();
        if (Constants.FORCE_ZIP64_EXT && -1L != l3 || 0xFFFFFFFFL <= l3) {
            LittleEndian.writeLong(l3, byArray, n2);
            n2 += 8;
        }
        long l4 = this.getOffset();
        if (Constants.FORCE_ZIP64_EXT && -1L != l4 || 0xFFFFFFFFL <= l4) {
            LittleEndian.writeLong(l4, byArray, n2);
            n2 += 8;
        }
        if (n2 > 0) {
            defaultExtraField = new DefaultExtraField(1);
            ((ExtraField)defaultExtraField).readFrom(byArray, 0, n2);
        } else {
            defaultExtraField = null;
        }
        return defaultExtraField;
    }

    private void parseZip64ExtraField(ExtraFields extraFields) throws IndexOutOfBoundsException {
        long l2;
        long l3;
        ExtraField extraField = extraFields.get(1);
        if (null == extraField) {
            return;
        }
        byte[] byArray = extraField.getDataBlock();
        int n2 = 0;
        long l4 = this.getRawSize();
        if (0xFFFFFFFFL <= l4) {
            assert (0xFFFFFFFFL == l4);
            this.setRawSize(LittleEndian.readLong(byArray, n2));
            n2 += 8;
        }
        if (0xFFFFFFFFL <= (l3 = this.getRawCompressedSize())) {
            assert (0xFFFFFFFFL == l3);
            this.setRawCompressedSize(LittleEndian.readLong(byArray, n2));
            n2 += 8;
        }
        if (0xFFFFFFFFL <= (l2 = this.getRawOffset())) {
            assert (0xFFFFFFFFL == l2);
            this.setRawOffset(LittleEndian.readLong(byArray, n2));
        }
    }

    @CheckForNull
    public final String getComment() {
        return this.comment;
    }

    public final void setComment(@CheckForNull String string) {
        if (null != string) {
            UShort.check(string.length(), this.name, "Comment too long");
        }
        this.comment = string;
    }

    final String getRawComment() {
        String string = this.comment;
        return null != string ? string : "";
    }

    final void setRawComment(String string) {
        assert (UShort.check(string.length()));
        this.comment = string;
    }

    final boolean isDataDescriptorRequired() {
        return -1L == (this.getCrc() | this.getCompressedSize() | this.getSize());
    }

    final boolean isZip64ExtensionsRequired() {
        if (Constants.FORCE_ZIP64_EXT) {
            return true;
        }
        return 0xFFFFFFFFL <= this.getCompressedSize() || 0xFFFFFFFFL <= this.getSize() || 0xFFFFFFFFL <= this.getOffset();
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder(256);
        Formatter formatter = new Formatter(stringBuilder).format("%s[name=%s", this.getClass().getName(), this.getName());
        long l2 = this.getGeneralPurposeBitFlags();
        if (-1L != l2) {
            formatter.format(", gpbf=0x%04X", l2);
        }
        if (-1L != (l2 = (long)this.getMethod())) {
            formatter.format(", method=%d", l2);
        }
        if (-1L != (l2 = this.getTime())) {
            formatter.format(", time=%tc", l2);
        }
        if (-1L != (l2 = this.getCrc())) {
            formatter.format(", crc=0x%08X", l2);
        }
        if (-1L != (l2 = this.getCompressedSize())) {
            formatter.format(", compressedSize=%d", l2);
        }
        if (-1L != (l2 = this.getSize())) {
            formatter.format(", size=%d", l2);
        }
        if (-1L != (l2 = this.getExternalAttributes())) {
            formatter.format(", ea=0x%08X", l2);
        }
        if (null != (string = this.getComment())) {
            formatter.format(", comment=\"%s\"", string);
        }
        return stringBuilder.append("]").toString();
    }
}

