/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.DefaultZipOutputStreamParameters;
import de.schlichtherle.truezip.zip.RawZipOutputStream;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStreamParameters;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ZipOutputStream
extends RawZipOutputStream<ZipEntry> {
    public static final int OVERHEAD_SIZE = 47;
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    private static final ZipOutputStreamParameters DEFAULT_PARAM = new DefaultZipOutputStreamParameters(DEFAULT_CHARSET);
    @CheckForNull
    private ZipCryptoParameters cryptoParameters;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputStream(@WillCloseWhenClosed OutputStream outputStream) {
        super(outputStream, null, DEFAULT_PARAM);
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputStream(@WillCloseWhenClosed OutputStream outputStream, Charset charset) {
        super(outputStream, null, new DefaultZipOutputStreamParameters(charset));
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public ZipOutputStream(@WillCloseWhenClosed OutputStream outputStream, ZipFile zipFile) {
        super(outputStream, zipFile, DEFAULT_PARAM);
        if (null == zipFile) {
            throw new NullPointerException();
        }
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    @Override
    public synchronized Enumeration<? extends ZipEntry> entries() {
        class CloneEnumeration
        implements Enumeration<ZipEntry> {
            final Enumeration<? extends ZipEntry> e;

            CloneEnumeration() {
                this.e = Collections.enumeration(Collections.list(ZipOutputStream.super.entries()));
            }

            @Override
            public boolean hasMoreElements() {
                return this.e.hasMoreElements();
            }

            @Override
            public ZipEntry nextElement() {
                return this.e.nextElement().clone();
            }
        }
        return new CloneEnumeration();
    }

    @Override
    public synchronized Iterator<ZipEntry> iterator() {
        class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                ArrayList arrayList = new ArrayList(ZipOutputStream.super.size());
                Iterator iterator = ZipOutputStream.super.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                this.i = arrayList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public synchronized ZipEntry getEntry(String string) {
        Object e2 = super.getEntry(string);
        return e2 != null ? ((ZipEntry)e2).clone() : null;
    }

    @Override
    public synchronized void setComment(String string) {
        super.setComment(string);
    }

    @Override
    public synchronized String getComment() {
        return super.getComment();
    }

    @Override
    public synchronized int getMethod() {
        return super.getMethod();
    }

    @Override
    public synchronized void setMethod(int n2) {
        super.setMethod(n2);
    }

    @Override
    public synchronized int getLevel() {
        return super.getLevel();
    }

    @Override
    public synchronized void setLevel(int n2) {
        super.setLevel(n2);
    }

    @Override
    @Nullable
    public synchronized ZipCryptoParameters getCryptoParameters() {
        return this.cryptoParameters;
    }

    public synchronized void setCryptoParameters(@CheckForNull ZipCryptoParameters zipCryptoParameters) {
        this.cryptoParameters = zipCryptoParameters;
    }

    @Override
    public synchronized long length() {
        return super.length();
    }

    @Override
    public final synchronized boolean isBusy() {
        return super.isBusy();
    }

    @Override
    public synchronized void putNextEntry(ZipEntry zipEntry, boolean bl2) throws IOException {
        super.putNextEntry(zipEntry, bl2);
    }

    @Override
    public synchronized void write(int n2) throws IOException {
        super.write(n2);
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        super.write(byArray, n2, n3);
    }

    @Override
    public synchronized void closeEntry() throws IOException {
        super.closeEntry();
    }

    @Override
    public synchronized void finish() throws IOException {
        super.finish();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }
}

