/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamProvider;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.compress.utils.ServiceLoaderIterator;
import org.apache.commons.compress.utils.Sets;

public class ArchiveStreamFactory
implements ArchiveStreamProvider {
    private static final int TAR_HEADER_SIZE = 512;
    private static final int DUMP_SIGNATURE_SIZE = 32;
    private static final int SIGNATURE_SIZE = 12;
    private static final ArchiveStreamFactory SINGLETON = new ArchiveStreamFactory();
    public static final String AR = "ar";
    public static final String ARJ = "arj";
    public static final String CPIO = "cpio";
    public static final String DUMP = "dump";
    public static final String JAR = "jar";
    public static final String TAR = "tar";
    public static final String ZIP = "zip";
    public static final String SEVEN_Z = "7z";
    private final String encoding;
    private volatile String entryEncoding;
    private SortedMap<String, ArchiveStreamProvider> archiveInputStreamProviders;
    private SortedMap<String, ArchiveStreamProvider> archiveOutputStreamProviders;

    private static ArrayList<ArchiveStreamProvider> findArchiveStreamProviders() {
        return Lists.newArrayList(ArchiveStreamFactory.serviceLoaderIterator());
    }

    static void putAll(Set<String> set, ArchiveStreamProvider archiveStreamProvider, TreeMap<String, ArchiveStreamProvider> treeMap) {
        for (String string : set) {
            treeMap.put(ArchiveStreamFactory.toKey(string), archiveStreamProvider);
        }
    }

    private static Iterator<ArchiveStreamProvider> serviceLoaderIterator() {
        return new ServiceLoaderIterator<ArchiveStreamProvider>(ArchiveStreamProvider.class);
    }

    private static String toKey(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    public static SortedMap<String, ArchiveStreamProvider> findAvailableArchiveInputStreamProviders() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, ArchiveStreamProvider>>(){

            @Override
            public SortedMap<String, ArchiveStreamProvider> run() {
                TreeMap<String, ArchiveStreamProvider> treeMap = new TreeMap<String, ArchiveStreamProvider>();
                ArchiveStreamFactory.putAll(SINGLETON.getInputStreamArchiveNames(), SINGLETON, treeMap);
                for (ArchiveStreamProvider archiveStreamProvider : ArchiveStreamFactory.findArchiveStreamProviders()) {
                    ArchiveStreamFactory.putAll(archiveStreamProvider.getInputStreamArchiveNames(), archiveStreamProvider, treeMap);
                }
                return treeMap;
            }
        });
    }

    public static SortedMap<String, ArchiveStreamProvider> findAvailableArchiveOutputStreamProviders() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, ArchiveStreamProvider>>(){

            @Override
            public SortedMap<String, ArchiveStreamProvider> run() {
                TreeMap<String, ArchiveStreamProvider> treeMap = new TreeMap<String, ArchiveStreamProvider>();
                ArchiveStreamFactory.putAll(SINGLETON.getOutputStreamArchiveNames(), SINGLETON, treeMap);
                for (ArchiveStreamProvider archiveStreamProvider : ArchiveStreamFactory.findArchiveStreamProviders()) {
                    ArchiveStreamFactory.putAll(archiveStreamProvider.getOutputStreamArchiveNames(), archiveStreamProvider, treeMap);
                }
                return treeMap;
            }
        });
    }

    public ArchiveStreamFactory() {
        this(null);
    }

    public ArchiveStreamFactory(String string) {
        this.encoding = string;
        this.entryEncoding = string;
    }

    public String getEntryEncoding() {
        return this.entryEncoding;
    }

    @Deprecated
    public void setEntryEncoding(String string) {
        if (this.encoding != null) {
            throw new IllegalStateException("Cannot overide encoding set by the constructor");
        }
        this.entryEncoding = string;
    }

    public ArchiveInputStream createArchiveInputStream(String string, InputStream inputStream) throws ArchiveException {
        return this.createArchiveInputStream(string, inputStream, this.entryEncoding);
    }

    @Override
    public ArchiveInputStream createArchiveInputStream(String string, InputStream inputStream, String string2) throws ArchiveException {
        if (string == null) {
            throw new IllegalArgumentException("Archivername must not be null.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream must not be null.");
        }
        if (AR.equalsIgnoreCase(string)) {
            return new ArArchiveInputStream(inputStream);
        }
        if (ARJ.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new ArjArchiveInputStream(inputStream, string2);
            }
            return new ArjArchiveInputStream(inputStream);
        }
        if (ZIP.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new ZipArchiveInputStream(inputStream, string2);
            }
            return new ZipArchiveInputStream(inputStream);
        }
        if (TAR.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new TarArchiveInputStream(inputStream, string2);
            }
            return new TarArchiveInputStream(inputStream);
        }
        if (JAR.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new JarArchiveInputStream(inputStream, string2);
            }
            return new JarArchiveInputStream(inputStream);
        }
        if (CPIO.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new CpioArchiveInputStream(inputStream, string2);
            }
            return new CpioArchiveInputStream(inputStream);
        }
        if (DUMP.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new DumpArchiveInputStream(inputStream, string2);
            }
            return new DumpArchiveInputStream(inputStream);
        }
        if (SEVEN_Z.equalsIgnoreCase(string)) {
            throw new StreamingNotSupportedException(SEVEN_Z);
        }
        ArchiveStreamProvider archiveStreamProvider = (ArchiveStreamProvider)this.getArchiveInputStreamProviders().get(ArchiveStreamFactory.toKey(string));
        if (archiveStreamProvider != null) {
            return archiveStreamProvider.createArchiveInputStream(string, inputStream, string2);
        }
        throw new ArchiveException("Archiver: " + string + " not found.");
    }

    public ArchiveOutputStream createArchiveOutputStream(String string, OutputStream outputStream) throws ArchiveException {
        return this.createArchiveOutputStream(string, outputStream, this.entryEncoding);
    }

    @Override
    public ArchiveOutputStream createArchiveOutputStream(String string, OutputStream outputStream, String string2) throws ArchiveException {
        if (string == null) {
            throw new IllegalArgumentException("Archivername must not be null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream must not be null.");
        }
        if (AR.equalsIgnoreCase(string)) {
            return new ArArchiveOutputStream(outputStream);
        }
        if (ZIP.equalsIgnoreCase(string)) {
            ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(outputStream);
            if (string2 != null) {
                zipArchiveOutputStream.setEncoding(string2);
            }
            return zipArchiveOutputStream;
        }
        if (TAR.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new TarArchiveOutputStream(outputStream, string2);
            }
            return new TarArchiveOutputStream(outputStream);
        }
        if (JAR.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new JarArchiveOutputStream(outputStream, string2);
            }
            return new JarArchiveOutputStream(outputStream);
        }
        if (CPIO.equalsIgnoreCase(string)) {
            if (string2 != null) {
                return new CpioArchiveOutputStream(outputStream, string2);
            }
            return new CpioArchiveOutputStream(outputStream);
        }
        if (SEVEN_Z.equalsIgnoreCase(string)) {
            throw new StreamingNotSupportedException(SEVEN_Z);
        }
        ArchiveStreamProvider archiveStreamProvider = (ArchiveStreamProvider)this.getArchiveOutputStreamProviders().get(ArchiveStreamFactory.toKey(string));
        if (archiveStreamProvider != null) {
            return archiveStreamProvider.createArchiveOutputStream(string, outputStream, string2);
        }
        throw new ArchiveException("Archiver: " + string + " not found.");
    }

    public ArchiveInputStream createArchiveInputStream(InputStream inputStream) throws ArchiveException {
        return this.createArchiveInputStream(ArchiveStreamFactory.detect(inputStream), inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String detect(InputStream inputStream) throws ArchiveException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] byArray = new byte[12];
        inputStream.mark(byArray.length);
        int n2 = -1;
        try {
            n2 = IOUtils.readFully(inputStream, byArray);
            inputStream.reset();
        }
        catch (IOException iOException) {
            throw new ArchiveException("IOException while reading signature.", iOException);
        }
        if (ZipArchiveInputStream.matches(byArray, n2)) {
            return ZIP;
        }
        if (JarArchiveInputStream.matches(byArray, n2)) {
            return JAR;
        }
        if (ArArchiveInputStream.matches(byArray, n2)) {
            return AR;
        }
        if (CpioArchiveInputStream.matches(byArray, n2)) {
            return CPIO;
        }
        if (ArjArchiveInputStream.matches(byArray, n2)) {
            return ARJ;
        }
        if (SevenZFile.matches(byArray, n2)) {
            return SEVEN_Z;
        }
        byte[] byArray2 = new byte[32];
        inputStream.mark(byArray2.length);
        try {
            n2 = IOUtils.readFully(inputStream, byArray2);
            inputStream.reset();
        }
        catch (IOException iOException) {
            throw new ArchiveException("IOException while reading dump signature", iOException);
        }
        if (DumpArchiveInputStream.matches(byArray2, n2)) {
            return DUMP;
        }
        byte[] byArray3 = new byte[512];
        inputStream.mark(byArray3.length);
        try {
            n2 = IOUtils.readFully(inputStream, byArray3);
            inputStream.reset();
        }
        catch (IOException iOException) {
            throw new ArchiveException("IOException while reading tar signature", iOException);
        }
        if (TarArchiveInputStream.matches(byArray3, n2)) {
            return TAR;
        }
        if (n2 >= 512) {
            TarArchiveInputStream tarArchiveInputStream;
            block21: {
                String string;
                tarArchiveInputStream = null;
                try {
                    tarArchiveInputStream = new TarArchiveInputStream(new ByteArrayInputStream(byArray3));
                    if (!tarArchiveInputStream.getNextTarEntry().isCheckSumOK()) break block21;
                    string = TAR;
                }
                catch (Exception exception) {
                    IOUtils.closeQuietly(tarArchiveInputStream);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(tarArchiveInputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly(tarArchiveInputStream);
                return string;
            }
            IOUtils.closeQuietly(tarArchiveInputStream);
        }
        throw new ArchiveException("No Archiver found for the stream signature");
    }

    public SortedMap<String, ArchiveStreamProvider> getArchiveInputStreamProviders() {
        if (this.archiveInputStreamProviders == null) {
            this.archiveInputStreamProviders = Collections.unmodifiableSortedMap(ArchiveStreamFactory.findAvailableArchiveInputStreamProviders());
        }
        return this.archiveInputStreamProviders;
    }

    public SortedMap<String, ArchiveStreamProvider> getArchiveOutputStreamProviders() {
        if (this.archiveOutputStreamProviders == null) {
            this.archiveOutputStreamProviders = Collections.unmodifiableSortedMap(ArchiveStreamFactory.findAvailableArchiveOutputStreamProviders());
        }
        return this.archiveOutputStreamProviders;
    }

    @Override
    public Set<String> getInputStreamArchiveNames() {
        return Sets.newHashSet(AR, ARJ, ZIP, TAR, JAR, CPIO, DUMP, SEVEN_Z);
    }

    @Override
    public Set<String> getOutputStreamArchiveNames() {
        return Sets.newHashSet(AR, ZIP, TAR, JAR, CPIO, SEVEN_Z);
    }
}

