/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.utils.ArchiveUtils;

public class ArArchiveOutputStream
extends ArchiveOutputStream {
    public static final int LONGFILE_ERROR = 0;
    public static final int LONGFILE_BSD = 1;
    private final OutputStream out;
    private long entryOffset = 0L;
    private ArArchiveEntry prevEntry;
    private boolean haveUnclosedEntry = false;
    private int longFileMode = 0;
    private boolean finished = false;

    public ArArchiveOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setLongFileMode(int n2) {
        this.longFileMode = n2;
    }

    private long writeArchiveHeader() throws IOException {
        byte[] byArray = ArchiveUtils.toAsciiBytes("!<arch>\n");
        this.out.write(byArray);
        return byArray.length;
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.prevEntry == null || !this.haveUnclosedEntry) {
            throw new IOException("No current entry to close");
        }
        if (this.entryOffset % 2L != 0L) {
            this.out.write(10);
        }
        this.haveUnclosedEntry = false;
    }

    @Override
    public void putArchiveEntry(ArchiveEntry archiveEntry) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        ArArchiveEntry arArchiveEntry = (ArArchiveEntry)archiveEntry;
        if (this.prevEntry == null) {
            this.writeArchiveHeader();
        } else {
            if (this.prevEntry.getLength() != this.entryOffset) {
                throw new IOException("length does not match entry (" + this.prevEntry.getLength() + " != " + this.entryOffset);
            }
            if (this.haveUnclosedEntry) {
                this.closeArchiveEntry();
            }
        }
        this.prevEntry = arArchiveEntry;
        this.writeEntryHeader(arArchiveEntry);
        this.entryOffset = 0L;
        this.haveUnclosedEntry = true;
    }

    private long fill(long l2, long l3, char c2) throws IOException {
        long l4 = l3 - l2;
        if (l4 > 0L) {
            int n2 = 0;
            while ((long)n2 < l4) {
                this.write(c2);
                ++n2;
            }
        }
        return l3;
    }

    private long write(String string) throws IOException {
        byte[] byArray = string.getBytes("ascii");
        this.write(byArray);
        return byArray.length;
    }

    private long writeEntryHeader(ArArchiveEntry arArchiveEntry) throws IOException {
        long l2 = 0L;
        boolean bl2 = false;
        String string = arArchiveEntry.getName();
        if (0 == this.longFileMode && string.length() > 16) {
            throw new IOException("filename too long, > 16 chars: " + string);
        }
        if (1 == this.longFileMode && (string.length() > 16 || string.contains(" "))) {
            bl2 = true;
            l2 += this.write("#1/" + String.valueOf(string.length()));
        } else {
            l2 += this.write(string);
        }
        l2 = this.fill(l2, 16L, ' ');
        String string2 = "" + arArchiveEntry.getLastModified();
        if (string2.length() > 12) {
            throw new IOException("modified too long");
        }
        l2 += this.write(string2);
        l2 = this.fill(l2, 28L, ' ');
        String string3 = "" + arArchiveEntry.getUserId();
        if (string3.length() > 6) {
            throw new IOException("userid too long");
        }
        l2 += this.write(string3);
        l2 = this.fill(l2, 34L, ' ');
        String string4 = "" + arArchiveEntry.getGroupId();
        if (string4.length() > 6) {
            throw new IOException("groupid too long");
        }
        l2 += this.write(string4);
        l2 = this.fill(l2, 40L, ' ');
        String string5 = "" + Integer.toString(arArchiveEntry.getMode(), 8);
        if (string5.length() > 8) {
            throw new IOException("filemode too long");
        }
        l2 += this.write(string5);
        l2 = this.fill(l2, 48L, ' ');
        String string6 = String.valueOf(arArchiveEntry.getLength() + (long)(bl2 ? string.length() : 0));
        if (string6.length() > 10) {
            throw new IOException("size too long");
        }
        l2 += this.write(string6);
        l2 = this.fill(l2, 58L, ' ');
        l2 += this.write("`\n");
        if (bl2) {
            l2 += this.write(string);
        }
        return l2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        this.count(n3);
        this.entryOffset += (long)n3;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.finished) {
                this.finish();
            }
        }
        finally {
            this.out.close();
            this.prevEntry = null;
        }
    }

    @Override
    public ArchiveEntry createArchiveEntry(File file, String string) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new ArArchiveEntry(file, string);
    }

    @Override
    public void finish() throws IOException {
        if (this.haveUnclosedEntry) {
            throw new IOException("This archive contains unclosed entries.");
        }
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        this.finished = true;
    }
}

