/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.utils.ByteUtils;

class DumpArchiveUtil {
    private DumpArchiveUtil() {
    }

    public static int calculateChecksum(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n2 += DumpArchiveUtil.convert32(byArray, 4 * i2);
        }
        return 84446 - (n2 - DumpArchiveUtil.convert32(byArray, 28));
    }

    public static final boolean verify(byte[] byArray) {
        int n2 = DumpArchiveUtil.convert32(byArray, 24);
        if (n2 != 60012) {
            return false;
        }
        int n3 = DumpArchiveUtil.convert32(byArray, 28);
        return n3 == DumpArchiveUtil.calculateChecksum(byArray);
    }

    public static final int getIno(byte[] byArray) {
        return DumpArchiveUtil.convert32(byArray, 20);
    }

    public static final long convert64(byte[] byArray, int n2) {
        return ByteUtils.fromLittleEndian(byArray, n2, 8);
    }

    public static final int convert32(byte[] byArray, int n2) {
        return (int)ByteUtils.fromLittleEndian(byArray, n2, 4);
    }

    public static final int convert16(byte[] byArray, int n2) {
        return (int)ByteUtils.fromLittleEndian(byArray, n2, 2);
    }

    static String decode(ZipEncoding zipEncoding, byte[] byArray, int n2, int n3) throws IOException {
        return zipEncoding.decode(Arrays.copyOfRange(byArray, n2, n2 + n3));
    }
}

