/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.compress.archivers.dump.DumpArchiveConstants;
import org.apache.commons.compress.archivers.dump.DumpArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveUtil;
import org.apache.commons.compress.archivers.dump.ShortFileException;
import org.apache.commons.compress.archivers.dump.UnsupportedCompressionAlgorithmException;
import org.apache.commons.compress.utils.IOUtils;

class TapeInputStream
extends FilterInputStream {
    private byte[] blockBuffer = new byte[1024];
    private int currBlkIdx = -1;
    private int blockSize = 1024;
    private static final int RECORD_SIZE = 1024;
    private int readOffset = 1024;
    private boolean isCompressed = false;
    private long bytesRead = 0L;

    public TapeInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public void resetBlockSize(int n2, boolean bl2) throws IOException {
        this.isCompressed = bl2;
        this.blockSize = 1024 * n2;
        byte[] byArray = this.blockBuffer;
        this.blockBuffer = new byte[this.blockSize];
        System.arraycopy(byArray, 0, this.blockBuffer, 0, 1024);
        this.readFully(this.blockBuffer, 1024, this.blockSize - 1024);
        this.currBlkIdx = 0;
        this.readOffset = 1024;
    }

    @Override
    public int available() throws IOException {
        if (this.readOffset < this.blockSize) {
            return this.blockSize - this.readOffset;
        }
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        throw new IllegalArgumentException("all reads must be multiple of record size (1024 bytes.");
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 % 1024 != 0) {
            throw new IllegalArgumentException("all reads must be multiple of record size (1024 bytes.");
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.readOffset == this.blockSize) {
                try {
                    this.readBlock(true);
                }
                catch (ShortFileException shortFileException) {
                    return -1;
                }
            }
            int n5 = 0;
            n5 = this.readOffset + (n3 - n4) <= this.blockSize ? n3 - n4 : this.blockSize - this.readOffset;
            System.arraycopy(this.blockBuffer, this.readOffset, byArray, n2, n5);
            this.readOffset += n5;
            n4 += n5;
            n2 += n5;
        }
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        long l4;
        if (l2 % 1024L != 0L) {
            throw new IllegalArgumentException("all reads must be multiple of record size (1024 bytes.");
        }
        for (l3 = 0L; l3 < l2; l3 += l4) {
            if (this.readOffset == this.blockSize) {
                try {
                    this.readBlock(l2 - l3 < (long)this.blockSize);
                }
                catch (ShortFileException shortFileException) {
                    return -1L;
                }
            }
            l4 = 0L;
            l4 = (long)this.readOffset + (l2 - l3) <= (long)this.blockSize ? l2 - l3 : (long)this.blockSize - (long)this.readOffset;
            this.readOffset = (int)((long)this.readOffset + l4);
        }
        return l3;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null && this.in != System.in) {
            this.in.close();
        }
    }

    public byte[] peek() throws IOException {
        if (this.readOffset == this.blockSize) {
            try {
                this.readBlock(true);
            }
            catch (ShortFileException shortFileException) {
                return null;
            }
        }
        byte[] byArray = new byte[1024];
        System.arraycopy(this.blockBuffer, this.readOffset, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] readRecord() throws IOException {
        byte[] byArray = new byte[1024];
        if (-1 == this.read(byArray, 0, byArray.length)) {
            throw new ShortFileException();
        }
        return byArray;
    }

    private void readBlock(boolean bl2) throws IOException {
        if (this.in == null) {
            throw new IOException("input buffer is closed");
        }
        if (!this.isCompressed || this.currBlkIdx == -1) {
            this.readFully(this.blockBuffer, 0, this.blockSize);
            this.bytesRead += (long)this.blockSize;
        } else {
            boolean bl3;
            this.readFully(this.blockBuffer, 0, 4);
            this.bytesRead += 4L;
            int n2 = DumpArchiveUtil.convert32(this.blockBuffer, 0);
            boolean bl4 = bl3 = (n2 & 1) == 1;
            if (!bl3) {
                this.readFully(this.blockBuffer, 0, this.blockSize);
                this.bytesRead += (long)this.blockSize;
            } else {
                int n3 = n2 >> 1 & 7;
                int n4 = n2 >> 4 & 0xFFFFFFF;
                byte[] byArray = new byte[n4];
                this.readFully(byArray, 0, n4);
                this.bytesRead += (long)n4;
                if (!bl2) {
                    Arrays.fill(this.blockBuffer, (byte)0);
                } else {
                    switch (DumpArchiveConstants.COMPRESSION_TYPE.find(n3 & 3)) {
                        case ZLIB: {
                            Inflater inflater = new Inflater();
                            try {
                                inflater.setInput(byArray, 0, byArray.length);
                                n4 = inflater.inflate(this.blockBuffer);
                                if (n4 != this.blockSize) {
                                    throw new ShortFileException();
                                }
                                break;
                            }
                            catch (DataFormatException dataFormatException) {
                                throw new DumpArchiveException("bad data", dataFormatException);
                            }
                            finally {
                                inflater.end();
                            }
                        }
                        case BZLIB: {
                            throw new UnsupportedCompressionAlgorithmException("BZLIB2");
                        }
                        case LZO: {
                            throw new UnsupportedCompressionAlgorithmException("LZO");
                        }
                        default: {
                            throw new UnsupportedCompressionAlgorithmException();
                        }
                    }
                }
            }
        }
        ++this.currBlkIdx;
        this.readOffset = 0;
    }

    private void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = IOUtils.readFully(this.in, byArray, n2, n3);
        if (n4 < n3) {
            throw new ShortFileException();
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

