/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.PasswordRequiredException;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;

class AES256SHA256Decoder
extends CoderBase {
    AES256SHA256Decoder() {
        super(new Class[0]);
    }

    @Override
    InputStream decode(final String string, final InputStream inputStream, long l2, final Coder coder, final byte[] byArray) throws IOException {
        return new InputStream(){
            private boolean isInitialized = false;
            private CipherInputStream cipherInputStream = null;

            private CipherInputStream init() throws IOException {
                Object object;
                Object object2;
                byte[] byArray4;
                if (this.isInitialized) {
                    return this.cipherInputStream;
                }
                int n2 = 0xFF & coder.properties[0];
                int n3 = n2 & 0x3F;
                int n4 = 0xFF & coder.properties[1];
                int n5 = (n2 >> 7 & 1) + (n4 >> 4);
                int n6 = (n2 >> 6 & 1) + (n4 & 0xF);
                if (2 + n5 + n6 > coder.properties.length) {
                    throw new IOException("Salt size + IV size too long in " + string);
                }
                byte[] byArray2 = new byte[n5];
                System.arraycopy(coder.properties, 2, byArray2, 0, n5);
                byte[] byArray3 = new byte[16];
                System.arraycopy(coder.properties, 2 + n5, byArray3, 0, n6);
                if (byArray == null) {
                    throw new PasswordRequiredException(string);
                }
                if (n3 == 63) {
                    byArray4 = new byte[32];
                    System.arraycopy(byArray2, 0, byArray4, 0, n5);
                    System.arraycopy(byArray, 0, byArray4, n5, Math.min(byArray.length, byArray4.length - n5));
                } else {
                    try {
                        object2 = MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new IOException("SHA-256 is unsupported by your Java implementation", noSuchAlgorithmException);
                    }
                    object = new byte[8];
                    block4: for (long i2 = 0L; i2 < 1L << n3; ++i2) {
                        ((MessageDigest)object2).update(byArray2);
                        ((MessageDigest)object2).update(byArray);
                        ((MessageDigest)object2).update((byte[])object);
                        for (int i3 = 0; i3 < ((byte[])object).length; ++i3) {
                            Object object3 = object;
                            int n7 = i3;
                            object3[n7] = (byte)(object3[n7] + 1);
                            if (object[i3] != false) continue block4;
                        }
                    }
                    byArray4 = ((MessageDigest)object2).digest();
                }
                object2 = new SecretKeySpec(byArray4, "AES");
                try {
                    object = Cipher.getInstance("AES/CBC/NoPadding");
                    ((Cipher)object).init(2, (Key)object2, new IvParameterSpec(byArray3));
                    this.cipherInputStream = new CipherInputStream(inputStream, (Cipher)object);
                    this.isInitialized = true;
                    return this.cipherInputStream;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IOException("Decryption error (do you have the JCE Unlimited Strength Jurisdiction Policy Files installed?)", generalSecurityException);
                }
            }

            @Override
            public int read() throws IOException {
                return this.init().read();
            }

            @Override
            public int read(byte[] byArray2, int n2, int n3) throws IOException {
                return this.init().read(byArray2, n2, n3);
            }

            @Override
            public void close() {
            }
        };
    }
}

