/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;

public class CLI {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            CLI.usage();
            return;
        }
        Mode mode = CLI.grabMode(stringArray);
        System.out.println(mode.getMessage() + " " + stringArray[0]);
        File file = new File(stringArray[0]);
        if (!file.isFile()) {
            System.err.println(file + " doesn't exist or is a directory");
        }
        try (SevenZFile sevenZFile = new SevenZFile(file);){
            SevenZArchiveEntry sevenZArchiveEntry;
            while ((sevenZArchiveEntry = sevenZFile.getNextEntry()) != null) {
                mode.takeAction(sevenZFile, sevenZArchiveEntry);
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [list|extract]");
    }

    private static Mode grabMode(String[] stringArray) {
        if (stringArray.length < 2) {
            return Mode.LIST;
        }
        return Enum.valueOf(Mode.class, stringArray[1].toUpperCase());
    }

    private static enum Mode {
        LIST("Analysing"){

            @Override
            public void takeAction(SevenZFile sevenZFile, SevenZArchiveEntry sevenZArchiveEntry) {
                System.out.print(sevenZArchiveEntry.getName());
                if (sevenZArchiveEntry.isDirectory()) {
                    System.out.print(" dir");
                } else {
                    System.out.print(" " + sevenZArchiveEntry.getCompressedSize() + "/" + sevenZArchiveEntry.getSize());
                }
                if (sevenZArchiveEntry.getHasLastModifiedDate()) {
                    System.out.print(" " + sevenZArchiveEntry.getLastModifiedDate());
                } else {
                    System.out.print(" no last modified date");
                }
                if (!sevenZArchiveEntry.isDirectory()) {
                    System.out.println(" " + this.getContentMethods(sevenZArchiveEntry));
                } else {
                    System.out.println("");
                }
            }

            private String getContentMethods(SevenZArchiveEntry sevenZArchiveEntry) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = true;
                for (SevenZMethodConfiguration sevenZMethodConfiguration : sevenZArchiveEntry.getContentMethods()) {
                    if (!bl2) {
                        stringBuilder.append(", ");
                    }
                    bl2 = false;
                    stringBuilder.append((Object)sevenZMethodConfiguration.getMethod());
                    if (sevenZMethodConfiguration.getOptions() == null) continue;
                    stringBuilder.append("(").append(sevenZMethodConfiguration.getOptions()).append(")");
                }
                return stringBuilder.toString();
            }
        }
        ,
        EXTRACT("Extracting"){
            private final byte[] buf = new byte[8192];

            @Override
            public void takeAction(SevenZFile sevenZFile, SevenZArchiveEntry sevenZArchiveEntry) throws IOException {
                File file = new File(sevenZArchiveEntry.getName());
                if (sevenZArchiveEntry.isDirectory()) {
                    if (!file.isDirectory() && !file.mkdirs()) {
                        throw new IOException("Cannot create directory " + file);
                    }
                    System.out.println("created directory " + file);
                    return;
                }
                System.out.println("extracting to " + file);
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                    throw new IOException("Cannot create " + file2);
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    int n2;
                    long l2 = sevenZArchiveEntry.getSize();
                    for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                        int n3 = (int)Math.min(l2 - i2, (long)this.buf.length);
                        n2 = sevenZFile.read(this.buf, 0, n3);
                        if (n2 < 1) {
                            throw new IOException("reached end of entry " + sevenZArchiveEntry.getName() + " after " + i2 + " bytes, expected " + l2);
                        }
                        fileOutputStream.write(this.buf, 0, n2);
                    }
                }
            }
        };

        private final String message;

        private Mode(String string2) {
            this.message = string2;
        }

        public String getMessage() {
            return this.message;
        }

        public abstract void takeAction(SevenZFile var1, SevenZArchiveEntry var2) throws IOException;
    }
}

