/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.archivers.sevenz.AES256SHA256Decoder;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.apache.commons.compress.archivers.sevenz.DeltaDecoder;
import org.apache.commons.compress.archivers.sevenz.LZMA2Decoder;
import org.apache.commons.compress.archivers.sevenz.LZMADecoder;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.utils.FlushShieldFilterOutputStream;
import org.tukaani.xz.ARMOptions;
import org.tukaani.xz.ARMThumbOptions;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.FinishableWrapperOutputStream;
import org.tukaani.xz.IA64Options;
import org.tukaani.xz.PowerPCOptions;
import org.tukaani.xz.SPARCOptions;
import org.tukaani.xz.X86Options;

class Coders {
    private static final Map<SevenZMethod, CoderBase> CODER_MAP = new HashMap<SevenZMethod, CoderBase>(){
        private static final long serialVersionUID = 1664829131806520867L;
        {
            this.put(SevenZMethod.COPY, new CopyDecoder());
            this.put(SevenZMethod.LZMA, new LZMADecoder());
            this.put(SevenZMethod.LZMA2, new LZMA2Decoder());
            this.put(SevenZMethod.DEFLATE, new DeflateDecoder());
            this.put(SevenZMethod.DEFLATE64, new Deflate64Decoder());
            this.put(SevenZMethod.BZIP2, new BZIP2Decoder());
            this.put(SevenZMethod.AES256SHA256, new AES256SHA256Decoder());
            this.put(SevenZMethod.BCJ_X86_FILTER, new BCJDecoder(new X86Options()));
            this.put(SevenZMethod.BCJ_PPC_FILTER, new BCJDecoder(new PowerPCOptions()));
            this.put(SevenZMethod.BCJ_IA64_FILTER, new BCJDecoder(new IA64Options()));
            this.put(SevenZMethod.BCJ_ARM_FILTER, new BCJDecoder(new ARMOptions()));
            this.put(SevenZMethod.BCJ_ARM_THUMB_FILTER, new BCJDecoder(new ARMThumbOptions()));
            this.put(SevenZMethod.BCJ_SPARC_FILTER, new BCJDecoder(new SPARCOptions()));
            this.put(SevenZMethod.DELTA_FILTER, new DeltaDecoder());
        }
    };

    Coders() {
    }

    static CoderBase findByMethod(SevenZMethod sevenZMethod) {
        return CODER_MAP.get((Object)sevenZMethod);
    }

    static InputStream addDecoder(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
        CoderBase coderBase = Coders.findByMethod(SevenZMethod.byId(coder.decompressionMethodId));
        if (coderBase == null) {
            throw new IOException("Unsupported compression method " + Arrays.toString(coder.decompressionMethodId) + " used in " + string);
        }
        return coderBase.decode(string, inputStream, l2, coder, byArray);
    }

    static OutputStream addEncoder(OutputStream outputStream, SevenZMethod sevenZMethod, Object object) throws IOException {
        CoderBase coderBase = Coders.findByMethod(sevenZMethod);
        if (coderBase == null) {
            throw new IOException("Unsupported compression method " + (Object)((Object)sevenZMethod));
        }
        return coderBase.encode(outputStream, object);
    }

    static class BZIP2Decoder
    extends CoderBase {
        BZIP2Decoder() {
            super(Number.class);
        }

        @Override
        InputStream decode(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
            return new BZip2CompressorInputStream(inputStream);
        }

        @Override
        OutputStream encode(OutputStream outputStream, Object object) throws IOException {
            int n2 = BZIP2Decoder.numberOptionOrDefault(object, 9);
            return new BZip2CompressorOutputStream(outputStream, n2);
        }
    }

    static class Deflate64Decoder
    extends CoderBase {
        Deflate64Decoder() {
            super(Number.class);
        }

        @Override
        InputStream decode(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
            return new Deflate64CompressorInputStream(inputStream);
        }
    }

    static class DeflateDecoder
    extends CoderBase {
        private static final byte[] ONE_ZERO_BYTE = new byte[1];

        DeflateDecoder() {
            super(Number.class);
        }

        @Override
        InputStream decode(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
            Inflater inflater = new Inflater(true);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new SequenceInputStream(inputStream, new ByteArrayInputStream(ONE_ZERO_BYTE)), inflater);
            return new DeflateDecoderInputStream(inflaterInputStream, inflater);
        }

        @Override
        OutputStream encode(OutputStream outputStream, Object object) {
            int n2 = DeflateDecoder.numberOptionOrDefault(object, 9);
            Deflater deflater = new Deflater(n2, true);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
            return new DeflateDecoderOutputStream(deflaterOutputStream, deflater);
        }

        static class DeflateDecoderOutputStream
        extends OutputStream {
            DeflaterOutputStream deflaterOutputStream;
            Deflater deflater;

            public DeflateDecoderOutputStream(DeflaterOutputStream deflaterOutputStream, Deflater deflater) {
                this.deflaterOutputStream = deflaterOutputStream;
                this.deflater = deflater;
            }

            @Override
            public void write(int n2) throws IOException {
                this.deflaterOutputStream.write(n2);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                this.deflaterOutputStream.write(byArray);
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                this.deflaterOutputStream.write(byArray, n2, n3);
            }

            @Override
            public void close() throws IOException {
                try {
                    this.deflaterOutputStream.close();
                }
                finally {
                    this.deflater.end();
                }
            }
        }

        static class DeflateDecoderInputStream
        extends InputStream {
            InflaterInputStream inflaterInputStream;
            Inflater inflater;

            public DeflateDecoderInputStream(InflaterInputStream inflaterInputStream, Inflater inflater) {
                this.inflaterInputStream = inflaterInputStream;
                this.inflater = inflater;
            }

            @Override
            public int read() throws IOException {
                return this.inflaterInputStream.read();
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                return this.inflaterInputStream.read(byArray, n2, n3);
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return this.inflaterInputStream.read(byArray);
            }

            @Override
            public void close() throws IOException {
                try {
                    this.inflaterInputStream.close();
                }
                finally {
                    this.inflater.end();
                }
            }
        }
    }

    static class BCJDecoder
    extends CoderBase {
        private final FilterOptions opts;

        BCJDecoder(FilterOptions filterOptions) {
            super(new Class[0]);
            this.opts = filterOptions;
        }

        @Override
        InputStream decode(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
            try {
                return this.opts.getInputStream(inputStream);
            }
            catch (AssertionError assertionError) {
                throw new IOException("BCJ filter used in " + string + " needs XZ for Java > 1.4 - see https://commons.apache.org/proper/commons-compress/limitations.html#7Z", (Throwable)((Object)assertionError));
            }
        }

        @Override
        OutputStream encode(OutputStream outputStream, Object object) {
            return new FlushShieldFilterOutputStream(this.opts.getOutputStream(new FinishableWrapperOutputStream(outputStream)));
        }
    }

    static class CopyDecoder
    extends CoderBase {
        CopyDecoder() {
            super(new Class[0]);
        }

        @Override
        InputStream decode(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
            return inputStream;
        }

        @Override
        OutputStream encode(OutputStream outputStream, Object object) {
            return outputStream;
        }
    }
}

