/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.FlushShieldFilterOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.LZMAOutputStream;

class LZMADecoder
extends CoderBase {
    LZMADecoder() {
        super(LZMA2Options.class, Number.class);
    }

    @Override
    InputStream decode(String string, InputStream inputStream, long l2, Coder coder, byte[] byArray) throws IOException {
        byte by2 = coder.properties[0];
        int n2 = this.getDictionarySize(coder);
        if (n2 > 0x7FFFFFF0) {
            throw new IOException("Dictionary larger than 4GiB maximum size used in " + string);
        }
        return new LZMAInputStream(inputStream, l2, by2, n2);
    }

    @Override
    OutputStream encode(OutputStream outputStream, Object object) throws IOException {
        return new FlushShieldFilterOutputStream(new LZMAOutputStream(outputStream, this.getOptions(object), false));
    }

    @Override
    byte[] getOptionsAsProperties(Object object) throws IOException {
        LZMA2Options lZMA2Options = this.getOptions(object);
        byte by2 = (byte)((lZMA2Options.getPb() * 5 + lZMA2Options.getLp()) * 9 + lZMA2Options.getLc());
        int n2 = lZMA2Options.getDictSize();
        byte[] byArray = new byte[5];
        byArray[0] = by2;
        ByteUtils.toLittleEndian(byArray, n2, 1, 4);
        return byArray;
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream inputStream) throws IOException {
        byte by2 = coder.properties[0];
        int n2 = by2 & 0xFF;
        int n3 = n2 / 45;
        int n4 = (n2 -= n3 * 9 * 5) / 9;
        int n5 = n2 - n4 * 9;
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setPb(n3);
        lZMA2Options.setLcLp(n5, n4);
        lZMA2Options.setDictSize(this.getDictionarySize(coder));
        return lZMA2Options;
    }

    private int getDictionarySize(Coder coder) throws IllegalArgumentException {
        return (int)ByteUtils.fromLittleEndian(coder.properties, 1, 4);
    }

    private LZMA2Options getOptions(Object object) throws IOException {
        if (object instanceof LZMA2Options) {
            return (LZMA2Options)object;
        }
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setDictSize(this.numberOptionOrDefault(object));
        return lZMA2Options;
    }

    private int numberOptionOrDefault(Object object) {
        return LZMADecoder.numberOptionOrDefault(object, 0x800000);
    }
}

