/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.sevenz.Archive;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.BoundedSeekableByteChannelInputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.archivers.sevenz.Folder;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.StartHeader;
import org.apache.commons.compress.archivers.sevenz.StreamMap;
import org.apache.commons.compress.archivers.sevenz.SubStreamsInfo;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.CRC32VerifyingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class SevenZFile
implements Closeable {
    static final int SIGNATURE_HEADER_SIZE = 32;
    private final String fileName;
    private SeekableByteChannel channel;
    private final Archive archive;
    private int currentEntryIndex = -1;
    private int currentFolderIndex = -1;
    private InputStream currentFolderInputStream = null;
    private byte[] password;
    private long compressedBytesReadFromCurrentEntry;
    private long uncompressedBytesReadFromCurrentEntry;
    private final ArrayList<InputStream> deferredBlockStreams = new ArrayList();
    static final byte[] sevenZSignature = new byte[]{55, 122, -68, -81, 39, 28};
    private static final CharsetEncoder PASSWORD_ENCODER = StandardCharsets.UTF_16LE.newEncoder();

    public SevenZFile(File file, char[] cArray) throws IOException {
        this(Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]), file.getAbsolutePath(), SevenZFile.utf16Decode(cArray), true);
    }

    public SevenZFile(File file, byte[] byArray) throws IOException {
        this(Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]), file.getAbsolutePath(), byArray, true);
    }

    public SevenZFile(SeekableByteChannel seekableByteChannel) throws IOException {
        this(seekableByteChannel, "unknown archive", (char[])null);
    }

    public SevenZFile(SeekableByteChannel seekableByteChannel, char[] cArray) throws IOException {
        this(seekableByteChannel, "unknown archive", SevenZFile.utf16Decode(cArray));
    }

    public SevenZFile(SeekableByteChannel seekableByteChannel, String string, char[] cArray) throws IOException {
        this(seekableByteChannel, string, SevenZFile.utf16Decode(cArray), false);
    }

    public SevenZFile(SeekableByteChannel seekableByteChannel, String string) throws IOException {
        this(seekableByteChannel, string, null, false);
    }

    public SevenZFile(SeekableByteChannel seekableByteChannel, byte[] byArray) throws IOException {
        this(seekableByteChannel, "unknown archive", byArray);
    }

    public SevenZFile(SeekableByteChannel seekableByteChannel, String string, byte[] byArray) throws IOException {
        this(seekableByteChannel, string, byArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SevenZFile(SeekableByteChannel seekableByteChannel, String string, byte[] byArray, boolean bl2) throws IOException {
        boolean bl3 = false;
        this.channel = seekableByteChannel;
        this.fileName = string;
        try {
            this.archive = this.readHeaders(byArray);
            this.password = (byte[])(byArray != null ? Arrays.copyOf(byArray, byArray.length) : null);
            bl3 = true;
        }
        finally {
            if (!bl3 && bl2) {
                this.channel.close();
            }
        }
    }

    public SevenZFile(File file) throws IOException {
        this(file, (char[])null);
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            finally {
                this.channel = null;
                if (this.password != null) {
                    Arrays.fill(this.password, (byte)0);
                }
                this.password = null;
            }
        }
    }

    public SevenZArchiveEntry getNextEntry() throws IOException {
        if (this.currentEntryIndex >= this.archive.files.length - 1) {
            return null;
        }
        ++this.currentEntryIndex;
        SevenZArchiveEntry sevenZArchiveEntry = this.archive.files[this.currentEntryIndex];
        this.buildDecodingStream();
        this.compressedBytesReadFromCurrentEntry = 0L;
        this.uncompressedBytesReadFromCurrentEntry = 0L;
        return sevenZArchiveEntry;
    }

    public Iterable<SevenZArchiveEntry> getEntries() {
        return Arrays.asList(this.archive.files);
    }

    private Archive readHeaders(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        this.readFully(byteBuffer);
        byte[] byArray2 = new byte[6];
        byteBuffer.get(byArray2);
        if (!Arrays.equals(byArray2, sevenZSignature)) {
            throw new IOException("Bad 7z signature");
        }
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        if (by2 != 0) {
            throw new IOException(String.format("Unsupported 7z version (%d,%d)", by2, by3));
        }
        long l2 = 0xFFFFFFFFL & (long)byteBuffer.getInt();
        StartHeader startHeader = this.readStartHeader(l2);
        int n2 = (int)startHeader.nextHeaderSize;
        if ((long)n2 != startHeader.nextHeaderSize) {
            throw new IOException("cannot handle nextHeaderSize " + startHeader.nextHeaderSize);
        }
        this.channel.position(32L + startHeader.nextHeaderOffset);
        byteBuffer = ByteBuffer.allocate(n2).order(ByteOrder.LITTLE_ENDIAN);
        this.readFully(byteBuffer);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byteBuffer.array());
        if (startHeader.nextHeaderCrc != cRC32.getValue()) {
            throw new IOException("NextHeader CRC mismatch");
        }
        Archive archive = new Archive();
        int n3 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n3 == 23) {
            byteBuffer = this.readEncodedHeader(byteBuffer, archive, byArray);
            archive = new Archive();
            n3 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n3 != 1) {
            throw new IOException("Broken or unsupported archive: no Header");
        }
        this.readHeader(byteBuffer, archive);
        return archive;
    }

    private StartHeader readStartHeader(long l2) throws IOException {
        StartHeader startHeader = new StartHeader();
        try (DataInputStream dataInputStream = new DataInputStream(new CRC32VerifyingInputStream((InputStream)new BoundedSeekableByteChannelInputStream(this.channel, 20L), 20L, l2));){
            startHeader.nextHeaderOffset = Long.reverseBytes(dataInputStream.readLong());
            startHeader.nextHeaderSize = Long.reverseBytes(dataInputStream.readLong());
            startHeader.nextHeaderCrc = 0xFFFFFFFFL & (long)Integer.reverseBytes(dataInputStream.readInt());
            StartHeader startHeader2 = startHeader;
            return startHeader2;
        }
    }

    private void readHeader(ByteBuffer byteBuffer, Archive archive) throws IOException {
        int n2 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n2 == 2) {
            this.readArchiveProperties(byteBuffer);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n2 == 3) {
            throw new IOException("Additional streams unsupported");
        }
        if (n2 == 4) {
            this.readStreamsInfo(byteBuffer, archive);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n2 == 5) {
            this.readFilesInfo(byteBuffer, archive);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n2 != 0) {
            throw new IOException("Badly terminated header, found " + n2);
        }
    }

    private void readArchiveProperties(ByteBuffer byteBuffer) throws IOException {
        int n2 = SevenZFile.getUnsignedByte(byteBuffer);
        while (n2 != 0) {
            long l2 = SevenZFile.readUint64(byteBuffer);
            byte[] byArray = new byte[(int)l2];
            byteBuffer.get(byArray);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
    }

    private ByteBuffer readEncodedHeader(ByteBuffer byteBuffer, Archive archive, byte[] byArray) throws IOException {
        this.readStreamsInfo(byteBuffer, archive);
        Folder folder = archive.folders[0];
        boolean bl2 = false;
        long l2 = 32L + archive.packPos + 0L;
        this.channel.position(l2);
        InputStream inputStream = new BoundedSeekableByteChannelInputStream(this.channel, archive.packSizes[0]);
        for (Coder object2 : folder.getOrderedCoders()) {
            if (object2.numInStreams != 1L || object2.numOutStreams != 1L) {
                throw new IOException("Multi input/output stream coders are not yet supported");
            }
            inputStream = Coders.addDecoder(this.fileName, inputStream, folder.getUnpackSizeForCoder(object2), object2, byArray);
        }
        if (folder.hasCrc) {
            inputStream = new CRC32VerifyingInputStream(inputStream, folder.getUnpackSize(), folder.crc);
        }
        Object object3 = new byte[(int)folder.getUnpackSize()];
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            dataInputStream.readFully((byte[])object3);
        }
        return ByteBuffer.wrap((byte[])object3).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void readStreamsInfo(ByteBuffer byteBuffer, Archive archive) throws IOException {
        int n2 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n2 == 6) {
            this.readPackInfo(byteBuffer, archive);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n2 == 7) {
            this.readUnpackInfo(byteBuffer, archive);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        } else {
            archive.folders = new Folder[0];
        }
        if (n2 == 8) {
            this.readSubStreamsInfo(byteBuffer, archive);
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n2 != 0) {
            throw new IOException("Badly terminated StreamsInfo");
        }
    }

    private void readPackInfo(ByteBuffer byteBuffer, Archive archive) throws IOException {
        int n2;
        archive.packPos = SevenZFile.readUint64(byteBuffer);
        long l2 = SevenZFile.readUint64(byteBuffer);
        int n3 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n3 == 9) {
            archive.packSizes = new long[(int)l2];
            for (n2 = 0; n2 < archive.packSizes.length; ++n2) {
                archive.packSizes[n2] = SevenZFile.readUint64(byteBuffer);
            }
            n3 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n3 == 10) {
            archive.packCrcsDefined = this.readAllOrBits(byteBuffer, (int)l2);
            archive.packCrcs = new long[(int)l2];
            for (n2 = 0; n2 < (int)l2; ++n2) {
                if (!archive.packCrcsDefined.get(n2)) continue;
                archive.packCrcs[n2] = 0xFFFFFFFFL & (long)byteBuffer.getInt();
            }
            n3 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n3 != 0) {
            throw new IOException("Badly terminated PackInfo (" + n3 + ")");
        }
    }

    private void readUnpackInfo(ByteBuffer byteBuffer, Archive archive) throws IOException {
        int n2 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n2 != 11) {
            throw new IOException("Expected kFolder, got " + n2);
        }
        long l2 = SevenZFile.readUint64(byteBuffer);
        Folder[] folderArray = new Folder[(int)l2];
        archive.folders = folderArray;
        int n3 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n3 != 0) {
            throw new IOException("External unsupported");
        }
        for (int i2 = 0; i2 < (int)l2; ++i2) {
            folderArray[i2] = this.readFolder(byteBuffer);
        }
        n2 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n2 != 12) {
            throw new IOException("Expected kCodersUnpackSize, got " + n2);
        }
        for (Folder folder : folderArray) {
            folder.unpackSizes = new long[(int)folder.totalOutputStreams];
            int n4 = 0;
            while ((long)n4 < folder.totalOutputStreams) {
                folder.unpackSizes[n4] = SevenZFile.readUint64(byteBuffer);
                ++n4;
            }
        }
        n2 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n2 == 10) {
            BitSet bitSet = this.readAllOrBits(byteBuffer, (int)l2);
            for (int i3 = 0; i3 < (int)l2; ++i3) {
                if (bitSet.get(i3)) {
                    folderArray[i3].hasCrc = true;
                    folderArray[i3].crc = 0xFFFFFFFFL & (long)byteBuffer.getInt();
                    continue;
                }
                folderArray[i3].hasCrc = false;
            }
            n2 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n2 != 0) {
            throw new IOException("Badly terminated UnpackInfo");
        }
    }

    private void readSubStreamsInfo(ByteBuffer byteBuffer, Archive archive) throws IOException {
        for (Folder folder : archive.folders) {
            folder.numUnpackSubStreams = 1;
        }
        int n2 = archive.folders.length;
        int n3 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n3 == 13) {
            n2 = 0;
            for (Folder folder : archive.folders) {
                long l2 = SevenZFile.readUint64(byteBuffer);
                folder.numUnpackSubStreams = (int)l2;
                n2 = (int)((long)n2 + l2);
            }
            n3 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        SubStreamsInfo subStreamsInfo = new SubStreamsInfo();
        subStreamsInfo.unpackSizes = new long[n2];
        subStreamsInfo.hasCrc = new BitSet(n2);
        subStreamsInfo.crcs = new long[n2];
        int n4 = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 0) continue;
            long l3 = 0L;
            if (n3 == 9) {
                for (int i2 = 0; i2 < folder.numUnpackSubStreams - 1; ++i2) {
                    long l4 = SevenZFile.readUint64(byteBuffer);
                    subStreamsInfo.unpackSizes[n4++] = l4;
                    l3 += l4;
                }
            }
            subStreamsInfo.unpackSizes[n4++] = folder.getUnpackSize() - l3;
        }
        if (n3 == 9) {
            n3 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        int n5 = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 1 && folder.hasCrc) continue;
            n5 += folder.numUnpackSubStreams;
        }
        if (n3 == 10) {
            int n6;
            BitSet bitSet = this.readAllOrBits(byteBuffer, n5);
            long[] lArray = new long[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                if (!bitSet.get(n6)) continue;
                lArray[n6] = 0xFFFFFFFFL & (long)byteBuffer.getInt();
            }
            n6 = 0;
            int n7 = 0;
            for (Folder folder : archive.folders) {
                if (folder.numUnpackSubStreams == 1 && folder.hasCrc) {
                    subStreamsInfo.hasCrc.set(n6, true);
                    subStreamsInfo.crcs[n6] = folder.crc;
                    ++n6;
                    continue;
                }
                for (int i3 = 0; i3 < folder.numUnpackSubStreams; ++i3) {
                    subStreamsInfo.hasCrc.set(n6, bitSet.get(n7));
                    subStreamsInfo.crcs[n6] = lArray[n7];
                    ++n6;
                    ++n7;
                }
            }
            n3 = SevenZFile.getUnsignedByte(byteBuffer);
        }
        if (n3 != 0) {
            throw new IOException("Badly terminated SubStreamsInfo");
        }
        archive.subStreamsInfo = subStreamsInfo;
    }

    private Folder readFolder(ByteBuffer byteBuffer) throws IOException {
        int n2;
        Folder folder = new Folder();
        long l2 = SevenZFile.readUint64(byteBuffer);
        Coder[] coderArray = new Coder[(int)l2];
        long l3 = 0L;
        long l4 = 0L;
        for (int i2 = 0; i2 < coderArray.length; ++i2) {
            coderArray[i2] = new Coder();
            int n3 = SevenZFile.getUnsignedByte(byteBuffer);
            int n4 = n3 & 0xF;
            n2 = (n3 & 0x10) == 0 ? 1 : 0;
            boolean bl2 = (n3 & 0x20) != 0;
            boolean bl3 = (n3 & 0x80) != 0;
            coderArray[i2].decompressionMethodId = new byte[n4];
            byteBuffer.get(coderArray[i2].decompressionMethodId);
            if (n2 != 0) {
                coderArray[i2].numInStreams = 1L;
                coderArray[i2].numOutStreams = 1L;
            } else {
                coderArray[i2].numInStreams = SevenZFile.readUint64(byteBuffer);
                coderArray[i2].numOutStreams = SevenZFile.readUint64(byteBuffer);
            }
            l3 += coderArray[i2].numInStreams;
            l4 += coderArray[i2].numOutStreams;
            if (bl2) {
                long l5 = SevenZFile.readUint64(byteBuffer);
                coderArray[i2].properties = new byte[(int)l5];
                byteBuffer.get(coderArray[i2].properties);
            }
            if (!bl3) continue;
            throw new IOException("Alternative methods are unsupported, please report. The reference implementation doesn't support them either.");
        }
        folder.coders = coderArray;
        folder.totalInputStreams = l3;
        folder.totalOutputStreams = l4;
        if (l4 == 0L) {
            throw new IOException("Total output streams can't be 0");
        }
        long l6 = l4 - 1L;
        BindPair[] bindPairArray = new BindPair[(int)l6];
        for (n2 = 0; n2 < bindPairArray.length; ++n2) {
            bindPairArray[n2] = new BindPair();
            bindPairArray[n2].inIndex = SevenZFile.readUint64(byteBuffer);
            bindPairArray[n2].outIndex = SevenZFile.readUint64(byteBuffer);
        }
        folder.bindPairs = bindPairArray;
        if (l3 < l6) {
            throw new IOException("Total input streams can't be less than the number of bind pairs");
        }
        long l7 = l3 - l6;
        long[] lArray = new long[(int)l7];
        if (l7 == 1L) {
            int n5;
            for (n5 = 0; n5 < (int)l3 && folder.findBindPairForInStream(n5) >= 0; ++n5) {
            }
            if (n5 == (int)l3) {
                throw new IOException("Couldn't find stream's bind pair index");
            }
            lArray[0] = n5;
        } else {
            for (int i3 = 0; i3 < (int)l7; ++i3) {
                lArray[i3] = SevenZFile.readUint64(byteBuffer);
            }
        }
        folder.packedStreams = lArray;
        return folder;
    }

    private BitSet readAllOrBits(ByteBuffer byteBuffer, int n2) throws IOException {
        BitSet bitSet;
        int n3 = SevenZFile.getUnsignedByte(byteBuffer);
        if (n3 != 0) {
            bitSet = new BitSet(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                bitSet.set(i2, true);
            }
        } else {
            bitSet = this.readBits(byteBuffer, n2);
        }
        return bitSet;
    }

    private BitSet readBits(ByteBuffer byteBuffer, int n2) throws IOException {
        BitSet bitSet = new BitSet(n2);
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n3 == 0) {
                n3 = 128;
                n4 = SevenZFile.getUnsignedByte(byteBuffer);
            }
            bitSet.set(i2, (n4 & n3) != 0);
            n3 >>>= 1;
        }
        return bitSet;
    }

    private void readFilesInfo(ByteBuffer byteBuffer, Archive archive) throws IOException {
        int n2;
        long l2 = SevenZFile.readUint64(byteBuffer);
        SevenZArchiveEntry[] sevenZArchiveEntryArray = new SevenZArchiveEntry[(int)l2];
        for (int i2 = 0; i2 < sevenZArchiveEntryArray.length; ++i2) {
            sevenZArchiveEntryArray[i2] = new SevenZArchiveEntry();
        }
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        block13: while ((n2 = SevenZFile.getUnsignedByte(byteBuffer)) != 0) {
            long l3 = SevenZFile.readUint64(byteBuffer);
            switch (n2) {
                case 14: {
                    bitSet = this.readBits(byteBuffer, sevenZArchiveEntryArray.length);
                    break;
                }
                case 15: {
                    if (bitSet == null) {
                        throw new IOException("Header format error: kEmptyStream must appear before kEmptyFile");
                    }
                    bitSet2 = this.readBits(byteBuffer, bitSet.cardinality());
                    break;
                }
                case 16: {
                    if (bitSet == null) {
                        throw new IOException("Header format error: kEmptyStream must appear before kAnti");
                    }
                    bitSet3 = this.readBits(byteBuffer, bitSet.cardinality());
                    break;
                }
                case 17: {
                    int n3 = SevenZFile.getUnsignedByte(byteBuffer);
                    if (n3 != 0) {
                        throw new IOException("Not implemented");
                    }
                    if ((l3 - 1L & 1L) != 0L) {
                        throw new IOException("File names length invalid");
                    }
                    byte[] byArray = new byte[(int)(l3 - 1L)];
                    byteBuffer.get(byArray);
                    int n4 = 0;
                    int n5 = 0;
                    for (int i3 = 0; i3 < byArray.length; i3 += 2) {
                        if (byArray[i3] != 0 || byArray[i3 + 1] != 0) continue;
                        sevenZArchiveEntryArray[n4++].setName(new String(byArray, n5, i3 - n5, "UTF-16LE"));
                        n5 = i3 + 2;
                    }
                    if (n5 == byArray.length && n4 == sevenZArchiveEntryArray.length) continue block13;
                    throw new IOException("Error parsing file names");
                }
                case 18: {
                    int n4;
                    BitSet bitSet4 = this.readAllOrBits(byteBuffer, sevenZArchiveEntryArray.length);
                    int n6 = SevenZFile.getUnsignedByte(byteBuffer);
                    if (n6 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasCreationDate(bitSet4.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasCreationDate()) continue;
                        sevenZArchiveEntryArray[n4].setCreationDate(byteBuffer.getLong());
                    }
                    continue block13;
                }
                case 19: {
                    int n4;
                    BitSet bitSet5 = this.readAllOrBits(byteBuffer, sevenZArchiveEntryArray.length);
                    int n7 = SevenZFile.getUnsignedByte(byteBuffer);
                    if (n7 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasAccessDate(bitSet5.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasAccessDate()) continue;
                        sevenZArchiveEntryArray[n4].setAccessDate(byteBuffer.getLong());
                    }
                    continue block13;
                }
                case 20: {
                    int n4;
                    BitSet bitSet6 = this.readAllOrBits(byteBuffer, sevenZArchiveEntryArray.length);
                    int n8 = SevenZFile.getUnsignedByte(byteBuffer);
                    if (n8 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasLastModifiedDate(bitSet6.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasLastModifiedDate()) continue;
                        sevenZArchiveEntryArray[n4].setLastModifiedDate(byteBuffer.getLong());
                    }
                    continue block13;
                }
                case 21: {
                    int n4;
                    BitSet bitSet7 = this.readAllOrBits(byteBuffer, sevenZArchiveEntryArray.length);
                    int n9 = SevenZFile.getUnsignedByte(byteBuffer);
                    if (n9 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasWindowsAttributes(bitSet7.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasWindowsAttributes()) continue;
                        sevenZArchiveEntryArray[n4].setWindowsAttributes(byteBuffer.getInt());
                    }
                    continue block13;
                }
                case 24: {
                    throw new IOException("kStartPos is unsupported, please report");
                }
                case 25: {
                    if (SevenZFile.skipBytesFully(byteBuffer, l3) >= l3) continue block13;
                    throw new IOException("Incomplete kDummy property");
                }
                default: {
                    if (SevenZFile.skipBytesFully(byteBuffer, l3) >= l3) continue block13;
                    throw new IOException("Incomplete property of type " + n2);
                }
            }
        }
        n2 = 0;
        int n10 = 0;
        for (int i4 = 0; i4 < sevenZArchiveEntryArray.length; ++i4) {
            sevenZArchiveEntryArray[i4].setHasStream(bitSet == null || !bitSet.get(i4));
            if (sevenZArchiveEntryArray[i4].hasStream()) {
                sevenZArchiveEntryArray[i4].setDirectory(false);
                sevenZArchiveEntryArray[i4].setAntiItem(false);
                sevenZArchiveEntryArray[i4].setHasCrc(archive.subStreamsInfo.hasCrc.get(n2));
                sevenZArchiveEntryArray[i4].setCrcValue(archive.subStreamsInfo.crcs[n2]);
                sevenZArchiveEntryArray[i4].setSize(archive.subStreamsInfo.unpackSizes[n2]);
                ++n2;
                continue;
            }
            sevenZArchiveEntryArray[i4].setDirectory(bitSet2 == null || !bitSet2.get(n10));
            sevenZArchiveEntryArray[i4].setAntiItem(bitSet3 != null && bitSet3.get(n10));
            sevenZArchiveEntryArray[i4].setHasCrc(false);
            sevenZArchiveEntryArray[i4].setSize(0L);
            ++n10;
        }
        archive.files = sevenZArchiveEntryArray;
        this.calculateStreamMap(archive);
    }

    private void calculateStreamMap(Archive archive) throws IOException {
        int n2;
        StreamMap streamMap = new StreamMap();
        int n3 = 0;
        int n4 = archive.folders != null ? archive.folders.length : 0;
        streamMap.folderFirstPackStreamIndex = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            streamMap.folderFirstPackStreamIndex[i2] = n3;
            n3 += archive.folders[i2].packedStreams.length;
        }
        long l2 = 0L;
        int n5 = archive.packSizes != null ? archive.packSizes.length : 0;
        streamMap.packStreamOffsets = new long[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            streamMap.packStreamOffsets[n2] = l2;
            l2 += archive.packSizes[n2];
        }
        streamMap.folderFirstFileIndex = new int[n4];
        streamMap.fileFolderIndex = new int[archive.files.length];
        n2 = 0;
        int n6 = 0;
        for (int i3 = 0; i3 < archive.files.length; ++i3) {
            if (!archive.files[i3].hasStream() && n6 == 0) {
                streamMap.fileFolderIndex[i3] = -1;
                continue;
            }
            if (n6 == 0) {
                while (n2 < archive.folders.length) {
                    streamMap.folderFirstFileIndex[n2] = i3;
                    if (archive.folders[n2].numUnpackSubStreams > 0) break;
                    ++n2;
                }
                if (n2 >= archive.folders.length) {
                    throw new IOException("Too few folders in archive");
                }
            }
            streamMap.fileFolderIndex[i3] = n2;
            if (!archive.files[i3].hasStream() || ++n6 < archive.folders[n2].numUnpackSubStreams) continue;
            ++n2;
            n6 = 0;
        }
        archive.streamMap = streamMap;
    }

    private void buildDecodingStream() throws IOException {
        Object object;
        int n2 = this.archive.streamMap.fileFolderIndex[this.currentEntryIndex];
        if (n2 < 0) {
            this.deferredBlockStreams.clear();
            return;
        }
        SevenZArchiveEntry sevenZArchiveEntry = this.archive.files[this.currentEntryIndex];
        if (this.currentFolderIndex == n2) {
            sevenZArchiveEntry.setContentMethods(this.archive.files[this.currentEntryIndex - 1].getContentMethods());
        } else {
            this.currentFolderIndex = n2;
            this.deferredBlockStreams.clear();
            if (this.currentFolderInputStream != null) {
                this.currentFolderInputStream.close();
                this.currentFolderInputStream = null;
            }
            object = this.archive.folders[n2];
            int n3 = this.archive.streamMap.folderFirstPackStreamIndex[n2];
            long l2 = 32L + this.archive.packPos + this.archive.streamMap.packStreamOffsets[n3];
            this.currentFolderInputStream = this.buildDecoderStack((Folder)object, l2, n3, sevenZArchiveEntry);
        }
        object = new BoundedInputStream(this.currentFolderInputStream, sevenZArchiveEntry.getSize());
        if (sevenZArchiveEntry.getHasCrc()) {
            object = new CRC32VerifyingInputStream((InputStream)object, sevenZArchiveEntry.getSize(), sevenZArchiveEntry.getCrcValue());
        }
        this.deferredBlockStreams.add((InputStream)object);
    }

    private InputStream buildDecoderStack(Folder folder, long l2, int n2, SevenZArchiveEntry sevenZArchiveEntry) throws IOException {
        this.channel.position(l2);
        InputStream inputStream = new FilterInputStream(new BufferedInputStream(new BoundedSeekableByteChannelInputStream(this.channel, this.archive.packSizes[n2]))){

            @Override
            public int read() throws IOException {
                int n2 = this.in.read();
                if (n2 >= 0) {
                    this.count(1);
                }
                return n2;
            }

            @Override
            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4 = this.in.read(byArray, n2, n3);
                if (n4 >= 0) {
                    this.count(n4);
                }
                return n4;
            }

            private void count(int n2) {
                SevenZFile.this.compressedBytesReadFromCurrentEntry = SevenZFile.this.compressedBytesReadFromCurrentEntry + (long)n2;
            }
        };
        LinkedList<SevenZMethodConfiguration> linkedList = new LinkedList<SevenZMethodConfiguration>();
        for (Coder coder : folder.getOrderedCoders()) {
            if (coder.numInStreams != 1L || coder.numOutStreams != 1L) {
                throw new IOException("Multi input/output stream coders are not yet supported");
            }
            SevenZMethod sevenZMethod = SevenZMethod.byId(coder.decompressionMethodId);
            inputStream = Coders.addDecoder(this.fileName, inputStream, folder.getUnpackSizeForCoder(coder), coder, this.password);
            linkedList.addFirst(new SevenZMethodConfiguration(sevenZMethod, Coders.findByMethod(sevenZMethod).getOptionsFromCoder(coder, inputStream)));
        }
        sevenZArchiveEntry.setContentMethods(linkedList);
        if (folder.hasCrc) {
            return new CRC32VerifyingInputStream(inputStream, folder.getUnpackSize(), folder.crc);
        }
        return inputStream;
    }

    public int read() throws IOException {
        int n2 = this.getCurrentStream().read();
        if (n2 >= 0) {
            ++this.uncompressedBytesReadFromCurrentEntry;
        }
        return n2;
    }

    private InputStream getCurrentStream() throws IOException {
        if (this.archive.files[this.currentEntryIndex].getSize() == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (this.deferredBlockStreams.isEmpty()) {
            throw new IllegalStateException("No current 7z entry (call getNextEntry() first).");
        }
        while (this.deferredBlockStreams.size() > 1) {
            try (InputStream inputStream = this.deferredBlockStreams.remove(0);){
                IOUtils.skip(inputStream, Long.MAX_VALUE);
            }
            this.compressedBytesReadFromCurrentEntry = 0L;
        }
        return this.deferredBlockStreams.get(0);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.getCurrentStream().read(byArray, n2, n3);
        if (n4 > 0) {
            this.uncompressedBytesReadFromCurrentEntry += (long)n4;
        }
        return n4;
    }

    public InputStreamStatistics getStatisticsForCurrentEntry() {
        return new InputStreamStatistics(){

            @Override
            public long getCompressedCount() {
                return SevenZFile.this.compressedBytesReadFromCurrentEntry;
            }

            @Override
            public long getUncompressedCount() {
                return SevenZFile.this.uncompressedBytesReadFromCurrentEntry;
            }
        };
    }

    private static long readUint64(ByteBuffer byteBuffer) throws IOException {
        long l2 = SevenZFile.getUnsignedByte(byteBuffer);
        int n2 = 128;
        long l3 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            if ((l2 & (long)n2) == 0L) {
                return l3 | (l2 & (long)(n2 - 1)) << 8 * i2;
            }
            long l4 = SevenZFile.getUnsignedByte(byteBuffer);
            l3 |= l4 << 8 * i2;
            n2 >>>= 1;
        }
        return l3;
    }

    private static int getUnsignedByte(ByteBuffer byteBuffer) {
        return byteBuffer.get() & 0xFF;
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < sevenZSignature.length) {
            return false;
        }
        for (int i2 = 0; i2 < sevenZSignature.length; ++i2) {
            if (byArray[i2] == sevenZSignature[i2]) continue;
            return false;
        }
        return true;
    }

    private static long skipBytesFully(ByteBuffer byteBuffer, long l2) throws IOException {
        if (l2 < 1L) {
            return 0L;
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        if ((long)n3 < l2) {
            l2 = n3;
        }
        byteBuffer.position(n2 + (int)l2);
        return l2;
    }

    private void readFully(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.rewind();
        IOUtils.readFully(this.channel, byteBuffer);
        byteBuffer.flip();
    }

    public String toString() {
        return this.archive.toString();
    }

    private static byte[] utf16Decode(char[] cArray) throws IOException {
        if (cArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = PASSWORD_ENCODER.encode(CharBuffer.wrap(cArray));
        if (byteBuffer.hasArray()) {
            return byteBuffer.array();
        }
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }
}

