/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.utils.CountingOutputStream;

public class SevenZOutputFile
implements Closeable {
    private final SeekableByteChannel channel;
    private final List<SevenZArchiveEntry> files = new ArrayList<SevenZArchiveEntry>();
    private int numNonEmptyStreams = 0;
    private final CRC32 crc32 = new CRC32();
    private final CRC32 compressedCrc32 = new CRC32();
    private long fileBytesWritten = 0L;
    private boolean finished = false;
    private CountingOutputStream currentOutputStream;
    private CountingOutputStream[] additionalCountingStreams;
    private Iterable<? extends SevenZMethodConfiguration> contentMethods = Collections.singletonList(new SevenZMethodConfiguration(SevenZMethod.LZMA2));
    private final Map<SevenZArchiveEntry, long[]> additionalSizes = new HashMap<SevenZArchiveEntry, long[]>();

    public SevenZOutputFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]));
    }

    public SevenZOutputFile(SeekableByteChannel seekableByteChannel) throws IOException {
        this.channel = seekableByteChannel;
        seekableByteChannel.position(32L);
    }

    public void setContentCompression(SevenZMethod sevenZMethod) {
        this.setContentMethods(Collections.singletonList(new SevenZMethodConfiguration(sevenZMethod)));
    }

    public void setContentMethods(Iterable<? extends SevenZMethodConfiguration> iterable) {
        this.contentMethods = SevenZOutputFile.reverse(iterable);
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.finished) {
                this.finish();
            }
        }
        finally {
            this.channel.close();
        }
    }

    public SevenZArchiveEntry createArchiveEntry(File file, String string) throws IOException {
        SevenZArchiveEntry sevenZArchiveEntry = new SevenZArchiveEntry();
        sevenZArchiveEntry.setDirectory(file.isDirectory());
        sevenZArchiveEntry.setName(string);
        sevenZArchiveEntry.setLastModifiedDate(new Date(file.lastModified()));
        return sevenZArchiveEntry;
    }

    public void putArchiveEntry(ArchiveEntry archiveEntry) throws IOException {
        SevenZArchiveEntry sevenZArchiveEntry = (SevenZArchiveEntry)archiveEntry;
        this.files.add(sevenZArchiveEntry);
    }

    public void closeArchiveEntry() throws IOException {
        if (this.currentOutputStream != null) {
            this.currentOutputStream.flush();
            this.currentOutputStream.close();
        }
        SevenZArchiveEntry sevenZArchiveEntry = this.files.get(this.files.size() - 1);
        if (this.fileBytesWritten > 0L) {
            sevenZArchiveEntry.setHasStream(true);
            ++this.numNonEmptyStreams;
            sevenZArchiveEntry.setSize(this.currentOutputStream.getBytesWritten());
            sevenZArchiveEntry.setCompressedSize(this.fileBytesWritten);
            sevenZArchiveEntry.setCrcValue(this.crc32.getValue());
            sevenZArchiveEntry.setCompressedCrcValue(this.compressedCrc32.getValue());
            sevenZArchiveEntry.setHasCrc(true);
            if (this.additionalCountingStreams != null) {
                long[] lArray = new long[this.additionalCountingStreams.length];
                for (int i2 = 0; i2 < this.additionalCountingStreams.length; ++i2) {
                    lArray[i2] = this.additionalCountingStreams[i2].getBytesWritten();
                }
                this.additionalSizes.put(sevenZArchiveEntry, lArray);
            }
        } else {
            sevenZArchiveEntry.setHasStream(false);
            sevenZArchiveEntry.setSize(0L);
            sevenZArchiveEntry.setCompressedSize(0L);
            sevenZArchiveEntry.setHasCrc(false);
        }
        this.currentOutputStream = null;
        this.additionalCountingStreams = null;
        this.crc32.reset();
        this.compressedCrc32.reset();
        this.fileBytesWritten = 0L;
    }

    public void write(int n2) throws IOException {
        this.getCurrentOutputStream().write(n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > 0) {
            this.getCurrentOutputStream().write(byArray, n2, n3);
        }
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        this.finished = true;
        long l2 = this.channel.position();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writeHeader(dataOutputStream);
        dataOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.channel.write(ByteBuffer.wrap(byArray));
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        ByteBuffer byteBuffer = ByteBuffer.allocate(SevenZFile.sevenZSignature.length + 2 + 4 + 8 + 8 + 4).order(ByteOrder.LITTLE_ENDIAN);
        this.channel.position(0L);
        byteBuffer.put(SevenZFile.sevenZSignature);
        byteBuffer.put((byte)0).put((byte)2);
        byteBuffer.putInt(0);
        byteBuffer.putLong(l2 - 32L).putLong(0xFFFFFFFFL & (long)byArray.length).putInt((int)cRC32.getValue());
        cRC32.reset();
        cRC32.update(byteBuffer.array(), SevenZFile.sevenZSignature.length + 6, 20);
        byteBuffer.putInt(SevenZFile.sevenZSignature.length + 2, (int)cRC32.getValue());
        byteBuffer.flip();
        this.channel.write(byteBuffer);
    }

    private OutputStream getCurrentOutputStream() throws IOException {
        if (this.currentOutputStream == null) {
            this.currentOutputStream = this.setupFileOutputStream();
        }
        return this.currentOutputStream;
    }

    private CountingOutputStream setupFileOutputStream() throws IOException {
        if (this.files.isEmpty()) {
            throw new IllegalStateException("No current 7z entry");
        }
        OutputStream outputStream = new OutputStreamWrapper();
        ArrayList<CountingOutputStream> arrayList = new ArrayList<CountingOutputStream>();
        boolean bl2 = true;
        for (SevenZMethodConfiguration sevenZMethodConfiguration : this.getContentMethods(this.files.get(this.files.size() - 1))) {
            if (!bl2) {
                CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
                arrayList.add(countingOutputStream);
                outputStream = countingOutputStream;
            }
            outputStream = Coders.addEncoder(outputStream, sevenZMethodConfiguration.getMethod(), sevenZMethodConfiguration.getOptions());
            bl2 = false;
        }
        if (!arrayList.isEmpty()) {
            this.additionalCountingStreams = arrayList.toArray(new CountingOutputStream[arrayList.size()]);
        }
        return new CountingOutputStream(outputStream){

            @Override
            public void write(int n2) throws IOException {
                super.write(n2);
                SevenZOutputFile.this.crc32.update(n2);
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                super.write(byArray);
                SevenZOutputFile.this.crc32.update(byArray);
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                super.write(byArray, n2, n3);
                SevenZOutputFile.this.crc32.update(byArray, n2, n3);
            }
        };
    }

    private Iterable<? extends SevenZMethodConfiguration> getContentMethods(SevenZArchiveEntry sevenZArchiveEntry) {
        Iterable<? extends SevenZMethodConfiguration> iterable = sevenZArchiveEntry.getContentMethods();
        return iterable == null ? this.contentMethods : iterable;
    }

    private void writeHeader(DataOutput dataOutput) throws IOException {
        dataOutput.write(1);
        dataOutput.write(4);
        this.writeStreamsInfo(dataOutput);
        this.writeFilesInfo(dataOutput);
        dataOutput.write(0);
    }

    private void writeStreamsInfo(DataOutput dataOutput) throws IOException {
        if (this.numNonEmptyStreams > 0) {
            this.writePackInfo(dataOutput);
            this.writeUnpackInfo(dataOutput);
        }
        this.writeSubStreamsInfo(dataOutput);
        dataOutput.write(0);
    }

    private void writePackInfo(DataOutput dataOutput) throws IOException {
        dataOutput.write(6);
        this.writeUint64(dataOutput, 0L);
        this.writeUint64(dataOutput, 0xFFFFFFFFL & (long)this.numNonEmptyStreams);
        dataOutput.write(9);
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            if (!sevenZArchiveEntry.hasStream()) continue;
            this.writeUint64(dataOutput, sevenZArchiveEntry.getCompressedSize());
        }
        dataOutput.write(10);
        dataOutput.write(1);
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            if (!sevenZArchiveEntry.hasStream()) continue;
            dataOutput.writeInt(Integer.reverseBytes((int)sevenZArchiveEntry.getCompressedCrcValue()));
        }
        dataOutput.write(0);
    }

    private void writeUnpackInfo(DataOutput dataOutput) throws IOException {
        dataOutput.write(7);
        dataOutput.write(11);
        this.writeUint64(dataOutput, this.numNonEmptyStreams);
        dataOutput.write(0);
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            if (!sevenZArchiveEntry.hasStream()) continue;
            this.writeFolder(dataOutput, sevenZArchiveEntry);
        }
        dataOutput.write(12);
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            if (!sevenZArchiveEntry.hasStream()) continue;
            long[] lArray = this.additionalSizes.get(sevenZArchiveEntry);
            if (lArray != null) {
                for (long l2 : lArray) {
                    this.writeUint64(dataOutput, l2);
                }
            }
            this.writeUint64(dataOutput, sevenZArchiveEntry.getSize());
        }
        dataOutput.write(10);
        dataOutput.write(1);
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            if (!sevenZArchiveEntry.hasStream()) continue;
            dataOutput.writeInt(Integer.reverseBytes((int)sevenZArchiveEntry.getCrcValue()));
        }
        dataOutput.write(0);
    }

    private void writeFolder(DataOutput dataOutput, SevenZArchiveEntry sevenZArchiveEntry) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        for (SevenZMethodConfiguration sevenZMethodConfiguration : this.getContentMethods(sevenZArchiveEntry)) {
            ++n2;
            this.writeSingleCodec(sevenZMethodConfiguration, byteArrayOutputStream);
        }
        this.writeUint64(dataOutput, n2);
        dataOutput.write(byteArrayOutputStream.toByteArray());
        for (long i2 = 0L; i2 < (long)(n2 - 1); ++i2) {
            this.writeUint64(dataOutput, i2 + 1L);
            this.writeUint64(dataOutput, i2);
        }
    }

    private void writeSingleCodec(SevenZMethodConfiguration sevenZMethodConfiguration, OutputStream outputStream) throws IOException {
        byte[] byArray = sevenZMethodConfiguration.getMethod().getId();
        byte[] byArray2 = Coders.findByMethod(sevenZMethodConfiguration.getMethod()).getOptionsAsProperties(sevenZMethodConfiguration.getOptions());
        int n2 = byArray.length;
        if (byArray2.length > 0) {
            n2 |= 0x20;
        }
        outputStream.write(n2);
        outputStream.write(byArray);
        if (byArray2.length > 0) {
            outputStream.write(byArray2.length);
            outputStream.write(byArray2);
        }
    }

    private void writeSubStreamsInfo(DataOutput dataOutput) throws IOException {
        dataOutput.write(8);
        dataOutput.write(0);
    }

    private void writeFilesInfo(DataOutput dataOutput) throws IOException {
        dataOutput.write(5);
        this.writeUint64(dataOutput, this.files.size());
        this.writeFileEmptyStreams(dataOutput);
        this.writeFileEmptyFiles(dataOutput);
        this.writeFileAntiItems(dataOutput);
        this.writeFileNames(dataOutput);
        this.writeFileCTimes(dataOutput);
        this.writeFileATimes(dataOutput);
        this.writeFileMTimes(dataOutput);
        this.writeFileWindowsAttributes(dataOutput);
        dataOutput.write(0);
    }

    private void writeFileEmptyStreams(DataOutput dataOutput) throws IOException {
        boolean bl2 = false;
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            if (sevenZArchiveEntry.hasStream()) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            dataOutput.write(14);
            BitSet bitSet = new BitSet(this.files.size());
            for (int i2 = 0; i2 < this.files.size(); ++i2) {
                bitSet.set(i2, !this.files.get(i2).hasStream());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeBits(dataOutputStream, bitSet, this.files.size());
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, byArray.length);
            dataOutput.write(byArray);
        }
    }

    private void writeFileEmptyFiles(DataOutput dataOutput) throws IOException {
        boolean bl2 = false;
        int n2 = 0;
        BitSet bitSet = new BitSet(0);
        for (SevenZArchiveEntry object : this.files) {
            if (object.hasStream()) continue;
            boolean byArray = object.isDirectory();
            bitSet.set(n2++, !byArray);
            bl2 |= !byArray;
        }
        if (bl2) {
            dataOutput.write(15);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeBits(dataOutputStream, bitSet, n2);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, byArray.length);
            dataOutput.write(byArray);
        }
    }

    private void writeFileAntiItems(DataOutput dataOutput) throws IOException {
        boolean bl2 = false;
        BitSet bitSet = new BitSet(0);
        int n2 = 0;
        for (SevenZArchiveEntry object : this.files) {
            if (object.hasStream()) continue;
            boolean byArray = object.isAntiItem();
            bitSet.set(n2++, byArray);
            bl2 |= byArray;
        }
        if (bl2) {
            dataOutput.write(16);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeBits(dataOutputStream, bitSet, n2);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, byArray.length);
            dataOutput.write(byArray);
        }
    }

    private void writeFileNames(DataOutput dataOutput) throws IOException {
        dataOutput.write(17);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(0);
        for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
            dataOutputStream.write(sevenZArchiveEntry.getName().getBytes("UTF-16LE"));
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.flush();
        Object object = byteArrayOutputStream.toByteArray();
        this.writeUint64(dataOutput, ((Object)object).length);
        dataOutput.write((byte[])object);
    }

    private void writeFileCTimes(DataOutput dataOutput) throws IOException {
        int n2 = 0;
        for (SevenZArchiveEntry object2 : this.files) {
            if (!object2.getHasCreationDate()) continue;
            ++n2;
        }
        if (n2 > 0) {
            Object object;
            dataOutput.write(18);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 != this.files.size()) {
                dataOutputStream.write(0);
                object = new BitSet(this.files.size());
                for (int sevenZArchiveEntry = 0; sevenZArchiveEntry < this.files.size(); ++sevenZArchiveEntry) {
                    ((BitSet)object).set(sevenZArchiveEntry, this.files.get(sevenZArchiveEntry).getHasCreationDate());
                }
                this.writeBits(dataOutputStream, (BitSet)object, this.files.size());
            } else {
                dataOutputStream.write(1);
            }
            dataOutputStream.write(0);
            for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
                if (!sevenZArchiveEntry.getHasCreationDate()) continue;
                dataOutputStream.writeLong(Long.reverseBytes(SevenZArchiveEntry.javaTimeToNtfsTime(sevenZArchiveEntry.getCreationDate())));
            }
            dataOutputStream.flush();
            object = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, ((Object)object).length);
            dataOutput.write((byte[])object);
        }
    }

    private void writeFileATimes(DataOutput dataOutput) throws IOException {
        int n2 = 0;
        for (SevenZArchiveEntry object2 : this.files) {
            if (!object2.getHasAccessDate()) continue;
            ++n2;
        }
        if (n2 > 0) {
            Object object;
            dataOutput.write(19);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 != this.files.size()) {
                dataOutputStream.write(0);
                object = new BitSet(this.files.size());
                for (int sevenZArchiveEntry = 0; sevenZArchiveEntry < this.files.size(); ++sevenZArchiveEntry) {
                    ((BitSet)object).set(sevenZArchiveEntry, this.files.get(sevenZArchiveEntry).getHasAccessDate());
                }
                this.writeBits(dataOutputStream, (BitSet)object, this.files.size());
            } else {
                dataOutputStream.write(1);
            }
            dataOutputStream.write(0);
            for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
                if (!sevenZArchiveEntry.getHasAccessDate()) continue;
                dataOutputStream.writeLong(Long.reverseBytes(SevenZArchiveEntry.javaTimeToNtfsTime(sevenZArchiveEntry.getAccessDate())));
            }
            dataOutputStream.flush();
            object = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, ((Object)object).length);
            dataOutput.write((byte[])object);
        }
    }

    private void writeFileMTimes(DataOutput dataOutput) throws IOException {
        int n2 = 0;
        for (SevenZArchiveEntry object2 : this.files) {
            if (!object2.getHasLastModifiedDate()) continue;
            ++n2;
        }
        if (n2 > 0) {
            Object object;
            dataOutput.write(20);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 != this.files.size()) {
                dataOutputStream.write(0);
                object = new BitSet(this.files.size());
                for (int sevenZArchiveEntry = 0; sevenZArchiveEntry < this.files.size(); ++sevenZArchiveEntry) {
                    ((BitSet)object).set(sevenZArchiveEntry, this.files.get(sevenZArchiveEntry).getHasLastModifiedDate());
                }
                this.writeBits(dataOutputStream, (BitSet)object, this.files.size());
            } else {
                dataOutputStream.write(1);
            }
            dataOutputStream.write(0);
            for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
                if (!sevenZArchiveEntry.getHasLastModifiedDate()) continue;
                dataOutputStream.writeLong(Long.reverseBytes(SevenZArchiveEntry.javaTimeToNtfsTime(sevenZArchiveEntry.getLastModifiedDate())));
            }
            dataOutputStream.flush();
            object = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, ((Object)object).length);
            dataOutput.write((byte[])object);
        }
    }

    private void writeFileWindowsAttributes(DataOutput dataOutput) throws IOException {
        int n2 = 0;
        for (SevenZArchiveEntry object2 : this.files) {
            if (!object2.getHasWindowsAttributes()) continue;
            ++n2;
        }
        if (n2 > 0) {
            Object object;
            dataOutput.write(21);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 != this.files.size()) {
                dataOutputStream.write(0);
                object = new BitSet(this.files.size());
                for (int sevenZArchiveEntry = 0; sevenZArchiveEntry < this.files.size(); ++sevenZArchiveEntry) {
                    ((BitSet)object).set(sevenZArchiveEntry, this.files.get(sevenZArchiveEntry).getHasWindowsAttributes());
                }
                this.writeBits(dataOutputStream, (BitSet)object, this.files.size());
            } else {
                dataOutputStream.write(1);
            }
            dataOutputStream.write(0);
            for (SevenZArchiveEntry sevenZArchiveEntry : this.files) {
                if (!sevenZArchiveEntry.getHasWindowsAttributes()) continue;
                dataOutputStream.writeInt(Integer.reverseBytes(sevenZArchiveEntry.getWindowsAttributes()));
            }
            dataOutputStream.flush();
            object = byteArrayOutputStream.toByteArray();
            this.writeUint64(dataOutput, ((Object)object).length);
            dataOutput.write((byte[])object);
        }
    }

    private void writeUint64(DataOutput dataOutput, long l2) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = 128;
        for (n2 = 0; n2 < 8; ++n2) {
            if (l2 < 1L << 7 * (n2 + 1)) {
                n3 = (int)((long)n3 | l2 >>> 8 * n2);
                break;
            }
            n3 |= n4;
            n4 >>>= 1;
        }
        dataOutput.write(n3);
        while (n2 > 0) {
            dataOutput.write((int)(0xFFL & l2));
            l2 >>>= 8;
            --n2;
        }
    }

    private void writeBits(DataOutput dataOutput, BitSet bitSet, int n2) throws IOException {
        int n3 = 0;
        int n4 = 7;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 |= (bitSet.get(i2) ? 1 : 0) << n4;
            if (--n4 >= 0) continue;
            dataOutput.write(n3);
            n4 = 7;
            n3 = 0;
        }
        if (n4 != 7) {
            dataOutput.write(n3);
        }
    }

    private static <T> Iterable<T> reverse(Iterable<T> iterable) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t2 : iterable) {
            linkedList.addFirst(t2);
        }
        return linkedList;
    }

    private class OutputStreamWrapper
    extends OutputStream {
        private static final int BUF_SIZE = 8192;
        private final ByteBuffer buffer = ByteBuffer.allocate(8192);

        private OutputStreamWrapper() {
        }

        @Override
        public void write(int n2) throws IOException {
            this.buffer.clear();
            this.buffer.put((byte)n2).flip();
            SevenZOutputFile.this.channel.write(this.buffer);
            SevenZOutputFile.this.compressedCrc32.update(n2);
            SevenZOutputFile.this.fileBytesWritten++;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 > 8192) {
                SevenZOutputFile.this.channel.write(ByteBuffer.wrap(byArray, n2, n3));
            } else {
                this.buffer.clear();
                this.buffer.put(byArray, n2, n3).flip();
                SevenZOutputFile.this.channel.write(this.buffer);
            }
            SevenZOutputFile.this.compressedCrc32.update(byArray, n2, n3);
            SevenZOutputFile.this.fileBytesWritten = SevenZOutputFile.this.fileBytesWritten + (long)n3;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

