/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarConstants;
import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.utils.ArchiveUtils;

public class TarArchiveEntry
implements ArchiveEntry,
TarConstants {
    private static final TarArchiveEntry[] EMPTY_TAR_ARCHIVE_ENTRIES = new TarArchiveEntry[0];
    private String name = "";
    private final boolean preserveAbsolutePath;
    private int mode;
    private long userId = 0L;
    private long groupId = 0L;
    private long size = 0L;
    private long modTime;
    private boolean checkSumOK;
    private byte linkFlag;
    private String linkName = "";
    private String magic = "ustar\u0000";
    private String version = "00";
    private String userName;
    private String groupName = "";
    private int devMajor = 0;
    private int devMinor = 0;
    private boolean isExtended;
    private long realSize;
    private boolean paxGNUSparse;
    private boolean starSparse;
    private final File file;
    private final Map<String, String> extraPaxHeaders = new HashMap<String, String>();
    public static final int MAX_NAMELEN = 31;
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int MILLIS_PER_SECOND = 1000;

    private TarArchiveEntry(boolean bl2) {
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userName = string;
        this.file = null;
        this.preserveAbsolutePath = bl2;
    }

    public TarArchiveEntry(String string) {
        this(string, false);
    }

    public TarArchiveEntry(String string, boolean bl2) {
        this(bl2);
        string = TarArchiveEntry.normalizeFileName(string, bl2);
        boolean bl3 = string.endsWith("/");
        this.name = string;
        this.mode = bl3 ? 16877 : 33188;
        this.linkFlag = (byte)(bl3 ? 53 : 48);
        this.modTime = new Date().getTime() / 1000L;
        this.userName = "";
    }

    public TarArchiveEntry(String string, byte by2) {
        this(string, by2, false);
    }

    public TarArchiveEntry(String string, byte by2, boolean bl2) {
        this(string, bl2);
        this.linkFlag = by2;
        if (by2 == 76) {
            this.magic = "ustar ";
            this.version = " \u0000";
        }
    }

    public TarArchiveEntry(File file) {
        this(file, file.getPath());
    }

    public TarArchiveEntry(File file, String string) {
        String string2 = TarArchiveEntry.normalizeFileName(string, false);
        this.file = file;
        if (file.isDirectory()) {
            this.mode = 16877;
            this.linkFlag = (byte)53;
            int n2 = string2.length();
            this.name = n2 == 0 || string2.charAt(n2 - 1) != '/' ? string2 + "/" : string2;
        } else {
            this.mode = 33188;
            this.linkFlag = (byte)48;
            this.size = file.length();
            this.name = string2;
        }
        this.modTime = file.lastModified() / 1000L;
        this.userName = "";
        this.preserveAbsolutePath = false;
    }

    public TarArchiveEntry(byte[] byArray) {
        this(false);
        this.parseTarHeader(byArray);
    }

    public TarArchiveEntry(byte[] byArray, ZipEncoding zipEncoding) throws IOException {
        this(false);
        this.parseTarHeader(byArray, zipEncoding);
    }

    public boolean equals(TarArchiveEntry tarArchiveEntry) {
        return tarArchiveEntry != null && this.getName().equals(tarArchiveEntry.getName());
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.equals((TarArchiveEntry)object);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isDescendent(TarArchiveEntry tarArchiveEntry) {
        return tarArchiveEntry.getName().startsWith(this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = TarArchiveEntry.normalizeFileName(string, this.preserveAbsolutePath);
    }

    public void setMode(int n2) {
        this.mode = n2;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String string) {
        this.linkName = string;
    }

    @Deprecated
    public int getUserId() {
        return (int)(this.userId & 0xFFFFFFFFFFFFFFFFL);
    }

    public void setUserId(int n2) {
        this.setUserId((long)n2);
    }

    public long getLongUserId() {
        return this.userId;
    }

    public void setUserId(long l2) {
        this.userId = l2;
    }

    @Deprecated
    public int getGroupId() {
        return (int)(this.groupId & 0xFFFFFFFFFFFFFFFFL);
    }

    public void setGroupId(int n2) {
        this.setGroupId((long)n2);
    }

    public long getLongGroupId() {
        return this.groupId;
    }

    public void setGroupId(long l2) {
        this.groupId = l2;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setIds(int n2, int n3) {
        this.setUserId(n2);
        this.setGroupId(n3);
    }

    public void setNames(String string, String string2) {
        this.setUserName(string);
        this.setGroupName(string2);
    }

    public void setModTime(long l2) {
        this.modTime = l2 / 1000L;
    }

    public void setModTime(Date date) {
        this.modTime = date.getTime() / 1000L;
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    @Override
    public Date getLastModifiedDate() {
        return this.getModTime();
    }

    public boolean isCheckSumOK() {
        return this.checkSumOK;
    }

    public File getFile() {
        return this.file;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Size is out of range: " + l2);
        }
        this.size = l2;
    }

    public int getDevMajor() {
        return this.devMajor;
    }

    public void setDevMajor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Major device number is out of range: " + n2);
        }
        this.devMajor = n2;
    }

    public int getDevMinor() {
        return this.devMinor;
    }

    public void setDevMinor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Minor device number is out of range: " + n2);
        }
        this.devMinor = n2;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public long getRealSize() {
        return this.realSize;
    }

    public boolean isGNUSparse() {
        return this.isOldGNUSparse() || this.isPaxGNUSparse();
    }

    public boolean isOldGNUSparse() {
        return this.linkFlag == 83;
    }

    public boolean isPaxGNUSparse() {
        return this.paxGNUSparse;
    }

    public boolean isStarSparse() {
        return this.starSparse;
    }

    public boolean isGNULongLinkEntry() {
        return this.linkFlag == 75;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76;
    }

    public boolean isPaxHeader() {
        return this.linkFlag == 120 || this.linkFlag == 88;
    }

    public boolean isGlobalPaxHeader() {
        return this.linkFlag == 103;
    }

    @Override
    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.linkFlag == 53) {
            return true;
        }
        return !this.isPaxHeader() && !this.isGlobalPaxHeader() && this.getName().endsWith("/");
    }

    public boolean isFile() {
        if (this.file != null) {
            return this.file.isFile();
        }
        if (this.linkFlag == 0 || this.linkFlag == 48) {
            return true;
        }
        return !this.getName().endsWith("/");
    }

    public boolean isSymbolicLink() {
        return this.linkFlag == 50;
    }

    public boolean isLink() {
        return this.linkFlag == 49;
    }

    public boolean isCharacterDevice() {
        return this.linkFlag == 51;
    }

    public boolean isBlockDevice() {
        return this.linkFlag == 52;
    }

    public boolean isFIFO() {
        return this.linkFlag == 54;
    }

    public boolean isSparse() {
        return this.isGNUSparse() || this.isStarSparse();
    }

    public Map<String, String> getExtraPaxHeaders() {
        return Collections.unmodifiableMap(this.extraPaxHeaders);
    }

    public void clearExtraPaxHeaders() {
        this.extraPaxHeaders.clear();
    }

    public void addPaxHeader(String string, String string2) {
        this.processPaxHeader(string, string2);
    }

    public String getExtraPaxHeader(String string) {
        return this.extraPaxHeaders.get(string);
    }

    void updateEntryFromPaxHeaders(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            this.processPaxHeader(string, string2, map);
        }
    }

    private void processPaxHeader(String string, String string2) {
        this.processPaxHeader(string, string2, this.extraPaxHeaders);
    }

    private void processPaxHeader(String string, String string2, Map<String, String> map) {
        switch (string) {
            case "path": {
                this.setName(string2);
                break;
            }
            case "linkpath": {
                this.setLinkName(string2);
                break;
            }
            case "gid": {
                this.setGroupId(Long.parseLong(string2));
                break;
            }
            case "gname": {
                this.setGroupName(string2);
                break;
            }
            case "uid": {
                this.setUserId(Long.parseLong(string2));
                break;
            }
            case "uname": {
                this.setUserName(string2);
                break;
            }
            case "size": {
                this.setSize(Long.parseLong(string2));
                break;
            }
            case "mtime": {
                this.setModTime((long)(Double.parseDouble(string2) * 1000.0));
                break;
            }
            case "SCHILY.devminor": {
                this.setDevMinor(Integer.parseInt(string2));
                break;
            }
            case "SCHILY.devmajor": {
                this.setDevMajor(Integer.parseInt(string2));
                break;
            }
            case "GNU.sparse.size": {
                this.fillGNUSparse0xData(map);
                break;
            }
            case "GNU.sparse.realsize": {
                this.fillGNUSparse1xData(map);
                break;
            }
            case "SCHILY.filetype": {
                if (!"sparse".equals(string2)) break;
                this.fillStarSparseData(map);
                break;
            }
            default: {
                this.extraPaxHeaders.put(string, string2);
            }
        }
    }

    public TarArchiveEntry[] getDirectoryEntries() {
        if (this.file == null || !this.file.isDirectory()) {
            return EMPTY_TAR_ARCHIVE_ENTRIES;
        }
        String[] stringArray = this.file.list();
        if (stringArray == null) {
            return EMPTY_TAR_ARCHIVE_ENTRIES;
        }
        TarArchiveEntry[] tarArchiveEntryArray = new TarArchiveEntry[stringArray.length];
        for (int i2 = 0; i2 < tarArchiveEntryArray.length; ++i2) {
            tarArchiveEntryArray[i2] = new TarArchiveEntry(new File(this.file, stringArray[i2]));
        }
        return tarArchiveEntryArray;
    }

    public void writeEntryHeader(byte[] byArray) {
        try {
            this.writeEntryHeader(byArray, TarUtils.DEFAULT_ENCODING, false);
        }
        catch (IOException iOException) {
            try {
                this.writeEntryHeader(byArray, TarUtils.FALLBACK_ENCODING, false);
            }
            catch (IOException iOException2) {
                throw new RuntimeException(iOException2);
            }
        }
    }

    public void writeEntryHeader(byte[] byArray, ZipEncoding zipEncoding, boolean bl2) throws IOException {
        int n2 = 0;
        n2 = TarUtils.formatNameBytes(this.name, byArray, n2, 100, zipEncoding);
        n2 = this.writeEntryHeaderField(this.mode, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.userId, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.groupId, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.size, byArray, n2, 12, bl2);
        int n3 = n2 = this.writeEntryHeaderField(this.modTime, byArray, n2, 12, bl2);
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[n2++] = 32;
        }
        byArray[n2++] = this.linkFlag;
        n2 = TarUtils.formatNameBytes(this.linkName, byArray, n2, 100, zipEncoding);
        n2 = TarUtils.formatNameBytes(this.magic, byArray, n2, 6);
        n2 = TarUtils.formatNameBytes(this.version, byArray, n2, 2);
        n2 = TarUtils.formatNameBytes(this.userName, byArray, n2, 32, zipEncoding);
        n2 = TarUtils.formatNameBytes(this.groupName, byArray, n2, 32, zipEncoding);
        n2 = this.writeEntryHeaderField(this.devMajor, byArray, n2, 8, bl2);
        n2 = this.writeEntryHeaderField(this.devMinor, byArray, n2, 8, bl2);
        while (n2 < byArray.length) {
            byArray[n2++] = 0;
        }
        long l2 = TarUtils.computeCheckSum(byArray);
        TarUtils.formatCheckSumOctalBytes(l2, byArray, n3, 8);
    }

    private int writeEntryHeaderField(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        if (!(bl2 || l2 >= 0L && l2 < 1L << 3 * (n3 - 1))) {
            return TarUtils.formatLongOctalBytes(0L, byArray, n2, n3);
        }
        return TarUtils.formatLongOctalOrBinaryBytes(l2, byArray, n2, n3);
    }

    public void parseTarHeader(byte[] byArray) {
        try {
            this.parseTarHeader(byArray, TarUtils.DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                this.parseTarHeader(byArray, TarUtils.DEFAULT_ENCODING, true);
            }
            catch (IOException iOException2) {
                throw new RuntimeException(iOException2);
            }
        }
    }

    public void parseTarHeader(byte[] byArray, ZipEncoding zipEncoding) throws IOException {
        this.parseTarHeader(byArray, zipEncoding, false);
    }

    private void parseTarHeader(byte[] byArray, ZipEncoding zipEncoding, boolean bl2) throws IOException {
        int n2 = 0;
        this.name = bl2 ? TarUtils.parseName(byArray, n2, 100) : TarUtils.parseName(byArray, n2, 100, zipEncoding);
        this.mode = (int)TarUtils.parseOctalOrBinary(byArray, n2 += 100, 8);
        this.userId = (int)TarUtils.parseOctalOrBinary(byArray, n2 += 8, 8);
        this.groupId = (int)TarUtils.parseOctalOrBinary(byArray, n2 += 8, 8);
        this.size = TarUtils.parseOctalOrBinary(byArray, n2 += 8, 12);
        this.modTime = TarUtils.parseOctalOrBinary(byArray, n2 += 12, 12);
        n2 += 12;
        this.checkSumOK = TarUtils.verifyCheckSum(byArray);
        n2 += 8;
        this.linkFlag = byArray[n2++];
        this.linkName = bl2 ? TarUtils.parseName(byArray, n2, 100) : TarUtils.parseName(byArray, n2, 100, zipEncoding);
        this.magic = TarUtils.parseName(byArray, n2 += 100, 6);
        this.version = TarUtils.parseName(byArray, n2 += 6, 2);
        this.userName = bl2 ? TarUtils.parseName(byArray, n2, 32) : TarUtils.parseName(byArray, n2 += 2, 32, zipEncoding);
        this.groupName = bl2 ? TarUtils.parseName(byArray, n2, 32) : TarUtils.parseName(byArray, n2 += 32, 32, zipEncoding);
        n2 += 32;
        if (this.linkFlag == 51 || this.linkFlag == 52) {
            this.devMajor = (int)TarUtils.parseOctalOrBinary(byArray, n2, 8);
            this.devMinor = (int)TarUtils.parseOctalOrBinary(byArray, n2 += 8, 8);
            n2 += 8;
        } else {
            n2 += 16;
        }
        int n3 = this.evaluateType(byArray);
        switch (n3) {
            case 2: {
                n2 += 12;
                n2 += 12;
                n2 += 12;
                n2 += 4;
                ++n2;
                this.isExtended = TarUtils.parseBoolean(byArray, n2 += 96);
                this.realSize = TarUtils.parseOctal(byArray, ++n2, 12);
                n2 += 12;
                break;
            }
            case 4: {
                String string;
                String string2 = string = bl2 ? TarUtils.parseName(byArray, n2, 131) : TarUtils.parseName(byArray, n2, 131, zipEncoding);
                if (string.length() <= 0) break;
                this.name = string + "/" + this.name;
                break;
            }
            default: {
                String string;
                String string3 = string = bl2 ? TarUtils.parseName(byArray, n2, 155) : TarUtils.parseName(byArray, n2, 155, zipEncoding);
                if (this.isDirectory() && !this.name.endsWith("/")) {
                    this.name = this.name + "/";
                }
                if (string.length() <= 0) break;
                this.name = string + "/" + this.name;
            }
        }
    }

    private static String normalizeFileName(String string, boolean bl2) {
        String string2;
        if (!bl2 && (string2 = System.getProperty("os.name").toLowerCase(Locale.ENGLISH)) != null) {
            int n2;
            if (string2.startsWith("windows")) {
                if (string.length() > 2) {
                    n2 = string.charAt(0);
                    char c2 = string.charAt(1);
                    if (c2 == ':' && (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90)) {
                        string = string.substring(2);
                    }
                }
            } else if (string2.contains("netware") && (n2 = string.indexOf(58)) != -1) {
                string = string.substring(n2 + 1);
            }
        }
        string = string.replace(File.separatorChar, '/');
        while (!bl2 && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private int evaluateType(byte[] byArray) {
        if (ArchiveUtils.matchAsciiBuffer("ustar ", byArray, 257, 6)) {
            return 2;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6)) {
            if (ArchiveUtils.matchAsciiBuffer("tar\u0000", byArray, 508, 4)) {
                return 4;
            }
            return 3;
        }
        return 0;
    }

    void fillGNUSparse0xData(Map<String, String> map) {
        this.paxGNUSparse = true;
        this.realSize = Integer.parseInt(map.get("GNU.sparse.size"));
        if (map.containsKey("GNU.sparse.name")) {
            this.name = map.get("GNU.sparse.name");
        }
    }

    void fillGNUSparse1xData(Map<String, String> map) {
        this.paxGNUSparse = true;
        this.realSize = Integer.parseInt(map.get("GNU.sparse.realsize"));
        this.name = map.get("GNU.sparse.name");
    }

    void fillStarSparseData(Map<String, String> map) {
        this.starSparse = true;
        if (map.containsKey("SCHILY.realsize")) {
            this.realSize = Long.parseLong(map.get("SCHILY.realsize"));
        }
    }
}

