/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

public class TarUtils {
    private static final int BYTE_MASK = 255;
    static final ZipEncoding DEFAULT_ENCODING = ZipEncodingHelper.getZipEncoding(null);
    static final ZipEncoding FALLBACK_ENCODING = new ZipEncoding(){

        @Override
        public boolean canEncode(String string) {
            return true;
        }

        @Override
        public ByteBuffer encode(String string) {
            int n2 = string.length();
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = (byte)string.charAt(i2);
            }
            return ByteBuffer.wrap(byArray);
        }

        @Override
        public String decode(byte[] byArray) {
            int n2 = byArray.length;
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (byte by2 : byArray) {
                if (by2 == 0) break;
                stringBuilder.append((char)(by2 & 0xFF));
            }
            return stringBuilder.toString();
        }
    };

    private TarUtils() {
    }

    public static long parseOctal(byte[] byArray, int n2, int n3) {
        int n4;
        long l2 = 0L;
        int n5 = n2 + n3;
        if (n3 < 2) {
            throw new IllegalArgumentException("Length " + n3 + " must be at least 2");
        }
        if (byArray[n4] == 0) {
            return 0L;
        }
        for (n4 = n2; n4 < n5 && byArray[n4] == 32; ++n4) {
        }
        byte by2 = byArray[n5 - 1];
        while (n4 < n5 && (by2 == 0 || by2 == 32)) {
            by2 = byArray[--n5 - 1];
        }
        while (n4 < n5) {
            byte by3 = byArray[n4];
            if (by3 < 48 || by3 > 55) {
                throw new IllegalArgumentException(TarUtils.exceptionMessage(byArray, n2, n3, n4, by3));
            }
            l2 = (l2 << 3) + (long)(by3 - 48);
            ++n4;
        }
        return l2;
    }

    public static long parseOctalOrBinary(byte[] byArray, int n2, int n3) {
        boolean bl2;
        if ((byArray[n2] & 0x80) == 0) {
            return TarUtils.parseOctal(byArray, n2, n3);
        }
        boolean bl3 = bl2 = byArray[n2] == -1;
        if (n3 < 9) {
            return TarUtils.parseBinaryLong(byArray, n2, n3, bl2);
        }
        return TarUtils.parseBinaryBigInteger(byArray, n2, n3, bl2);
    }

    private static long parseBinaryLong(byte[] byArray, int n2, int n3, boolean bl2) {
        if (n3 >= 9) {
            throw new IllegalArgumentException("At offset " + n2 + ", " + n3 + " byte binary number exceeds maximum signed long value");
        }
        long l2 = 0L;
        for (int i2 = 1; i2 < n3; ++i2) {
            l2 = (l2 << 8) + (long)(byArray[n2 + i2] & 0xFF);
        }
        if (bl2) {
            --l2;
            l2 ^= (long)Math.pow(2.0, (double)(n3 - 1) * 8.0) - 1L;
        }
        return bl2 ? -l2 : l2;
    }

    private static long parseBinaryBigInteger(byte[] byArray, int n2, int n3, boolean bl2) {
        byte[] byArray2 = new byte[n3 - 1];
        System.arraycopy(byArray, n2 + 1, byArray2, 0, n3 - 1);
        BigInteger bigInteger = new BigInteger(byArray2);
        if (bl2) {
            bigInteger = bigInteger.add(BigInteger.valueOf(-1L)).not();
        }
        if (bigInteger.bitLength() > 63) {
            throw new IllegalArgumentException("At offset " + n2 + ", " + n3 + " byte binary number exceeds maximum signed long value");
        }
        return bl2 ? -bigInteger.longValue() : bigInteger.longValue();
    }

    public static boolean parseBoolean(byte[] byArray, int n2) {
        return byArray[n2] == 1;
    }

    private static String exceptionMessage(byte[] byArray, int n2, int n3, int n4, byte by2) {
        String string = new String(byArray, n2, n3);
        string = string.replaceAll("\u0000", "{NUL}");
        return "Invalid byte " + by2 + " at offset " + (n4 - n2) + " in '" + string + "' len=" + n3;
    }

    public static String parseName(byte[] byArray, int n2, int n3) {
        try {
            return TarUtils.parseName(byArray, n2, n3, DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                return TarUtils.parseName(byArray, n2, n3, FALLBACK_ENCODING);
            }
            catch (IOException iOException2) {
                throw new RuntimeException(iOException2);
            }
        }
    }

    public static String parseName(byte[] byArray, int n2, int n3, ZipEncoding zipEncoding) throws IOException {
        int n4 = 0;
        int n5 = n2;
        while (n4 < n3 && byArray[n5] != 0) {
            ++n4;
            ++n5;
        }
        if (n4 > 0) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n2, byArray2, 0, n4);
            return zipEncoding.decode(byArray2);
        }
        return "";
    }

    public static int formatNameBytes(String string, byte[] byArray, int n2, int n3) {
        try {
            return TarUtils.formatNameBytes(string, byArray, n2, n3, DEFAULT_ENCODING);
        }
        catch (IOException iOException) {
            try {
                return TarUtils.formatNameBytes(string, byArray, n2, n3, FALLBACK_ENCODING);
            }
            catch (IOException iOException2) {
                throw new RuntimeException(iOException2);
            }
        }
    }

    public static int formatNameBytes(String string, byte[] byArray, int n2, int n3, ZipEncoding zipEncoding) throws IOException {
        int n4 = string.length();
        ByteBuffer byteBuffer = zipEncoding.encode(string);
        while (byteBuffer.limit() > n3 && n4 > 0) {
            byteBuffer = zipEncoding.encode(string.substring(0, --n4));
        }
        int n5 = byteBuffer.limit() - byteBuffer.position();
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray, n2, n5);
        for (int i2 = n5; i2 < n3; ++i2) {
            byArray[n2 + i2] = 0;
        }
        return n2 + n3;
    }

    public static void formatUnsignedOctalString(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3;
        --n4;
        if (l2 == 0L) {
            byArray[n2 + n4--] = 48;
        } else {
            long l3;
            for (l3 = l2; n4 >= 0 && l3 != 0L; l3 >>>= 3, --n4) {
                byArray[n2 + n4] = (byte)(48 + (byte)(l3 & 7L));
            }
            if (l3 != 0L) {
                throw new IllegalArgumentException(l2 + "=" + Long.toOctalString(l2) + " will not fit in octal number buffer of length " + n3);
            }
        }
        while (n4 >= 0) {
            byArray[n2 + n4] = 48;
            --n4;
        }
    }

    public static int formatOctalBytes(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 2;
        TarUtils.formatUnsignedOctalString(l2, byArray, n2, n4);
        byArray[n2 + n4++] = 32;
        byArray[n2 + n4] = 0;
        return n2 + n3;
    }

    public static int formatLongOctalBytes(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 1;
        TarUtils.formatUnsignedOctalString(l2, byArray, n2, n4);
        byArray[n2 + n4] = 32;
        return n2 + n3;
    }

    public static int formatLongOctalOrBinaryBytes(long l2, byte[] byArray, int n2, int n3) {
        boolean bl2;
        long l3 = n3 == 8 ? 0x1FFFFFL : 0x1FFFFFFFFL;
        boolean bl3 = bl2 = l2 < 0L;
        if (!bl2 && l2 <= l3) {
            return TarUtils.formatLongOctalBytes(l2, byArray, n2, n3);
        }
        if (n3 < 9) {
            TarUtils.formatLongBinary(l2, byArray, n2, n3, bl2);
        } else {
            TarUtils.formatBigIntegerBinary(l2, byArray, n2, n3, bl2);
        }
        byArray[n2] = (byte)(bl2 ? 255 : 128);
        return n2 + n3;
    }

    private static void formatLongBinary(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        int n4 = (n3 - 1) * 8;
        long l3 = 1L << n4;
        long l4 = Math.abs(l2);
        if (l4 < 0L || l4 >= l3) {
            throw new IllegalArgumentException("Value " + l2 + " is too large for " + n3 + " byte field.");
        }
        if (bl2) {
            l4 ^= l3 - 1L;
            ++l4;
            l4 |= 255L << n4;
        }
        for (int i2 = n2 + n3 - 1; i2 >= n2; --i2) {
            byArray[i2] = (byte)l4;
            l4 >>= 8;
        }
    }

    private static void formatBigIntegerBinary(long l2, byte[] byArray, int n2, int n3, boolean bl2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        byte[] byArray2 = bigInteger.toByteArray();
        int n4 = byArray2.length;
        if (n4 > n3 - 1) {
            throw new IllegalArgumentException("Value " + l2 + " is too large for " + n3 + " byte field.");
        }
        int n5 = n2 + n3 - n4;
        System.arraycopy(byArray2, 0, byArray, n5, n4);
        byte by2 = (byte)(bl2 ? 255 : 0);
        for (int i2 = n2 + 1; i2 < n5; ++i2) {
            byArray[i2] = by2;
        }
    }

    public static int formatCheckSumOctalBytes(long l2, byte[] byArray, int n2, int n3) {
        int n4 = n3 - 2;
        TarUtils.formatUnsignedOctalString(l2, byArray, n2, n4);
        byArray[n2 + n4++] = 0;
        byArray[n2 + n4] = 32;
        return n2 + n3;
    }

    public static long computeCheckSum(byte[] byArray) {
        long l2 = 0L;
        for (byte by2 : byArray) {
            l2 += (long)(0xFF & by2);
        }
        return l2;
    }

    public static boolean verifyCheckSum(byte[] byArray) {
        long l2 = TarUtils.parseOctal(byArray, 148, 8);
        long l3 = 0L;
        long l4 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2];
            if (148 <= i2 && i2 < 156) {
                n2 = 32;
            }
            l3 += (long)(0xFF & n2);
            l4 += (long)n2;
        }
        return l2 == l3 || l2 == l4;
    }
}

