/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BinaryTree;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.apache.commons.compress.archivers.zip.CircularBuffer;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.InputStreamStatistics;

class ExplodingInputStream
extends InputStream
implements InputStreamStatistics {
    private final InputStream in;
    private BitStream bits;
    private final int dictionarySize;
    private final int numberOfTrees;
    private final int minimumMatchLength;
    private BinaryTree literalTree;
    private BinaryTree lengthTree;
    private BinaryTree distanceTree;
    private final CircularBuffer buffer = new CircularBuffer(32768);
    private long uncompressedCount = 0L;
    private long treeSizes = 0L;

    public ExplodingInputStream(int n2, int n3, InputStream inputStream) {
        if (n2 != 4096 && n2 != 8192) {
            throw new IllegalArgumentException("The dictionary size must be 4096 or 8192");
        }
        if (n3 != 2 && n3 != 3) {
            throw new IllegalArgumentException("The number of trees must be 2 or 3");
        }
        this.dictionarySize = n2;
        this.numberOfTrees = n3;
        this.minimumMatchLength = n3;
        this.in = inputStream;
    }

    private void init() throws IOException {
        if (this.bits == null) {
            try (CountingInputStream countingInputStream = new CountingInputStream(this.in){

                @Override
                public void close() {
                }
            };){
                if (this.numberOfTrees == 3) {
                    this.literalTree = BinaryTree.decode(countingInputStream, 256);
                }
                this.lengthTree = BinaryTree.decode(countingInputStream, 64);
                this.distanceTree = BinaryTree.decode(countingInputStream, 64);
                this.treeSizes += countingInputStream.getBytesRead();
            }
            this.bits = new BitStream(this.in);
        }
    }

    @Override
    public int read() throws IOException {
        int n2;
        if (!this.buffer.available()) {
            this.fillBuffer();
        }
        if ((n2 = this.buffer.get()) > -1) {
            ++this.uncompressedCount;
        }
        return n2;
    }

    @Override
    public long getCompressedCount() {
        return this.bits.getBytesRead() + this.treeSizes;
    }

    @Override
    public long getUncompressedCount() {
        return this.uncompressedCount;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private void fillBuffer() throws IOException {
        this.init();
        int n2 = this.bits.nextBit();
        if (n2 == 1) {
            int n3 = this.literalTree != null ? this.literalTree.read(this.bits) : this.bits.nextByte();
            if (n3 == -1) {
                return;
            }
            this.buffer.put(n3);
        } else if (n2 == 0) {
            int n4 = this.dictionarySize == 4096 ? 6 : 7;
            int n5 = (int)this.bits.nextBits(n4);
            int n6 = this.distanceTree.read(this.bits);
            if (n6 == -1 && n5 <= 0) {
                return;
            }
            int n7 = n6 << n4 | n5;
            int n8 = this.lengthTree.read(this.bits);
            if (n8 == 63) {
                n8 = (int)((long)n8 + this.bits.nextBits(8));
            }
            this.buffer.copy(n7 + 1, n8 += this.minimumMatchLength);
        }
    }
}

