/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ResourceAlignmentExtraField
implements ZipExtraField {
    public static final ZipShort ID = new ZipShort(41246);
    public static final int BASE_SIZE = 2;
    private static final int ALLOW_METHOD_MESSAGE_CHANGE_FLAG = 32768;
    private short alignment;
    private boolean allowMethodChange;
    private int padding = 0;

    public ResourceAlignmentExtraField() {
    }

    public ResourceAlignmentExtraField(int n2) {
        this(n2, false);
    }

    public ResourceAlignmentExtraField(int n2, boolean bl2) {
        this(n2, bl2, 0);
    }

    public ResourceAlignmentExtraField(int n2, boolean bl2, int n3) {
        if (n2 < 0 || n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Alignment must be between 0 and 0x7fff, was: " + n2);
        }
        this.alignment = (short)n2;
        this.allowMethodChange = bl2;
        this.padding = n3;
    }

    public short getAlignment() {
        return this.alignment;
    }

    public boolean allowMethodChange() {
        return this.allowMethodChange;
    }

    @Override
    public ZipShort getHeaderId() {
        return ID;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(2 + this.padding);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return new ZipShort(2);
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] byArray = new byte[2 + this.padding];
        ZipShort.putShort(this.alignment | (this.allowMethodChange ? 32768 : 0), byArray, 0);
        return byArray;
    }

    @Override
    public byte[] getCentralDirectoryData() {
        return ZipShort.getBytes(this.alignment | (this.allowMethodChange ? 32768 : 0));
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n2, int n3) throws ZipException {
        this.parseFromCentralDirectoryData(byArray, n2, n3);
        this.padding = n3 - 2;
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n2, int n3) throws ZipException {
        if (n3 < 2) {
            throw new ZipException("Too short content for ResourceAlignmentExtraField (0xa11e): " + n3);
        }
        int n4 = ZipShort.getValue(byArray, n2);
        this.alignment = (short)(n4 & Short.MAX_VALUE);
        this.allowMethodChange = (n4 & 0x8000) != 0;
    }
}

