/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import org.apache.commons.compress.compressors.lzw.LZWInputStream;

class UnshrinkingInputStream
extends LZWInputStream {
    private static final int MAX_CODE_SIZE = 13;
    private static final int MAX_TABLE_SIZE = 8192;
    private final boolean[] isUsed;

    public UnshrinkingInputStream(InputStream inputStream) throws IOException {
        super(inputStream, ByteOrder.LITTLE_ENDIAN);
        this.setClearCode(9);
        this.initializeTables(13);
        this.isUsed = new boolean[this.getPrefixesLength()];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.isUsed[i2] = true;
        }
        this.setTableSize(this.getClearCode() + 1);
    }

    @Override
    protected int addEntry(int n2, byte by2) throws IOException {
        int n3;
        for (n3 = this.getTableSize(); n3 < 8192 && this.isUsed[n3]; ++n3) {
        }
        this.setTableSize(n3);
        int n4 = this.addEntry(n2, by2, 8192);
        if (n4 >= 0) {
            this.isUsed[n4] = true;
        }
        return n4;
    }

    private void partialClear() {
        int n2;
        boolean[] blArray = new boolean[8192];
        for (n2 = 0; n2 < this.isUsed.length; ++n2) {
            if (!this.isUsed[n2] || this.getPrefix(n2) == -1) continue;
            blArray[this.getPrefix((int)n2)] = true;
        }
        for (n2 = this.getClearCode() + 1; n2 < blArray.length; ++n2) {
            if (blArray[n2]) continue;
            this.isUsed[n2] = false;
            this.setPrefix(n2, -1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int decompressNextSymbol() throws IOException {
        int n2 = this.readNextCode();
        if (n2 < 0) {
            return -1;
        }
        if (n2 == this.getClearCode()) {
            int n3 = this.readNextCode();
            if (n3 < 0) {
                throw new IOException("Unexpected EOF;");
            }
            if (n3 == 1) {
                if (this.getCodeSize() >= 13) throw new IOException("Attempt to increase code size beyond maximum");
                this.incrementCodeSize();
                return 0;
            } else {
                if (n3 != 2) throw new IOException("Invalid clear code subcode " + n3);
                this.partialClear();
                this.setTableSize(this.getClearCode() + 1);
            }
            return 0;
        }
        boolean bl2 = false;
        int n4 = n2;
        if (this.isUsed[n2]) return this.expandCodeToOutputStack(n4, bl2);
        n4 = this.addRepeatOfPreviousCode();
        bl2 = true;
        return this.expandCodeToOutputStack(n4, bl2);
    }
}

