/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.PKWareExtraHeader;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class X0017_StrongEncryptionHeader
extends PKWareExtraHeader {
    private int format;
    private PKWareExtraHeader.EncryptionAlgorithm algId;
    private int bitlen;
    private int flags;
    private long rcount;
    private PKWareExtraHeader.HashAlgorithm hashAlg;
    private int hashSize;
    private byte[] ivData;
    private byte[] erdData;
    private byte[] recipientKeyHash;
    private byte[] keyBlob;
    private byte[] vData;
    private byte[] vCRC32;

    public X0017_StrongEncryptionHeader() {
        super(new ZipShort(23));
    }

    public long getRecordCount() {
        return this.rcount;
    }

    public PKWareExtraHeader.HashAlgorithm getHashAlgorithm() {
        return this.hashAlg;
    }

    public PKWareExtraHeader.EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.algId;
    }

    public void parseCentralDirectoryFormat(byte[] byArray, int n2, int n3) {
        this.format = ZipShort.getValue(byArray, n2);
        this.algId = PKWareExtraHeader.EncryptionAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n2 + 2));
        this.bitlen = ZipShort.getValue(byArray, n2 + 4);
        this.flags = ZipShort.getValue(byArray, n2 + 6);
        this.rcount = ZipLong.getValue(byArray, n2 + 8);
        if (this.rcount > 0L) {
            this.hashAlg = PKWareExtraHeader.HashAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n2 + 12));
            this.hashSize = ZipShort.getValue(byArray, n2 + 14);
            for (long i2 = 0L; i2 < this.rcount; ++i2) {
                for (int i3 = 0; i3 < this.hashSize; ++i3) {
                }
            }
        }
    }

    public void parseFileFormat(byte[] byArray, int n2, int n3) {
        int n4 = ZipShort.getValue(byArray, n2);
        this.ivData = new byte[n4];
        System.arraycopy(byArray, n2 + 4, this.ivData, 0, n4);
        this.format = ZipShort.getValue(byArray, n2 + n4 + 6);
        this.algId = PKWareExtraHeader.EncryptionAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n2 + n4 + 8));
        this.bitlen = ZipShort.getValue(byArray, n2 + n4 + 10);
        this.flags = ZipShort.getValue(byArray, n2 + n4 + 12);
        int n5 = ZipShort.getValue(byArray, n2 + n4 + 14);
        this.erdData = new byte[n5];
        System.arraycopy(byArray, n2 + n4 + 16, this.erdData, 0, n5);
        this.rcount = ZipLong.getValue(byArray, n2 + n4 + 16 + n5);
        System.out.println("rcount: " + this.rcount);
        if (this.rcount == 0L) {
            int n6 = ZipShort.getValue(byArray, n2 + n4 + 20 + n5);
            this.vData = new byte[n6 - 4];
            this.vCRC32 = new byte[4];
            System.arraycopy(byArray, n2 + n4 + 22 + n5, this.vData, 0, n6 - 4);
            System.arraycopy(byArray, n2 + n4 + 22 + n5 + n6 - 4, this.vCRC32, 0, 4);
        } else {
            this.hashAlg = PKWareExtraHeader.HashAlgorithm.getAlgorithmByCode(ZipShort.getValue(byArray, n2 + n4 + 20 + n5));
            this.hashSize = ZipShort.getValue(byArray, n2 + n4 + 22 + n5);
            int n7 = ZipShort.getValue(byArray, n2 + n4 + 24 + n5);
            this.recipientKeyHash = new byte[this.hashSize];
            this.keyBlob = new byte[n7 - this.hashSize];
            System.arraycopy(byArray, n2 + n4 + 24 + n5, this.recipientKeyHash, 0, this.hashSize);
            System.arraycopy(byArray, n2 + n4 + 24 + n5 + this.hashSize, this.keyBlob, 0, n7 - this.hashSize);
            int n8 = ZipShort.getValue(byArray, n2 + n4 + 26 + n5 + n7);
            this.vData = new byte[n8 - 4];
            this.vCRC32 = new byte[4];
            System.arraycopy(byArray, n2 + n4 + 22 + n5 + n7, this.vData, 0, n8 - 4);
            System.arraycopy(byArray, n2 + n4 + 22 + n5 + n7 + n8 - 4, this.vCRC32, 0, 4);
        }
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n2, int n3) {
        super.parseFromLocalFileData(byArray, n2, n3);
        this.parseFileFormat(byArray, n2, n3);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n2, int n3) {
        super.parseFromCentralDirectoryData(byArray, n2, n3);
        this.parseCentralDirectoryFormat(byArray, n2, n3);
    }
}

