/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.EntryStreamOffsets;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtils;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ZipArchiveEntry
extends ZipEntry
implements ArchiveEntry,
EntryStreamOffsets {
    public static final int PLATFORM_UNIX = 3;
    public static final int PLATFORM_FAT = 0;
    public static final int CRC_UNKNOWN = -1;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private static final byte[] EMPTY = new byte[0];
    private int method = -1;
    private long size = -1L;
    private int internalAttributes = 0;
    private int versionRequired;
    private int versionMadeBy;
    private int platform = 0;
    private int rawFlag;
    private long externalAttributes = 0L;
    private int alignment = 0;
    private ZipExtraField[] extraFields;
    private UnparseableExtraFieldData unparseableExtra = null;
    private String name = null;
    private byte[] rawName = null;
    private GeneralPurposeBit gpb = new GeneralPurposeBit();
    private static final ZipExtraField[] noExtraFields = new ZipExtraField[0];
    private long localHeaderOffset = -1L;
    private long dataOffset = -1L;
    private boolean isStreamContiguous = false;
    private NameSource nameSource = NameSource.NAME;
    private CommentSource commentSource = CommentSource.COMMENT;

    public ZipArchiveEntry(String string) {
        super(string);
        this.setName(string);
    }

    public ZipArchiveEntry(ZipEntry zipEntry) throws ZipException {
        super(zipEntry);
        this.setName(zipEntry.getName());
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray, true, ExtraFieldUtils.UnparseableExtraField.READ));
        } else {
            this.setExtra();
        }
        this.setMethod(zipEntry.getMethod());
        this.size = zipEntry.getSize();
    }

    public ZipArchiveEntry(ZipArchiveEntry zipArchiveEntry) throws ZipException {
        this((ZipEntry)zipArchiveEntry);
        this.setInternalAttributes(zipArchiveEntry.getInternalAttributes());
        this.setExternalAttributes(zipArchiveEntry.getExternalAttributes());
        this.setExtraFields(this.getAllExtraFieldsNoCopy());
        this.setPlatform(zipArchiveEntry.getPlatform());
        GeneralPurposeBit generalPurposeBit = zipArchiveEntry.getGeneralPurposeBit();
        this.setGeneralPurposeBit(generalPurposeBit == null ? null : (GeneralPurposeBit)generalPurposeBit.clone());
    }

    protected ZipArchiveEntry() {
        this("");
    }

    public ZipArchiveEntry(File file, String string) {
        this(file.isDirectory() && !string.endsWith("/") ? string + "/" : string);
        if (file.isFile()) {
            this.setSize(file.length());
        }
        this.setTime(file.lastModified());
    }

    @Override
    public Object clone() {
        ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)super.clone();
        zipArchiveEntry.setInternalAttributes(this.getInternalAttributes());
        zipArchiveEntry.setExternalAttributes(this.getExternalAttributes());
        zipArchiveEntry.setExtraFields(this.getAllExtraFieldsNoCopy());
        return zipArchiveEntry;
    }

    @Override
    public int getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("ZIP compression method can not be negative: " + n2);
        }
        this.method = n2;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int n2) {
        this.internalAttributes = n2;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long l2) {
        this.externalAttributes = l2;
    }

    public void setUnixMode(int n2) {
        this.setExternalAttributes(n2 << 16 | ((n2 & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public boolean isUnixSymlink() {
        return (this.getUnixMode() & 0xF000) == 40960;
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int n2) {
        this.platform = n2;
    }

    protected int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        if ((n2 & n2 - 1) != 0 || n2 > 65535) {
            throw new IllegalArgumentException("Invalid value for alignment, must be power of two and no bigger than 65535 but is " + n2);
        }
        this.alignment = n2;
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            if (zipExtraField instanceof UnparseableExtraFieldData) {
                this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
                continue;
            }
            arrayList.add(zipExtraField);
        }
        this.extraFields = arrayList.toArray(new ZipExtraField[arrayList.size()]);
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        return this.getParseableExtraFields();
    }

    public ZipExtraField[] getExtraFields(boolean bl2) {
        return bl2 ? this.getAllExtraFields() : this.getParseableExtraFields();
    }

    private ZipExtraField[] getParseableExtraFieldsNoCopy() {
        if (this.extraFields == null) {
            return noExtraFields;
        }
        return this.extraFields;
    }

    private ZipExtraField[] getParseableExtraFields() {
        ZipExtraField[] zipExtraFieldArray = this.getParseableExtraFieldsNoCopy();
        return zipExtraFieldArray == this.extraFields ? this.copyOf(zipExtraFieldArray) : zipExtraFieldArray;
    }

    private ZipExtraField[] getAllExtraFieldsNoCopy() {
        if (this.extraFields == null) {
            return this.getUnparseableOnly();
        }
        return this.unparseableExtra != null ? this.getMergedFields() : this.extraFields;
    }

    private ZipExtraField[] copyOf(ZipExtraField[] zipExtraFieldArray) {
        return this.copyOf(zipExtraFieldArray, zipExtraFieldArray.length);
    }

    private ZipExtraField[] copyOf(ZipExtraField[] zipExtraFieldArray, int n2) {
        ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[n2];
        System.arraycopy(zipExtraFieldArray, 0, zipExtraFieldArray2, 0, Math.min(zipExtraFieldArray.length, n2));
        return zipExtraFieldArray2;
    }

    private ZipExtraField[] getMergedFields() {
        ZipExtraField[] zipExtraFieldArray = this.copyOf(this.extraFields, this.extraFields.length + 1);
        zipExtraFieldArray[this.extraFields.length] = this.unparseableExtra;
        return zipExtraFieldArray;
    }

    private ZipExtraField[] getUnparseableOnly() {
        ZipExtraField[] zipExtraFieldArray;
        if (this.unparseableExtra == null) {
            zipExtraFieldArray = noExtraFields;
        } else {
            ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[1];
            zipExtraFieldArray = zipExtraFieldArray2;
            zipExtraFieldArray2[0] = this.unparseableExtra;
        }
        return zipExtraFieldArray;
    }

    private ZipExtraField[] getAllExtraFields() {
        ZipExtraField[] zipExtraFieldArray = this.getAllExtraFieldsNoCopy();
        return zipExtraFieldArray == this.extraFields ? this.copyOf(zipExtraFieldArray) : zipExtraFieldArray;
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        if (zipExtraField instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
        } else if (this.extraFields == null) {
            this.extraFields = new ZipExtraField[]{zipExtraField};
        } else {
            if (this.getExtraField(zipExtraField.getHeaderId()) != null) {
                this.removeExtraField(zipExtraField.getHeaderId());
            }
            ZipExtraField[] zipExtraFieldArray = this.copyOf(this.extraFields, this.extraFields.length + 1);
            zipExtraFieldArray[zipExtraFieldArray.length - 1] = zipExtraField;
            this.extraFields = zipExtraFieldArray;
        }
        this.setExtra();
    }

    public void addAsFirstExtraField(ZipExtraField zipExtraField) {
        if (zipExtraField instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)zipExtraField;
        } else {
            if (this.getExtraField(zipExtraField.getHeaderId()) != null) {
                this.removeExtraField(zipExtraField.getHeaderId());
            }
            ZipExtraField[] zipExtraFieldArray = this.extraFields;
            int n2 = this.extraFields != null ? this.extraFields.length + 1 : 1;
            this.extraFields = new ZipExtraField[n2];
            this.extraFields[0] = zipExtraField;
            if (zipExtraFieldArray != null) {
                System.arraycopy(zipExtraFieldArray, 0, this.extraFields, 1, this.extraFields.length - 1);
            }
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort zipShort) {
        if (this.extraFields == null) {
            throw new NoSuchElementException();
        }
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        for (ZipExtraField zipExtraField : this.extraFields) {
            if (zipShort.equals(zipExtraField.getHeaderId())) continue;
            arrayList.add(zipExtraField);
        }
        if (this.extraFields.length == arrayList.size()) {
            throw new NoSuchElementException();
        }
        this.extraFields = arrayList.toArray(new ZipExtraField[arrayList.size()]);
        this.setExtra();
    }

    public void removeUnparseableExtraFieldData() {
        if (this.unparseableExtra == null) {
            throw new NoSuchElementException();
        }
        this.unparseableExtra = null;
        this.setExtra();
    }

    public ZipExtraField getExtraField(ZipShort zipShort) {
        if (this.extraFields != null) {
            for (ZipExtraField zipExtraField : this.extraFields) {
                if (!zipShort.equals(zipExtraField.getHeaderId())) continue;
                return zipExtraField;
            }
        }
        return null;
    }

    public UnparseableExtraFieldData getUnparseableExtraFieldData() {
        return this.unparseableExtra;
    }

    @Override
    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            ZipExtraField[] zipExtraFieldArray = ExtraFieldUtils.parse(byArray, true, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(zipExtraFieldArray, true);
        }
        catch (ZipException zipException) {
            throw new RuntimeException("Error parsing extra fields for entry: " + this.getName() + " - " + zipException.getMessage(), zipException);
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getAllExtraFieldsNoCopy()));
    }

    public void setCentralDirectoryExtra(byte[] byArray) {
        try {
            ZipExtraField[] zipExtraFieldArray = ExtraFieldUtils.parse(byArray, false, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(zipExtraFieldArray, false);
        }
        catch (ZipException zipException) {
            throw new RuntimeException(zipException.getMessage(), zipException);
        }
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : EMPTY;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getAllExtraFieldsNoCopy());
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String string) {
        if (string != null && this.getPlatform() == 0 && !string.contains("/")) {
            string = string.replace('\\', '/');
        }
        this.name = string;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid entry size");
        }
        this.size = l2;
    }

    protected void setName(String string, byte[] byArray) {
        this.setName(string);
        this.rawName = byArray;
    }

    public byte[] getRawName() {
        if (this.rawName != null) {
            byte[] byArray = new byte[this.rawName.length];
            System.arraycopy(this.rawName, 0, byArray, 0, this.rawName.length);
            return byArray;
        }
        return null;
    }

    protected long getLocalHeaderOffset() {
        return this.localHeaderOffset;
    }

    protected void setLocalHeaderOffset(long l2) {
        this.localHeaderOffset = l2;
    }

    @Override
    public long getDataOffset() {
        return this.dataOffset;
    }

    protected void setDataOffset(long l2) {
        this.dataOffset = l2;
    }

    @Override
    public boolean isStreamContiguous() {
        return this.isStreamContiguous;
    }

    protected void setStreamContiguous(boolean bl2) {
        this.isStreamContiguous = bl2;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public GeneralPurposeBit getGeneralPurposeBit() {
        return this.gpb;
    }

    public void setGeneralPurposeBit(GeneralPurposeBit generalPurposeBit) {
        this.gpb = generalPurposeBit;
    }

    private void mergeExtraFields(ZipExtraField[] zipExtraFieldArray, boolean bl2) throws ZipException {
        if (this.extraFields == null) {
            this.setExtraFields(zipExtraFieldArray);
        } else {
            for (ZipExtraField zipExtraField : zipExtraFieldArray) {
                byte[] byArray;
                ZipExtraField zipExtraField2 = zipExtraField instanceof UnparseableExtraFieldData ? this.unparseableExtra : this.getExtraField(zipExtraField.getHeaderId());
                if (zipExtraField2 == null) {
                    this.addExtraField(zipExtraField);
                    continue;
                }
                if (bl2) {
                    byArray = zipExtraField.getLocalFileDataData();
                    zipExtraField2.parseFromLocalFileData(byArray, 0, byArray.length);
                    continue;
                }
                byArray = zipExtraField.getCentralDirectoryData();
                zipExtraField2.parseFromCentralDirectoryData(byArray, 0, byArray.length);
            }
            this.setExtra();
        }
    }

    @Override
    public Date getLastModifiedDate() {
        return new Date(this.getTime());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)object;
        String string = this.getName();
        String string2 = zipArchiveEntry.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getComment();
        String string4 = zipArchiveEntry.getComment();
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        return this.getTime() == zipArchiveEntry.getTime() && string3.equals(string4) && this.getInternalAttributes() == zipArchiveEntry.getInternalAttributes() && this.getPlatform() == zipArchiveEntry.getPlatform() && this.getExternalAttributes() == zipArchiveEntry.getExternalAttributes() && this.getMethod() == zipArchiveEntry.getMethod() && this.getSize() == zipArchiveEntry.getSize() && this.getCrc() == zipArchiveEntry.getCrc() && this.getCompressedSize() == zipArchiveEntry.getCompressedSize() && Arrays.equals(this.getCentralDirectoryExtra(), zipArchiveEntry.getCentralDirectoryExtra()) && Arrays.equals(this.getLocalFileDataExtra(), zipArchiveEntry.getLocalFileDataExtra()) && this.localHeaderOffset == zipArchiveEntry.localHeaderOffset && this.dataOffset == zipArchiveEntry.dataOffset && this.gpb.equals(zipArchiveEntry.gpb);
    }

    public void setVersionMadeBy(int n2) {
        this.versionMadeBy = n2;
    }

    public void setVersionRequired(int n2) {
        this.versionRequired = n2;
    }

    public int getVersionRequired() {
        return this.versionRequired;
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public int getRawFlag() {
        return this.rawFlag;
    }

    public void setRawFlag(int n2) {
        this.rawFlag = n2;
    }

    public NameSource getNameSource() {
        return this.nameSource;
    }

    public void setNameSource(NameSource nameSource) {
        this.nameSource = nameSource;
    }

    public CommentSource getCommentSource() {
        return this.commentSource;
    }

    public void setCommentSource(CommentSource commentSource) {
        this.commentSource = commentSource;
    }

    public static enum CommentSource {
        COMMENT,
        UNICODE_EXTRA_FIELD;

    }

    public static enum NameSource {
        NAME,
        NAME_WITH_EFS_FLAG,
        UNICODE_EXTRA_FIELD;

    }
}

