/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class ZipArchiveInputStream
extends ArchiveInputStream
implements InputStreamStatistics {
    private final ZipEncoding zipEncoding;
    final String encoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final ByteBuffer buf = ByteBuffer.allocate(512);
    private CurrentEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private long uncompressedCount = 0L;
    private static final int LFH_LEN = 30;
    private static final int CFH_LEN = 46;
    private static final long TWO_EXP_32 = 0x100000000L;
    private final byte[] lfhBuf = new byte[30];
    private final byte[] skipBuf = new byte[1024];
    private final byte[] shortBuf = new byte[2];
    private final byte[] wordBuf = new byte[4];
    private final byte[] twoDwordBuf = new byte[16];
    private int entriesRead = 0;
    private static final byte[] LFH = ZipLong.LFH_SIG.getBytes();
    private static final byte[] CFH = ZipLong.CFH_SIG.getBytes();
    private static final byte[] DD = ZipLong.DD_SIG.getBytes();
    private static final byte[] APK_SIGNING_BLOCK_MAGIC = new byte[]{65, 80, 75, 32, 83, 105, 103, 32, 66, 108, 111, 99, 107, 32, 52, 50};
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8");
    }

    public ZipArchiveInputStream(InputStream inputStream, String string) {
        this(inputStream, string, true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl2) {
        this(inputStream, string, bl2, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl2, boolean bl3) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUnicodeExtraFields = bl2;
        this.in = new PushbackInputStream(inputStream, this.buf.capacity());
        this.allowStoredEntriesWithDataDescriptor = bl3;
        this.buf.limit(0);
    }

    public ZipArchiveEntry getNextZipEntry() throws IOException {
        this.uncompressedCount = 0L;
        boolean bl2 = true;
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
            bl2 = false;
        }
        long l2 = this.getBytesRead();
        try {
            if (bl2) {
                this.readFirstLocalFileHeader(this.lfhBuf);
            } else {
                this.readFully(this.lfhBuf);
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        ZipLong zipLong = new ZipLong(this.lfhBuf);
        if (!zipLong.equals(ZipLong.LFH_SIG)) {
            if (zipLong.equals(ZipLong.CFH_SIG) || zipLong.equals(ZipLong.AED_SIG) || this.isApkSigningBlock(this.lfhBuf)) {
                this.hitCentralDirectory = true;
                this.skipRemainderOfArchive();
                return null;
            }
            throw new ZipException(String.format("Unexpected record signature: 0X%X", zipLong.getValue()));
        }
        int n2 = 4;
        this.current = new CurrentEntry();
        int n3 = ZipShort.getValue(this.lfhBuf, n2);
        this.current.entry.setPlatform(n3 >> 8 & 0xF);
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.lfhBuf, n2 += 2);
        boolean bl3 = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding = bl3 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        this.current.hasDataDescriptor = generalPurposeBit.usesDataDescriptor();
        this.current.entry.setGeneralPurposeBit(generalPurposeBit);
        this.current.entry.setMethod(ZipShort.getValue(this.lfhBuf, n2 += 2));
        long l3 = ZipUtil.dosToJavaTime(ZipLong.getValue(this.lfhBuf, n2 += 2));
        this.current.entry.setTime(l3);
        n2 += 4;
        ZipLong zipLong2 = null;
        ZipLong zipLong3 = null;
        if (!this.current.hasDataDescriptor) {
            this.current.entry.setCrc(ZipLong.getValue(this.lfhBuf, n2));
            zipLong3 = new ZipLong(this.lfhBuf, n2 += 4);
            zipLong2 = new ZipLong(this.lfhBuf, n2 += 4);
            n2 += 4;
        } else {
            n2 += 12;
        }
        int n4 = ZipShort.getValue(this.lfhBuf, n2);
        int n5 = ZipShort.getValue(this.lfhBuf, n2 += 2);
        n2 += 2;
        byte[] byArray = new byte[n4];
        this.readFully(byArray);
        this.current.entry.setName(zipEncoding.decode(byArray), byArray);
        if (bl3) {
            this.current.entry.setNameSource(ZipArchiveEntry.NameSource.NAME_WITH_EFS_FLAG);
        }
        byte[] byArray2 = new byte[n5];
        this.readFully(byArray2);
        this.current.entry.setExtra(byArray2);
        if (!bl3 && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(this.current.entry, byArray, null);
        }
        this.processZip64Extra(zipLong2, zipLong3);
        this.current.entry.setLocalHeaderOffset(l2);
        this.current.entry.setDataOffset(this.getBytesRead());
        this.current.entry.setStreamContiguous(true);
        ZipMethod zipMethod = ZipMethod.getMethodByCode(this.current.entry.getMethod());
        if (this.current.entry.getCompressedSize() != -1L) {
            if (ZipUtil.canHandleEntryData(this.current.entry) && zipMethod != ZipMethod.STORED && zipMethod != ZipMethod.DEFLATED) {
                BoundedInputStream boundedInputStream = new BoundedInputStream(this.in, this.current.entry.getCompressedSize());
                switch (zipMethod) {
                    case UNSHRINKING: {
                        this.current.in = new UnshrinkingInputStream(boundedInputStream);
                        break;
                    }
                    case IMPLODING: {
                        this.current.in = new ExplodingInputStream(this.current.entry.getGeneralPurposeBit().getSlidingDictionarySize(), this.current.entry.getGeneralPurposeBit().getNumberOfShannonFanoTrees(), boundedInputStream);
                        break;
                    }
                    case BZIP2: {
                        this.current.in = new BZip2CompressorInputStream(boundedInputStream);
                        break;
                    }
                    case ENHANCED_DEFLATED: {
                        this.current.in = new Deflate64CompressorInputStream(boundedInputStream);
                        break;
                    }
                }
            }
        } else if (zipMethod == ZipMethod.ENHANCED_DEFLATED) {
            this.current.in = new Deflate64CompressorInputStream(this.in);
        }
        ++this.entriesRead;
        return this.current.entry;
    }

    private void readFirstLocalFileHeader(byte[] byArray) throws IOException {
        this.readFully(byArray);
        ZipLong zipLong = new ZipLong(byArray);
        if (zipLong.equals(ZipLong.DD_SIG)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.SPLITTING);
        }
        if (zipLong.equals(ZipLong.SINGLE_SEGMENT_SPLIT_MARKER)) {
            byte[] byArray2 = new byte[4];
            this.readFully(byArray2);
            System.arraycopy(byArray, 4, byArray, 0, 26);
            System.arraycopy(byArray2, 0, byArray, 26, 4);
        }
    }

    private void processZip64Extra(ZipLong zipLong, ZipLong zipLong2) {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)this.current.entry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        this.current.usesZip64 = zip64ExtendedInformationExtraField != null;
        if (!this.current.hasDataDescriptor) {
            if (zip64ExtendedInformationExtraField != null && (zipLong2.equals(ZipLong.ZIP64_MAGIC) || zipLong.equals(ZipLong.ZIP64_MAGIC))) {
                this.current.entry.setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
                this.current.entry.setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else {
                this.current.entry.setCompressedSize(zipLong2.getValue());
                this.current.entry.setSize(zipLong.getValue());
            }
        }
    }

    @Override
    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextZipEntry();
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return ZipUtil.canHandleEntryData(zipArchiveEntry) && this.supportsDataDescriptorFor(zipArchiveEntry) && this.supportsCompressedSizeFor(zipArchiveEntry);
        }
        return false;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return -1;
        }
        if (n2 > byArray.length || n3 < 0 || n2 < 0 || byArray.length - n2 < n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZipUtil.checkRequestedFeatures(this.current.entry);
        if (!this.supportsDataDescriptorFor(this.current.entry)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR, this.current.entry);
        }
        if (!this.supportsCompressedSizeFor(this.current.entry)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.UNKNOWN_COMPRESSED_SIZE, this.current.entry);
        }
        if (this.current.entry.getMethod() == 0) {
            n4 = this.readStored(byArray, n2, n3);
        } else if (this.current.entry.getMethod() == 8) {
            n4 = this.readDeflated(byArray, n2, n3);
        } else if (this.current.entry.getMethod() == ZipMethod.UNSHRINKING.getCode() || this.current.entry.getMethod() == ZipMethod.IMPLODING.getCode() || this.current.entry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode() || this.current.entry.getMethod() == ZipMethod.BZIP2.getCode()) {
            n4 = this.current.in.read(byArray, n2, n3);
        } else {
            throw new UnsupportedZipFeatureException(ZipMethod.getMethodByCode(this.current.entry.getMethod()), this.current.entry);
        }
        if (n4 >= 0) {
            this.current.crc.update(byArray, n2, n4);
            this.uncompressedCount += (long)n4;
        }
        return n4;
    }

    @Override
    public long getCompressedCount() {
        if (this.current.entry.getMethod() == 0) {
            return this.current.bytesRead;
        }
        if (this.current.entry.getMethod() == 8) {
            return this.getBytesInflated();
        }
        if (this.current.entry.getMethod() == ZipMethod.UNSHRINKING.getCode()) {
            return ((UnshrinkingInputStream)this.current.in).getCompressedCount();
        }
        if (this.current.entry.getMethod() == ZipMethod.IMPLODING.getCode()) {
            return ((ExplodingInputStream)this.current.in).getCompressedCount();
        }
        if (this.current.entry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode()) {
            return ((Deflate64CompressorInputStream)this.current.in).getCompressedCount();
        }
        if (this.current.entry.getMethod() == ZipMethod.BZIP2.getCode()) {
            return ((BZip2CompressorInputStream)this.current.in).getCompressedCount();
        }
        return -1L;
    }

    @Override
    public long getUncompressedCount() {
        return this.uncompressedCount;
    }

    private int readStored(byte[] byArray, int n2, int n3) throws IOException {
        CurrentEntry currentEntry;
        int n4;
        if (this.current.hasDataDescriptor) {
            if (this.lastStoredEntry == null) {
                this.readStoredEntry();
            }
            return this.lastStoredEntry.read(byArray, n2, n3);
        }
        long l2 = this.current.entry.getSize();
        if (this.current.bytesRead >= l2) {
            return -1;
        }
        if (this.buf.position() >= this.buf.limit()) {
            this.buf.position(0);
            n4 = this.in.read(this.buf.array());
            if (n4 == -1) {
                this.buf.limit(0);
                throw new IOException("Truncated ZIP file");
            }
            this.buf.limit(n4);
            this.count(n4);
            currentEntry = this.current;
            currentEntry.bytesReadFromStream = currentEntry.bytesReadFromStream + (long)n4;
        }
        n4 = Math.min(this.buf.remaining(), n3);
        if (l2 - this.current.bytesRead < (long)n4) {
            n4 = (int)(l2 - this.current.bytesRead);
        }
        this.buf.get(byArray, n2, n4);
        currentEntry = this.current;
        currentEntry.bytesRead = currentEntry.bytesRead + (long)n4;
        return n4;
    }

    private int readDeflated(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.readFromInflater(byArray, n2, n3);
        if (n4 <= 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (this.inf.needsDictionary()) {
                throw new ZipException("This archive needs a preset dictionary which is not supported by Commons Compress.");
            }
            if (n4 == -1) {
                throw new IOException("Truncated ZIP file");
            }
        }
        return n4;
    }

    private int readFromInflater(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        do {
            if (this.inf.needsInput()) {
                int n5 = this.fill();
                if (n5 > 0) {
                    CurrentEntry currentEntry = this.current;
                    currentEntry.bytesReadFromStream = currentEntry.bytesReadFromStream + (long)this.buf.limit();
                } else {
                    if (n5 != -1) break;
                    return -1;
                }
            }
            try {
                n4 = this.inf.inflate(byArray, n2, n3);
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new ZipException(dataFormatException.getMessage()).initCause(dataFormatException);
            }
        } while (n4 == 0 && this.inf.needsInput());
        return n4;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.in.close();
            }
            finally {
                this.inf.end();
            }
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        if (l2 >= 0L) {
            long l3;
            int n2;
            for (l3 = 0L; l3 < l2; l3 += (long)n2) {
                long l4 = l2 - l3;
                n2 = this.read(this.skipBuf, 0, (int)((long)this.skipBuf.length > l4 ? l4 : (long)this.skipBuf.length));
                if (n2 != -1) continue;
                return l3;
            }
            return l3;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.EOCD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.DD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipLong.SINGLE_SEGMENT_SPLIT_MARKER.getBytes());
    }

    private static boolean checksig(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (this.currentEntryHasOutstandingBytes()) {
            this.drainCurrentEntryData();
        } else {
            this.skip(Long.MAX_VALUE);
            long l2 = this.current.entry.getMethod() == 8 ? this.getBytesInflated() : this.current.bytesRead;
            int n2 = (int)(this.current.bytesReadFromStream - l2);
            if (n2 > 0) {
                this.pushback(this.buf.array(), this.buf.limit() - n2, n2);
                CurrentEntry currentEntry = this.current;
                currentEntry.bytesReadFromStream = currentEntry.bytesReadFromStream - (long)n2;
            }
            if (this.currentEntryHasOutstandingBytes()) {
                this.drainCurrentEntryData();
            }
        }
        if (this.lastStoredEntry == null && this.current.hasDataDescriptor) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        this.buf.clear().flip();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private boolean currentEntryHasOutstandingBytes() {
        return this.current.bytesReadFromStream <= this.current.entry.getCompressedSize() && !this.current.hasDataDescriptor;
    }

    private void drainCurrentEntryData() throws IOException {
        long l2;
        for (long i2 = this.current.entry.getCompressedSize() - this.current.bytesReadFromStream; i2 > 0L; i2 -= l2) {
            l2 = this.in.read(this.buf.array(), 0, (int)Math.min((long)this.buf.capacity(), i2));
            if (l2 < 0L) {
                throw new EOFException("Truncated ZIP entry: " + ArchiveUtils.sanitize(this.current.entry.getName()));
            }
            this.count(l2);
        }
    }

    private long getBytesInflated() {
        long l2 = this.inf.getBytesRead();
        if (this.current.bytesReadFromStream >= 0x100000000L) {
            while (l2 + 0x100000000L <= this.current.bytesReadFromStream) {
                l2 += 0x100000000L;
            }
        }
        return l2;
    }

    private int fill() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        int n2 = this.in.read(this.buf.array());
        if (n2 > 0) {
            this.buf.limit(n2);
            this.count(this.buf.limit());
            this.inf.setInput(this.buf.array(), 0, this.buf.limit());
        }
        return n2;
    }

    private void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0);
    }

    private void readFully(byte[] byArray, int n2) throws IOException {
        int n3 = byArray.length - n2;
        int n4 = IOUtils.readFully(this.in, byArray, n2, n3);
        this.count(n4);
        if (n4 < n3) {
            throw new EOFException();
        }
    }

    private void readDataDescriptor() throws IOException {
        this.readFully(this.wordBuf);
        ZipLong zipLong = new ZipLong(this.wordBuf);
        if (ZipLong.DD_SIG.equals(zipLong)) {
            this.readFully(this.wordBuf);
            zipLong = new ZipLong(this.wordBuf);
        }
        this.current.entry.setCrc(zipLong.getValue());
        this.readFully(this.twoDwordBuf);
        ZipLong zipLong2 = new ZipLong(this.twoDwordBuf, 8);
        if (zipLong2.equals(ZipLong.CFH_SIG) || zipLong2.equals(ZipLong.LFH_SIG)) {
            this.pushback(this.twoDwordBuf, 8, 8);
            this.current.entry.setCompressedSize(ZipLong.getValue(this.twoDwordBuf));
            this.current.entry.setSize(ZipLong.getValue(this.twoDwordBuf, 4));
        } else {
            this.current.entry.setCompressedSize(ZipEightByteInteger.getLongValue(this.twoDwordBuf));
            this.current.entry.setSize(ZipEightByteInteger.getLongValue(this.twoDwordBuf, 8));
        }
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry zipArchiveEntry) {
        return !zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor() || this.allowStoredEntriesWithDataDescriptor && zipArchiveEntry.getMethod() == 0 || zipArchiveEntry.getMethod() == 8 || zipArchiveEntry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode();
    }

    private boolean supportsCompressedSizeFor(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getCompressedSize() != -1L || zipArchiveEntry.getMethod() == 8 || zipArchiveEntry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode() || zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor() && this.allowStoredEntriesWithDataDescriptor && zipArchiveEntry.getMethod() == 0;
    }

    private void readStoredEntry() throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        boolean bl2 = false;
        int n4 = n2 = this.current.usesZip64 ? 20 : 12;
        while (!bl2) {
            int n5 = this.in.read(this.buf.array(), n3, 512 - n3);
            if (n5 <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (n5 + n3 < 4) {
                n3 += n5;
                continue;
            }
            bl2 = this.bufferContainsSignature(byteArrayOutputStream, n3, n5, n2);
            if (bl2) continue;
            n3 = this.cacheBytesRead(byteArrayOutputStream, n3, n5, n2);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(byArray);
    }

    private boolean bufferContainsSignature(ByteArrayOutputStream byteArrayOutputStream, int n2, int n3, int n4) throws IOException {
        boolean bl2 = false;
        int n5 = 0;
        for (int i2 = 0; !bl2 && i2 < n2 + n3 - 4; ++i2) {
            if (this.buf.array()[i2] != LFH[0] || this.buf.array()[i2 + 1] != LFH[1]) continue;
            if (this.buf.array()[i2 + 2] == LFH[2] && this.buf.array()[i2 + 3] == LFH[3] || this.buf.array()[i2] == CFH[2] && this.buf.array()[i2 + 3] == CFH[3]) {
                n5 = n2 + n3 - i2 - n4;
                bl2 = true;
            } else if (this.buf.array()[i2 + 2] == DD[2] && this.buf.array()[i2 + 3] == DD[3]) {
                n5 = n2 + n3 - i2;
                bl2 = true;
            }
            if (!bl2) continue;
            this.pushback(this.buf.array(), n2 + n3 - n5, n5);
            byteArrayOutputStream.write(this.buf.array(), 0, i2);
            this.readDataDescriptor();
        }
        return bl2;
    }

    private int cacheBytesRead(ByteArrayOutputStream byteArrayOutputStream, int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4 - 3;
        if (n5 > 0) {
            byteArrayOutputStream.write(this.buf.array(), 0, n5);
            System.arraycopy(this.buf.array(), n5, this.buf.array(), 0, n4 + 3);
            n2 = n4 + 3;
        } else {
            n2 += n3;
        }
        return n2;
    }

    private void pushback(byte[] byArray, int n2, int n3) throws IOException {
        ((PushbackInputStream)this.in).unread(byArray, n2, n3);
        this.pushedBackBytes(n3);
    }

    private void skipRemainderOfArchive() throws IOException {
        this.realSkip((long)this.entriesRead * 46L - 30L);
        this.findEocdRecord();
        this.realSkip(16L);
        this.readFully(this.shortBuf);
        this.realSkip(ZipShort.getValue(this.shortBuf));
    }

    private void findEocdRecord() throws IOException {
        int n2 = -1;
        boolean bl2 = false;
        while (bl2 || (n2 = this.readOneByte()) > -1) {
            bl2 = false;
            if (!this.isFirstByteOfEocdSig(n2)) continue;
            n2 = this.readOneByte();
            if (n2 != ZipArchiveOutputStream.EOCD_SIG[1]) {
                if (n2 == -1) break;
                bl2 = this.isFirstByteOfEocdSig(n2);
                continue;
            }
            n2 = this.readOneByte();
            if (n2 != ZipArchiveOutputStream.EOCD_SIG[2]) {
                if (n2 == -1) break;
                bl2 = this.isFirstByteOfEocdSig(n2);
                continue;
            }
            n2 = this.readOneByte();
            if (n2 == -1 || n2 == ZipArchiveOutputStream.EOCD_SIG[3]) break;
            bl2 = this.isFirstByteOfEocdSig(n2);
        }
    }

    private void realSkip(long l2) throws IOException {
        if (l2 >= 0L) {
            int n2;
            for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                long l3 = l2 - i2;
                n2 = this.in.read(this.skipBuf, 0, (int)((long)this.skipBuf.length > l3 ? l3 : (long)this.skipBuf.length));
                if (n2 == -1) {
                    return;
                }
                this.count(n2);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private int readOneByte() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.count(1);
        }
        return n2;
    }

    private boolean isFirstByteOfEocdSig(int n2) {
        return n2 == ZipArchiveOutputStream.EOCD_SIG[0];
    }

    private boolean isApkSigningBlock(byte[] byArray) throws IOException {
        BigInteger bigInteger = ZipEightByteInteger.getValue(byArray);
        BigInteger bigInteger2 = bigInteger.add(BigInteger.valueOf(8 - byArray.length - APK_SIGNING_BLOCK_MAGIC.length));
        byte[] byArray2 = new byte[APK_SIGNING_BLOCK_MAGIC.length];
        try {
            if (bigInteger2.signum() < 0) {
                int n2 = byArray.length + bigInteger2.intValue();
                if (n2 < 8) {
                    return false;
                }
                int n3 = Math.abs(bigInteger2.intValue());
                System.arraycopy(byArray, n2, byArray2, 0, Math.min(n3, byArray2.length));
                if (n3 < byArray2.length) {
                    this.readFully(byArray2, n3);
                }
            } else {
                while (bigInteger2.compareTo(LONG_MAX) > 0) {
                    this.realSkip(Long.MAX_VALUE);
                    bigInteger2 = bigInteger2.add(LONG_MAX.negate());
                }
                this.realSkip(bigInteger2.longValue());
                this.readFully(byArray2);
            }
        }
        catch (EOFException eOFException) {
            return false;
        }
        return Arrays.equals(byArray2, APK_SIGNING_BLOCK_MAGIC);
    }

    private class BoundedInputStream
    extends InputStream {
        private final InputStream in;
        private final long max;
        private long pos = 0L;

        public BoundedInputStream(InputStream inputStream, long l2) {
            this.max = l2;
            this.in = inputStream;
        }

        @Override
        public int read() throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return -1;
            }
            int n2 = this.in.read();
            ++this.pos;
            ZipArchiveInputStream.this.count(1);
            ZipArchiveInputStream.this.current.bytesReadFromStream++;
            return n2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return -1;
            }
            long l2 = this.max >= 0L ? Math.min((long)n3, this.max - this.pos) : (long)n3;
            int n4 = this.in.read(byArray, n2, (int)l2);
            if (n4 == -1) {
                return -1;
            }
            this.pos += (long)n4;
            ZipArchiveInputStream.this.count(n4);
            CurrentEntry currentEntry = ZipArchiveInputStream.this.current;
            currentEntry.bytesReadFromStream = currentEntry.bytesReadFromStream + (long)n4;
            return n4;
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3 = this.max >= 0L ? Math.min(l2, this.max - this.pos) : l2;
            long l4 = IOUtils.skip(this.in, l3);
            this.pos += l4;
            return l4;
        }

        @Override
        public int available() throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return 0;
            }
            return this.in.available();
        }
    }

    private static final class CurrentEntry {
        private final ZipArchiveEntry entry = new ZipArchiveEntry();
        private boolean hasDataDescriptor;
        private boolean usesZip64;
        private long bytesRead;
        private long bytesReadFromStream;
        private final CRC32 crc = new CRC32();
        private InputStream in;

        private CurrentEntry() {
        }
    }
}

