/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.ResourceAlignmentExtraField;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.Zip64RequiredException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.utils.IOUtils;

public class ZipArchiveOutputStream
extends ArchiveOutputStream {
    static final int BUFFER_SIZE = 512;
    private static final int LFH_SIG_OFFSET = 0;
    private static final int LFH_VERSION_NEEDED_OFFSET = 4;
    private static final int LFH_GPB_OFFSET = 6;
    private static final int LFH_METHOD_OFFSET = 8;
    private static final int LFH_TIME_OFFSET = 10;
    private static final int LFH_CRC_OFFSET = 14;
    private static final int LFH_COMPRESSED_SIZE_OFFSET = 18;
    private static final int LFH_ORIGINAL_SIZE_OFFSET = 22;
    private static final int LFH_FILENAME_LENGTH_OFFSET = 26;
    private static final int LFH_EXTRA_LENGTH_OFFSET = 28;
    private static final int LFH_FILENAME_OFFSET = 30;
    private static final int CFH_SIG_OFFSET = 0;
    private static final int CFH_VERSION_MADE_BY_OFFSET = 4;
    private static final int CFH_VERSION_NEEDED_OFFSET = 6;
    private static final int CFH_GPB_OFFSET = 8;
    private static final int CFH_METHOD_OFFSET = 10;
    private static final int CFH_TIME_OFFSET = 12;
    private static final int CFH_CRC_OFFSET = 16;
    private static final int CFH_COMPRESSED_SIZE_OFFSET = 20;
    private static final int CFH_ORIGINAL_SIZE_OFFSET = 24;
    private static final int CFH_FILENAME_LENGTH_OFFSET = 28;
    private static final int CFH_EXTRA_LENGTH_OFFSET = 30;
    private static final int CFH_COMMENT_LENGTH_OFFSET = 32;
    private static final int CFH_DISK_NUMBER_OFFSET = 34;
    private static final int CFH_INTERNAL_ATTRIBUTES_OFFSET = 36;
    private static final int CFH_EXTERNAL_ATTRIBUTES_OFFSET = 38;
    private static final int CFH_LFH_OFFSET = 42;
    private static final int CFH_FILENAME_OFFSET = 46;
    protected boolean finished = false;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = "UTF8";
    @Deprecated
    public static final int EFS_FLAG = 2048;
    private static final byte[] EMPTY = new byte[0];
    private CurrentEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List<ZipArchiveEntry> entries = new LinkedList<ZipArchiveEntry>();
    private final StreamCompressor streamCompressor;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private static final byte[] ONE = ZipLong.getBytes(1L);
    private final Map<ZipArchiveEntry, EntryMetaData> metaData = new HashMap<ZipArchiveEntry, EntryMetaData>();
    private String encoding = "UTF8";
    private ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding("UTF8");
    protected final Deflater def;
    private final SeekableByteChannel channel;
    private final OutputStream out;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private UnicodeExtraFieldPolicy createUnicodeExtraFields = UnicodeExtraFieldPolicy.NEVER;
    private boolean hasUsedZip64 = false;
    private Zip64Mode zip64Mode = Zip64Mode.AsNeeded;
    private final byte[] copyBuffer = new byte[32768];
    private final Calendar calendarInstance = Calendar.getInstance();
    static final byte[] LFH_SIG = ZipLong.LFH_SIG.getBytes();
    static final byte[] DD_SIG = ZipLong.DD_SIG.getBytes();
    static final byte[] CFH_SIG = ZipLong.CFH_SIG.getBytes();
    static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);

    public ZipArchiveOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.channel = null;
        this.def = new Deflater(this.level, true);
        this.streamCompressor = StreamCompressor.create(outputStream, this.def);
    }

    public ZipArchiveOutputStream(File file) throws IOException {
        this.def = new Deflater(this.level, true);
        FileOutputStream fileOutputStream = null;
        SeekableByteChannel seekableByteChannel = null;
        StreamCompressor streamCompressor = null;
        try {
            seekableByteChannel = Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
            streamCompressor = StreamCompressor.create(seekableByteChannel, this.def);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(seekableByteChannel);
            seekableByteChannel = null;
            fileOutputStream = new FileOutputStream(file);
            streamCompressor = StreamCompressor.create(fileOutputStream, this.def);
        }
        this.out = fileOutputStream;
        this.channel = seekableByteChannel;
        this.streamCompressor = streamCompressor;
    }

    public ZipArchiveOutputStream(SeekableByteChannel seekableByteChannel) throws IOException {
        this.channel = seekableByteChannel;
        this.def = new Deflater(this.level, true);
        this.streamCompressor = StreamCompressor.create(seekableByteChannel, this.def);
        this.out = null;
    }

    public boolean isSeekable() {
        return this.channel != null;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        if (this.useUTF8Flag && !ZipEncodingHelper.isUTF8(string)) {
            this.useUTF8Flag = false;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean bl2) {
        this.useUTF8Flag = bl2 && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraFieldPolicy unicodeExtraFieldPolicy) {
        this.createUnicodeExtraFields = unicodeExtraFieldPolicy;
    }

    public void setFallbackToUTF8(boolean bl2) {
        this.fallbackToUTF8 = bl2;
    }

    public void setUseZip64(Zip64Mode zip64Mode) {
        this.zip64Mode = zip64Mode;
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.cdOffset = this.streamCompressor.getTotalBytesWritten();
        this.writeCentralDirectoryInChunks();
        this.cdLength = this.streamCompressor.getTotalBytesWritten() - this.cdOffset;
        this.writeZip64CentralDirectory();
        this.writeCentralDirectoryEnd();
        this.metaData.clear();
        this.entries.clear();
        this.streamCompressor.close();
        this.finished = true;
    }

    private void writeCentralDirectoryInChunks() throws IOException {
        int n2 = 1000;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(70000);
        int n3 = 0;
        for (ZipArchiveEntry zipArchiveEntry : this.entries) {
            byteArrayOutputStream.write(this.createCentralFileHeader(zipArchiveEntry));
            if (++n3 <= 1000) continue;
            this.writeCounted(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
            n3 = 0;
        }
        this.writeCounted(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        this.preClose();
        this.flushDeflater();
        long l2 = this.streamCompressor.getTotalBytesWritten() - this.entry.dataStart;
        long l3 = this.streamCompressor.getCrc32();
        this.entry.bytesRead = this.streamCompressor.getBytesRead();
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        boolean bl2 = this.handleSizesAndCrc(l2, l3, zip64Mode);
        this.closeEntry(bl2, false);
        this.streamCompressor.reset();
    }

    private void closeCopiedEntry(boolean bl2) throws IOException {
        this.preClose();
        this.entry.bytesRead = this.entry.entry.getSize();
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        boolean bl3 = this.checkIfNeedsZip64(zip64Mode);
        this.closeEntry(bl3, bl2);
    }

    private void closeEntry(boolean bl2, boolean bl3) throws IOException {
        if (!bl3 && this.channel != null) {
            this.rewriteSizesAndCrc(bl2);
        }
        if (!bl3) {
            this.writeDataDescriptor(this.entry.entry);
        }
        this.entry = null;
    }

    private void preClose() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry == null) {
            throw new IOException("No current entry to close");
        }
        if (!this.entry.hasWritten) {
            this.write(EMPTY, 0, 0);
        }
    }

    public void addRawArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStream inputStream) throws IOException {
        ZipArchiveEntry zipArchiveEntry2 = new ZipArchiveEntry(zipArchiveEntry);
        if (this.hasZip64Extra(zipArchiveEntry2)) {
            zipArchiveEntry2.removeExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        }
        boolean bl2 = zipArchiveEntry2.getCrc() != -1L && zipArchiveEntry2.getSize() != -1L && zipArchiveEntry2.getCompressedSize() != -1L;
        this.putArchiveEntry(zipArchiveEntry2, bl2);
        this.copyFromZipInputStream(inputStream);
        this.closeCopiedEntry(bl2);
    }

    private void flushDeflater() throws IOException {
        if (this.entry.entry.getMethod() == 8) {
            this.streamCompressor.flushDeflater();
        }
    }

    private boolean handleSizesAndCrc(long l2, long l3, Zip64Mode zip64Mode) throws ZipException {
        if (this.entry.entry.getMethod() == 8) {
            this.entry.entry.setSize(this.entry.bytesRead);
            this.entry.entry.setCompressedSize(l2);
            this.entry.entry.setCrc(l3);
        } else if (this.channel == null) {
            if (this.entry.entry.getCrc() != l3) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.entry.getName() + ": " + Long.toHexString(this.entry.entry.getCrc()) + " instead of " + Long.toHexString(l3));
            }
            if (this.entry.entry.getSize() != l2) {
                throw new ZipException("bad size for entry " + this.entry.entry.getName() + ": " + this.entry.entry.getSize() + " instead of " + l2);
            }
        } else {
            this.entry.entry.setSize(l2);
            this.entry.entry.setCompressedSize(l2);
            this.entry.entry.setCrc(l3);
        }
        return this.checkIfNeedsZip64(zip64Mode);
    }

    private boolean checkIfNeedsZip64(Zip64Mode zip64Mode) throws ZipException {
        boolean bl2 = this.isZip64Required(this.entry.entry, zip64Mode);
        if (bl2 && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(this.entry.entry));
        }
        return bl2;
    }

    private boolean isZip64Required(ZipArchiveEntry zipArchiveEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || this.isTooLageForZip32(zipArchiveEntry);
    }

    private boolean isTooLageForZip32(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getSize() >= 0xFFFFFFFFL || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL;
    }

    private void rewriteSizesAndCrc(boolean bl2) throws IOException {
        long l2 = this.channel.position();
        this.channel.position(this.entry.localDataStart);
        this.writeOut(ZipLong.getBytes(this.entry.entry.getCrc()));
        if (!this.hasZip64Extra(this.entry.entry) || !bl2) {
            this.writeOut(ZipLong.getBytes(this.entry.entry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(this.entry.entry.getSize()));
        } else {
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
        }
        if (this.hasZip64Extra(this.entry.entry)) {
            ByteBuffer byteBuffer = this.getName(this.entry.entry);
            int n2 = byteBuffer.limit() - byteBuffer.position();
            this.channel.position(this.entry.localDataStart + 12L + 4L + (long)n2 + 4L);
            this.writeOut(ZipEightByteInteger.getBytes(this.entry.entry.getSize()));
            this.writeOut(ZipEightByteInteger.getBytes(this.entry.entry.getCompressedSize()));
            if (!bl2) {
                this.channel.position(this.entry.localDataStart - 10L);
                this.writeOut(ZipShort.getBytes(this.versionNeededToExtract(this.entry.entry.getMethod(), false, false)));
                this.entry.entry.removeExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
                this.entry.entry.setExtra();
                if (this.entry.causedUseOfZip64) {
                    this.hasUsedZip64 = false;
                }
            }
        }
        this.channel.position(l2);
    }

    @Override
    public void putArchiveEntry(ArchiveEntry archiveEntry) throws IOException {
        this.putArchiveEntry(archiveEntry, false);
    }

    private void putArchiveEntry(ArchiveEntry archiveEntry, boolean bl2) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry != null) {
            this.closeArchiveEntry();
        }
        this.entry = new CurrentEntry((ZipArchiveEntry)archiveEntry);
        this.entries.add(this.entry.entry);
        this.setDefaults(this.entry.entry);
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        this.validateSizeInformation(zip64Mode);
        if (this.shouldAddZip64Extra(this.entry.entry, zip64Mode)) {
            ZipEightByteInteger zipEightByteInteger;
            ZipEightByteInteger zipEightByteInteger2;
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(this.entry.entry);
            if (bl2) {
                zipEightByteInteger2 = new ZipEightByteInteger(this.entry.entry.getSize());
                zipEightByteInteger = new ZipEightByteInteger(this.entry.entry.getCompressedSize());
            } else {
                zipEightByteInteger = this.entry.entry.getMethod() == 0 && this.entry.entry.getSize() != -1L ? (zipEightByteInteger2 = new ZipEightByteInteger(this.entry.entry.getSize())) : (zipEightByteInteger2 = ZipEightByteInteger.ZERO);
            }
            zip64ExtendedInformationExtraField.setSize(zipEightByteInteger2);
            zip64ExtendedInformationExtraField.setCompressedSize(zipEightByteInteger);
            this.entry.entry.setExtra();
        }
        if (this.entry.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader((ZipArchiveEntry)archiveEntry, bl2);
    }

    private void setDefaults(ZipArchiveEntry zipArchiveEntry) {
        if (zipArchiveEntry.getMethod() == -1) {
            zipArchiveEntry.setMethod(this.method);
        }
        if (zipArchiveEntry.getTime() == -1L) {
            zipArchiveEntry.setTime(System.currentTimeMillis());
        }
    }

    private void validateSizeInformation(Zip64Mode zip64Mode) throws ZipException {
        if (this.entry.entry.getMethod() == 0 && this.channel == null) {
            if (this.entry.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.entry.setCompressedSize(this.entry.entry.getSize());
        }
        if ((this.entry.entry.getSize() >= 0xFFFFFFFFL || this.entry.entry.getCompressedSize() >= 0xFFFFFFFFL) && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(this.entry.entry));
        }
    }

    private boolean shouldAddZip64Extra(ZipArchiveEntry zipArchiveEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() == -1L && this.channel != null && zip64Mode != Zip64Mode.Never;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n2) {
        if (n2 < -1 || n2 > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n2);
        }
        this.hasCompressionLevelChanged = this.level != n2;
        this.level = n2;
    }

    public void setMethod(int n2) {
        this.method = n2;
    }

    @Override
    public boolean canWriteEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return zipArchiveEntry.getMethod() != ZipMethod.IMPLODING.getCode() && zipArchiveEntry.getMethod() != ZipMethod.UNSHRINKING.getCode() && ZipUtil.canHandleEntryData(zipArchiveEntry);
        }
        return false;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(this.entry.entry);
        long l2 = this.streamCompressor.write(byArray, n2, n3, this.entry.entry.getMethod());
        this.count(l2);
    }

    private void writeCounted(byte[] byArray) throws IOException {
        this.streamCompressor.writeCounted(byArray);
    }

    private void copyFromZipInputStream(InputStream inputStream) throws IOException {
        int n2;
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(this.entry.entry);
        this.entry.hasWritten = true;
        while ((n2 = inputStream.read(this.copyBuffer)) >= 0) {
            this.streamCompressor.writeCounted(this.copyBuffer, 0, n2);
            this.count(n2);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.finished) {
                this.finish();
            }
        }
        finally {
            this.destroy();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        this.streamCompressor.deflate();
    }

    protected void writeLocalFileHeader(ZipArchiveEntry zipArchiveEntry) throws IOException {
        this.writeLocalFileHeader(zipArchiveEntry, false);
    }

    private void writeLocalFileHeader(ZipArchiveEntry zipArchiveEntry, boolean bl2) throws IOException {
        boolean bl3 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        ByteBuffer byteBuffer = this.getName(zipArchiveEntry);
        if (this.createUnicodeExtraFields != UnicodeExtraFieldPolicy.NEVER) {
            this.addUnicodeExtraFields(zipArchiveEntry, bl3, byteBuffer);
        }
        long l2 = this.streamCompressor.getTotalBytesWritten();
        byte[] byArray = this.createLocalFileHeader(zipArchiveEntry, byteBuffer, bl3, bl2, l2);
        this.metaData.put(zipArchiveEntry, new EntryMetaData(l2, this.usesDataDescriptor(zipArchiveEntry.getMethod(), bl2)));
        this.entry.localDataStart = l2 + 14L;
        this.writeCounted(byArray);
        this.entry.dataStart = this.streamCompressor.getTotalBytesWritten();
    }

    private byte[] createLocalFileHeader(ZipArchiveEntry zipArchiveEntry, ByteBuffer byteBuffer, boolean bl2, boolean bl3, long l2) {
        int n2;
        int n3;
        ResourceAlignmentExtraField resourceAlignmentExtraField = (ResourceAlignmentExtraField)zipArchiveEntry.getExtraField(ResourceAlignmentExtraField.ID);
        if (resourceAlignmentExtraField != null) {
            zipArchiveEntry.removeExtraField(ResourceAlignmentExtraField.ID);
        }
        if ((n3 = zipArchiveEntry.getAlignment()) <= 0 && resourceAlignmentExtraField != null) {
            n3 = resourceAlignmentExtraField.getAlignment();
        }
        if (n3 > 1 || resourceAlignmentExtraField != null && !resourceAlignmentExtraField.allowMethodChange()) {
            int n4 = 30 + byteBuffer.limit() - byteBuffer.position() + zipArchiveEntry.getLocalFileDataExtra().length;
            n2 = (int)(-l2 - (long)n4 - 4L - 2L & (long)(n3 - 1));
            zipArchiveEntry.addExtraField(new ResourceAlignmentExtraField(n3, resourceAlignmentExtraField != null && resourceAlignmentExtraField.allowMethodChange(), n2));
        }
        byte[] byArray = zipArchiveEntry.getLocalFileDataExtra();
        n2 = byteBuffer.limit() - byteBuffer.position();
        int n5 = 30 + n2 + byArray.length;
        byte[] byArray2 = new byte[n5];
        System.arraycopy(LFH_SIG, 0, byArray2, 0, 4);
        int n6 = zipArchiveEntry.getMethod();
        boolean bl4 = this.usesDataDescriptor(n6, bl3);
        ZipShort.putShort(this.versionNeededToExtract(n6, this.hasZip64Extra(zipArchiveEntry), bl4), byArray2, 4);
        GeneralPurposeBit generalPurposeBit = this.getGeneralPurposeBits(!bl2 && this.fallbackToUTF8, bl4);
        generalPurposeBit.encode(byArray2, 6);
        ZipShort.putShort(n6, byArray2, 8);
        ZipUtil.toDosTime(this.calendarInstance, zipArchiveEntry.getTime(), byArray2, 10);
        if (bl3) {
            ZipLong.putLong(zipArchiveEntry.getCrc(), byArray2, 14);
        } else if (n6 == 8 || this.channel != null) {
            System.arraycopy(LZERO, 0, byArray2, 14, 4);
        } else {
            ZipLong.putLong(zipArchiveEntry.getCrc(), byArray2, 14);
        }
        if (this.hasZip64Extra(this.entry.entry)) {
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 18);
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 22);
        } else if (bl3) {
            ZipLong.putLong(zipArchiveEntry.getCompressedSize(), byArray2, 18);
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 22);
        } else if (n6 == 8 || this.channel != null) {
            System.arraycopy(LZERO, 0, byArray2, 18, 4);
            System.arraycopy(LZERO, 0, byArray2, 22, 4);
        } else {
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 18);
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 22);
        }
        ZipShort.putShort(n2, byArray2, 26);
        ZipShort.putShort(byArray.length, byArray2, 28);
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray2, 30, n2);
        System.arraycopy(byArray, 0, byArray2, 30 + n2, byArray.length);
        return byArray2;
    }

    private void addUnicodeExtraFields(ZipArchiveEntry zipArchiveEntry, boolean bl2, ByteBuffer byteBuffer) throws IOException {
        String string;
        if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl2) {
            zipArchiveEntry.addExtraField(new UnicodePathExtraField(zipArchiveEntry.getName(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position()));
        }
        if ((string = zipArchiveEntry.getComment()) != null && !"".equals(string)) {
            boolean bl3 = this.zipEncoding.canEncode(string);
            if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl3) {
                ByteBuffer byteBuffer2 = this.getEntryEncoding(zipArchiveEntry).encode(string);
                zipArchiveEntry.addExtraField(new UnicodeCommentExtraField(string, byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit() - byteBuffer2.position()));
            }
        }
    }

    protected void writeDataDescriptor(ZipArchiveEntry zipArchiveEntry) throws IOException {
        if (!this.usesDataDescriptor(zipArchiveEntry.getMethod(), false)) {
            return;
        }
        this.writeCounted(DD_SIG);
        this.writeCounted(ZipLong.getBytes(zipArchiveEntry.getCrc()));
        if (!this.hasZip64Extra(zipArchiveEntry)) {
            this.writeCounted(ZipLong.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeCounted(ZipLong.getBytes(zipArchiveEntry.getSize()));
        } else {
            this.writeCounted(ZipEightByteInteger.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeCounted(ZipEightByteInteger.getBytes(zipArchiveEntry.getSize()));
        }
    }

    protected void writeCentralFileHeader(ZipArchiveEntry zipArchiveEntry) throws IOException {
        byte[] byArray = this.createCentralFileHeader(zipArchiveEntry);
        this.writeCounted(byArray);
    }

    private byte[] createCentralFileHeader(ZipArchiveEntry zipArchiveEntry) throws IOException {
        boolean bl2;
        EntryMetaData entryMetaData = this.metaData.get(zipArchiveEntry);
        boolean bl3 = bl2 = this.hasZip64Extra(zipArchiveEntry) || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || entryMetaData.offset >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always;
        if (bl2 && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        this.handleZip64Extra(zipArchiveEntry, entryMetaData.offset, bl2);
        return this.createCentralFileHeader(zipArchiveEntry, this.getName(zipArchiveEntry), entryMetaData, bl2);
    }

    private byte[] createCentralFileHeader(ZipArchiveEntry zipArchiveEntry, ByteBuffer byteBuffer, EntryMetaData entryMetaData, boolean bl2) throws IOException {
        byte[] byArray = zipArchiveEntry.getCentralDirectoryExtra();
        String string = zipArchiveEntry.getComment();
        if (string == null) {
            string = "";
        }
        ByteBuffer byteBuffer2 = this.getEntryEncoding(zipArchiveEntry).encode(string);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        int n3 = byteBuffer2.limit() - byteBuffer2.position();
        int n4 = 46 + n2 + byArray.length + n3;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(CFH_SIG, 0, byArray2, 0, 4);
        ZipShort.putShort(zipArchiveEntry.getPlatform() << 8 | (!this.hasUsedZip64 ? 20 : 45), byArray2, 4);
        int n5 = zipArchiveEntry.getMethod();
        boolean bl3 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        ZipShort.putShort(this.versionNeededToExtract(n5, bl2, entryMetaData.usesDataDescriptor), byArray2, 6);
        this.getGeneralPurposeBits(!bl3 && this.fallbackToUTF8, entryMetaData.usesDataDescriptor).encode(byArray2, 8);
        ZipShort.putShort(n5, byArray2, 10);
        ZipUtil.toDosTime(this.calendarInstance, zipArchiveEntry.getTime(), byArray2, 12);
        ZipLong.putLong(zipArchiveEntry.getCrc(), byArray2, 16);
        if (zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 20);
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 24);
        } else {
            ZipLong.putLong(zipArchiveEntry.getCompressedSize(), byArray2, 20);
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 24);
        }
        ZipShort.putShort(n2, byArray2, 28);
        ZipShort.putShort(byArray.length, byArray2, 30);
        ZipShort.putShort(n3, byArray2, 32);
        System.arraycopy(ZERO, 0, byArray2, 34, 2);
        ZipShort.putShort(zipArchiveEntry.getInternalAttributes(), byArray2, 36);
        ZipLong.putLong(zipArchiveEntry.getExternalAttributes(), byArray2, 38);
        if (entryMetaData.offset >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.putLong(0xFFFFFFFFL, byArray2, 42);
        } else {
            ZipLong.putLong(Math.min(entryMetaData.offset, 0xFFFFFFFFL), byArray2, 42);
        }
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray2, 46, n2);
        int n6 = 46 + n2;
        System.arraycopy(byArray, 0, byArray2, n6, byArray.length);
        int n7 = n6 + byArray.length;
        System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset(), byArray2, n7, n3);
        return byArray2;
    }

    private void handleZip64Extra(ZipArchiveEntry zipArchiveEntry, long l2, boolean bl2) {
        if (bl2) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(zipArchiveEntry);
            if (zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipArchiveEntry.getCompressedSize()));
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipArchiveEntry.getSize()));
            } else {
                zip64ExtendedInformationExtraField.setCompressedSize(null);
                zip64ExtendedInformationExtraField.setSize(null);
            }
            if (l2 >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
                zip64ExtendedInformationExtraField.setRelativeHeaderOffset(new ZipEightByteInteger(l2));
            }
            zipArchiveEntry.setExtra();
        }
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeCounted(EOCD_SIG);
        this.writeCounted(ZERO);
        this.writeCounted(ZERO);
        int n2 = this.entries.size();
        if (n2 > 65535 && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive contains more than 65535 entries.");
        }
        if (this.cdOffset > 0xFFFFFFFFL && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        byte[] byArray = ZipShort.getBytes(Math.min(n2, 65535));
        this.writeCounted(byArray);
        this.writeCounted(byArray);
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdLength, 0xFFFFFFFFL)));
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdOffset, 0xFFFFFFFFL)));
        ByteBuffer byteBuffer = this.zipEncoding.encode(this.comment);
        int n3 = byteBuffer.limit() - byteBuffer.position();
        this.writeCounted(ZipShort.getBytes(n3));
        this.streamCompressor.writeCounted(byteBuffer.array(), byteBuffer.arrayOffset(), n3);
    }

    protected void writeZip64CentralDirectory() throws IOException {
        if (this.zip64Mode == Zip64Mode.Never) {
            return;
        }
        if (!(this.hasUsedZip64 || this.cdOffset < 0xFFFFFFFFL && this.cdLength < 0xFFFFFFFFL && this.entries.size() < 65535)) {
            this.hasUsedZip64 = true;
        }
        if (!this.hasUsedZip64) {
            return;
        }
        long l2 = this.streamCompressor.getTotalBytesWritten();
        this.writeOut(ZIP64_EOCD_SIG);
        this.writeOut(ZipEightByteInteger.getBytes(44L));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(LZERO);
        this.writeOut(LZERO);
        byte[] byArray = ZipEightByteInteger.getBytes(this.entries.size());
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipEightByteInteger.getBytes(this.cdLength));
        this.writeOut(ZipEightByteInteger.getBytes(this.cdOffset));
        this.writeOut(ZIP64_EOCD_LOC_SIG);
        this.writeOut(LZERO);
        this.writeOut(ZipEightByteInteger.getBytes(l2));
        this.writeOut(ONE);
    }

    protected final void writeOut(byte[] byArray) throws IOException {
        this.streamCompressor.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n2, int n3) throws IOException {
        this.streamCompressor.writeOut(byArray, n2, n3);
    }

    private GeneralPurposeBit getGeneralPurposeBits(boolean bl2, boolean bl3) {
        GeneralPurposeBit generalPurposeBit = new GeneralPurposeBit();
        generalPurposeBit.useUTF8ForNames(this.useUTF8Flag || bl2);
        if (bl3) {
            generalPurposeBit.useDataDescriptor(true);
        }
        return generalPurposeBit;
    }

    private int versionNeededToExtract(int n2, boolean bl2, boolean bl3) {
        if (bl2) {
            return 45;
        }
        if (bl3) {
            return 20;
        }
        return this.versionNeededToExtractMethod(n2);
    }

    private boolean usesDataDescriptor(int n2, boolean bl2) {
        return !bl2 && n2 == 8 && this.channel == null;
    }

    private int versionNeededToExtractMethod(int n2) {
        return n2 == 8 ? 20 : 10;
    }

    @Override
    public ArchiveEntry createArchiveEntry(File file, String string) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new ZipArchiveEntry(file, string);
    }

    private Zip64ExtendedInformationExtraField getZip64Extra(ZipArchiveEntry zipArchiveEntry) {
        if (this.entry != null) {
            this.entry.causedUseOfZip64 = !this.hasUsedZip64;
        }
        this.hasUsedZip64 = true;
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField == null) {
            zip64ExtendedInformationExtraField = new Zip64ExtendedInformationExtraField();
        }
        zipArchiveEntry.addAsFirstExtraField(zip64ExtendedInformationExtraField);
        return zip64ExtendedInformationExtraField;
    }

    private boolean hasZip64Extra(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID) != null;
    }

    private Zip64Mode getEffectiveZip64Mode(ZipArchiveEntry zipArchiveEntry) {
        if (this.zip64Mode != Zip64Mode.AsNeeded || this.channel != null || zipArchiveEntry.getMethod() != 8 || zipArchiveEntry.getSize() != -1L) {
            return this.zip64Mode;
        }
        return Zip64Mode.Never;
    }

    private ZipEncoding getEntryEncoding(ZipArchiveEntry zipArchiveEntry) {
        boolean bl2 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        return !bl2 && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
    }

    private ByteBuffer getName(ZipArchiveEntry zipArchiveEntry) throws IOException {
        return this.getEntryEncoding(zipArchiveEntry).encode(zipArchiveEntry.getName());
    }

    void destroy() throws IOException {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
    }

    private static final class EntryMetaData {
        private final long offset;
        private final boolean usesDataDescriptor;

        private EntryMetaData(long l2, boolean bl2) {
            this.offset = l2;
            this.usesDataDescriptor = bl2;
        }
    }

    private static final class CurrentEntry {
        private final ZipArchiveEntry entry;
        private long localDataStart = 0L;
        private long dataStart = 0L;
        private long bytesRead = 0L;
        private boolean causedUseOfZip64 = false;
        private boolean hasWritten;

        private CurrentEntry(ZipArchiveEntry zipArchiveEntry) {
            this.entry = zipArchiveEntry;
        }
    }

    public static final class UnicodeExtraFieldPolicy {
        public static final UnicodeExtraFieldPolicy ALWAYS = new UnicodeExtraFieldPolicy("always");
        public static final UnicodeExtraFieldPolicy NEVER = new UnicodeExtraFieldPolicy("never");
        public static final UnicodeExtraFieldPolicy NOT_ENCODEABLE = new UnicodeExtraFieldPolicy("not encodeable");
        private final String name;

        private UnicodeExtraFieldPolicy(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

