/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.zip.AbstractUnicodeExtraField;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;

public abstract class ZipUtil {
    private static final byte[] DOS_TIME_MIN = ZipLong.getBytes(8448L);

    public static ZipLong toDosTime(Date date) {
        return new ZipLong(ZipUtil.toDosTime(date.getTime()));
    }

    public static byte[] toDosTime(long l2) {
        byte[] byArray = new byte[4];
        ZipUtil.toDosTime(l2, byArray, 0);
        return byArray;
    }

    public static void toDosTime(long l2, byte[] byArray, int n2) {
        ZipUtil.toDosTime(Calendar.getInstance(), l2, byArray, n2);
    }

    static void toDosTime(Calendar calendar, long l2, byte[] byArray, int n2) {
        calendar.setTimeInMillis(l2);
        int n3 = calendar.get(1);
        if (n3 < 1980) {
            System.arraycopy(DOS_TIME_MIN, 0, byArray, n2, DOS_TIME_MIN.length);
            return;
        }
        int n4 = calendar.get(2) + 1;
        long l3 = n3 - 1980 << 25 | n4 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
        ZipLong.putLong(l3, byArray, n2);
    }

    public static long adjustToLong(int n2) {
        if (n2 < 0) {
            return 0x100000000L + (long)n2;
        }
        return n2;
    }

    public static byte[] reverse(byte[] byArray) {
        int n2 = byArray.length - 1;
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by2 = byArray[i2];
            byArray[i2] = byArray[n2 - i2];
            byArray[n2 - i2] = by2;
        }
        return byArray;
    }

    static long bigToLong(BigInteger bigInteger) {
        if (bigInteger.bitLength() <= 63) {
            return bigInteger.longValue();
        }
        throw new NumberFormatException("The BigInteger cannot fit inside a 64 bit java long: [" + bigInteger + "]");
    }

    static BigInteger longToBig(long l2) {
        if (l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Negative longs < -2^31 not permitted: [" + l2 + "]");
        }
        if (l2 < 0L && l2 >= Integer.MIN_VALUE) {
            l2 = ZipUtil.adjustToLong((int)l2);
        }
        return BigInteger.valueOf(l2);
    }

    public static int signedByteToUnsignedInt(byte by2) {
        if (by2 >= 0) {
            return by2;
        }
        return 256 + by2;
    }

    public static byte unsignedIntToSignedByte(int n2) {
        if (n2 > 255 || n2 < 0) {
            throw new IllegalArgumentException("Can only convert non-negative integers between [0,255] to byte: [" + n2 + "]");
        }
        if (n2 < 128) {
            return (byte)n2;
        }
        return (byte)(n2 - 256);
    }

    public static Date fromDosTime(ZipLong zipLong) {
        long l2 = zipLong.getValue();
        return new Date(ZipUtil.dosToJavaTime(l2));
    }

    public static long dosToJavaTime(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)(l2 >> 25 & 0x7FL) + 1980);
        calendar.set(2, (int)(l2 >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l2 >> 16) & 0x1F);
        calendar.set(11, (int)(l2 >> 11) & 0x1F);
        calendar.set(12, (int)(l2 >> 5) & 0x3F);
        calendar.set(13, (int)(l2 << 1) & 0x3E);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    static void setNameAndCommentFromExtraFields(ZipArchiveEntry zipArchiveEntry, byte[] byArray, byte[] byArray2) {
        UnicodeCommentExtraField unicodeCommentExtraField;
        String string;
        UnicodePathExtraField unicodePathExtraField = (UnicodePathExtraField)zipArchiveEntry.getExtraField(UnicodePathExtraField.UPATH_ID);
        String string2 = ZipUtil.getUnicodeStringIfOriginalMatches(unicodePathExtraField, byArray);
        if (string2 != null) {
            zipArchiveEntry.setName(string2);
            zipArchiveEntry.setNameSource(ZipArchiveEntry.NameSource.UNICODE_EXTRA_FIELD);
        }
        if (byArray2 != null && byArray2.length > 0 && (string = ZipUtil.getUnicodeStringIfOriginalMatches(unicodeCommentExtraField = (UnicodeCommentExtraField)zipArchiveEntry.getExtraField(UnicodeCommentExtraField.UCOM_ID), byArray2)) != null) {
            zipArchiveEntry.setComment(string);
            zipArchiveEntry.setCommentSource(ZipArchiveEntry.CommentSource.UNICODE_EXTRA_FIELD);
        }
    }

    private static String getUnicodeStringIfOriginalMatches(AbstractUnicodeExtraField abstractUnicodeExtraField, byte[] byArray) {
        if (abstractUnicodeExtraField != null) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            long l2 = cRC32.getValue();
            if (l2 == abstractUnicodeExtraField.getNameCRC32()) {
                try {
                    return ZipEncodingHelper.UTF8_ZIP_ENCODING.decode(abstractUnicodeExtraField.getUnicodeName());
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        return null;
    }

    static byte[] copy(byte[] byArray) {
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return null;
    }

    static void copy(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        }
    }

    static boolean canHandleEntryData(ZipArchiveEntry zipArchiveEntry) {
        return ZipUtil.supportsEncryptionOf(zipArchiveEntry) && ZipUtil.supportsMethodOf(zipArchiveEntry);
    }

    private static boolean supportsEncryptionOf(ZipArchiveEntry zipArchiveEntry) {
        return !zipArchiveEntry.getGeneralPurposeBit().usesEncryption();
    }

    private static boolean supportsMethodOf(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getMethod() == 0 || zipArchiveEntry.getMethod() == ZipMethod.UNSHRINKING.getCode() || zipArchiveEntry.getMethod() == ZipMethod.IMPLODING.getCode() || zipArchiveEntry.getMethod() == 8 || zipArchiveEntry.getMethod() == ZipMethod.ENHANCED_DEFLATED.getCode() || zipArchiveEntry.getMethod() == ZipMethod.BZIP2.getCode();
    }

    static void checkRequestedFeatures(ZipArchiveEntry zipArchiveEntry) throws UnsupportedZipFeatureException {
        if (!ZipUtil.supportsEncryptionOf(zipArchiveEntry)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.ENCRYPTION, zipArchiveEntry);
        }
        if (!ZipUtil.supportsMethodOf(zipArchiveEntry)) {
            ZipMethod zipMethod = ZipMethod.getMethodByCode(zipArchiveEntry.getMethod());
            if (zipMethod == null) {
                throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.METHOD, zipArchiveEntry);
            }
            throw new UnsupportedZipFeatureException(zipMethod, zipArchiveEntry);
        }
    }
}

