/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FileNameUtil {
    private final Map<String, String> compressSuffix = new HashMap<String, String>();
    private final Map<String, String> uncompressSuffix;
    private final int longestCompressedSuffix;
    private final int shortestCompressedSuffix;
    private final int longestUncompressedSuffix;
    private final int shortestUncompressedSuffix;
    private final String defaultExtension;

    public FileNameUtil(Map<String, String> map, String string) {
        this.uncompressSuffix = Collections.unmodifiableMap(map);
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2;
            int n6;
            int n7 = entry.getKey().length();
            if (n7 > n2) {
                n2 = n7;
            }
            if (n7 < n3) {
                n3 = n7;
            }
            if ((n6 = (string2 = entry.getValue()).length()) <= 0) continue;
            if (!this.compressSuffix.containsKey(string2)) {
                this.compressSuffix.put(string2, entry.getKey());
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (n6 >= n5) continue;
            n5 = n6;
        }
        this.longestCompressedSuffix = n2;
        this.longestUncompressedSuffix = n4;
        this.shortestCompressedSuffix = n3;
        this.shortestUncompressedSuffix = n5;
        this.defaultExtension = string;
    }

    public boolean isCompressedFilename(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        int n2 = string2.length();
        for (int i2 = this.shortestCompressedSuffix; i2 <= this.longestCompressedSuffix && i2 < n2; ++i2) {
            if (!this.uncompressSuffix.containsKey(string2.substring(n2 - i2))) continue;
            return true;
        }
        return false;
    }

    public String getUncompressedFilename(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        int n2 = string2.length();
        for (int i2 = this.shortestCompressedSuffix; i2 <= this.longestCompressedSuffix && i2 < n2; ++i2) {
            String string3 = this.uncompressSuffix.get(string2.substring(n2 - i2));
            if (string3 == null) continue;
            return string.substring(0, n2 - i2) + string3;
        }
        return string;
    }

    public String getCompressedFilename(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        int n2 = string2.length();
        for (int i2 = this.shortestUncompressedSuffix; i2 <= this.longestUncompressedSuffix && i2 < n2; ++i2) {
            String string3 = this.compressSuffix.get(string2.substring(n2 - i2));
            if (string3 == null) continue;
            return string.substring(0, n2 - i2) + string3;
        }
        return string + this.defaultExtension;
    }
}

