/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.brotli.dec.BrotliInputStream;

public class BrotliCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final BrotliInputStream decIS;

    public BrotliCompressorInputStream(InputStream inputStream) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.decIS = new BrotliInputStream((InputStream)this.countingStream);
    }

    @Override
    public int available() throws IOException {
        return this.decIS.available();
    }

    @Override
    public void close() throws IOException {
        this.decIS.close();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.decIS.read(byArray);
    }

    @Override
    public long skip(long l2) throws IOException {
        return IOUtils.skip((InputStream)this.decIS, l2);
    }

    @Override
    public void mark(int n2) {
        this.decIS.mark(n2);
    }

    @Override
    public boolean markSupported() {
        return this.decIS.markSupported();
    }

    @Override
    public int read() throws IOException {
        int n2 = this.decIS.read();
        this.count(n2 == -1 ? 0 : 1);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.decIS.read(byArray, n2, n3);
        this.count(n4);
        return n4;
    }

    public String toString() {
        return this.decIS.toString();
    }

    @Override
    public void reset() throws IOException {
        this.decIS.reset();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }
}

