/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

public class BrotliUtils {
    private static volatile CachedAvailability cachedBrotliAvailability = CachedAvailability.DONT_CACHE;

    private BrotliUtils() {
    }

    public static boolean isBrotliCompressionAvailable() {
        CachedAvailability cachedAvailability = cachedBrotliAvailability;
        if (cachedAvailability != CachedAvailability.DONT_CACHE) {
            return cachedAvailability == CachedAvailability.CACHED_AVAILABLE;
        }
        return BrotliUtils.internalIsBrotliCompressionAvailable();
    }

    private static boolean internalIsBrotliCompressionAvailable() {
        try {
            Class.forName("org.brotli.dec.BrotliInputStream");
            return true;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return false;
        }
    }

    public static void setCacheBrotliAvailablity(boolean bl2) {
        if (!bl2) {
            cachedBrotliAvailability = CachedAvailability.DONT_CACHE;
        } else if (cachedBrotliAvailability == CachedAvailability.DONT_CACHE) {
            boolean bl3 = BrotliUtils.internalIsBrotliCompressionAvailable();
            cachedBrotliAvailability = bl3 ? CachedAvailability.CACHED_AVAILABLE : CachedAvailability.CACHED_UNAVAILABLE;
        }
    }

    static CachedAvailability getCachedBrotliAvailability() {
        return cachedBrotliAvailability;
    }

    static {
        try {
            Class.forName("org.osgi.framework.BundleEvent");
        }
        catch (Exception exception) {
            BrotliUtils.setCacheBrotliAvailablity(true);
        }
    }

    static enum CachedAvailability {
        DONT_CACHE,
        CACHED_AVAILABLE,
        CACHED_UNAVAILABLE;

    }
}

